package org.modelversioning.diagram.merge.ui.popup.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ResolveConflictAction implements IObjectActionDelegate {

	private IWorkbenchPart targetPart;
	private ISelection selection;
	private Shell shell;

	/**
	 * Constructor for Action1.
	 */
	public ResolveConflictAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.targetPart = targetPart;
		this.shell = targetPart.getSite().getShell();
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			System.out.println(selection);
			if (structuredSelection.getFirstElement() instanceof EditPart) {
				ShapeNodeEditPart editPart = (ShapeNodeEditPart) structuredSelection.getFirstElement();
				System.out.println("execute action: " + editPart);
			}
		}
		
		MessageDialog.openInformation(
			shell,
			"DiagramMergeActions",
			"Resolve Conflict was executed on target: \n" + selection); 
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

}
