/**
 * <copyright>
 *
 * Copyright (c) 2010 modelversioning.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */

package org.modelversioning.diagram.merge.ui.providers;

import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;

/**
 * A {@link IDecoratorProvider} for the Conflict Diagram.
 * 
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * 
 */
public class ConflictDiagramDecoratorProvider extends AbstractProvider
		implements IDecoratorProvider {

	public static final String CONFLICT_DECORATOR_ID = "org.modelversioning.diagram.merge.ui.providers.conflictDecorator";
	public static final String REVERT_DECORATOR_ID = "org.modelversioning.diagram.merge.ui.providers.revertDecorator";

	@Override
	public boolean provides(IOperation operation) {
		if (false == operation instanceof CreateDecoratorsOperation) {
			return false;
		}
		IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation) operation)
				.getDecoratorTarget();
		return ConflictDecorator.getDecoratorTargetNode(decoratorTarget) != null;
	}

	@Override
	public void createDecorators(IDecoratorTarget decoratorTarget) {
		View node = ConflictDecorator.getDecoratorTargetNode(decoratorTarget);

		if (node != null) {
			decoratorTarget.installDecorator(CONFLICT_DECORATOR_ID,
					new ConflictDecorator(decoratorTarget));
			decoratorTarget.installDecorator(REVERT_DECORATOR_ID,
					new RevertDecorator(decoratorTarget));
		}
	}
}
