/**
 * <copyright>
 *
 * Copyright (c) 2010 modelversioning.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */

package org.modelversioning.merge.conflictdiagram.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.conflictreport.ConflictReport;
import org.modelversioning.conflictreport.conflict.Conflict;

/**
 * Interface for merging two models based on a {@link ConflictReport}.
 * 
 * @author Petra Brosch
 *
 */

public interface IConflictDiagramMergeEngine {
	
	/**
	 * Merges and annotates two models and all diagrams referenced by the specified <code>conflictReport</code> 
	 * considering {@link Conflict}s.
	 *  
	 * @param conflictReport
	 *            the conflictReport the merge is based on.
	 * @param mergedResources
	 * 			  the list of resources the merged models should be persisted in.
	 * @param monitor
	 * 			  the progress monitor to report to.
	 * @return merged model and diagram.
	 */
	public EList<Resource> merge(ConflictReport conflictReport, EList<Resource> mergedResources, IProgressMonitor monitor);

}
