/**
 * <copyright>
 *
 * Copyright (c) 2011 modelversioning.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */

package org.modelversioning.merge.conflictdiagram.engine.impl;

import java.util.List;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.merge.conflictdiagram.util.MergeUtil;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * 
 */
public class ConflictDiagramMergeListener implements IMergeListener {

	private MergeUtil mergeUtil = null;

	public ConflictDiagramMergeListener(MergeUtil mergeUtil) {
		this.mergeUtil = mergeUtil;
	}

	@Override
	public void mergeDiffEnd(MergeEvent event) {
	}

	@Override
	public void mergeDiffStart(MergeEvent event) {
		rewireElementReference(event.getDifferences());
	}

	@Override
	public void mergeOperationEnd(MergeEvent event) {
	}

	@Override
	public void mergeOperationStart(MergeEvent event) {
	}

	private void rewireElementReference(List<DiffElement> differences) {
		for (DiffElement diff : differences) {
			if (!(diff instanceof DiffGroup)) {
				EObject leftElement = DiffUtil.getLeftElement(diff);

				if (leftElement instanceof View) {
					View viewElement = (View) leftElement;
					EObject refElement = viewElement.getElement();

					if (refElement != null) {
						EObject counterpart = null;

						counterpart = mergeUtil.getCounterpart(EcoreUtil
								.getURI(refElement).fragment());

						if (counterpart == null) {
							// try to find counterpart on similarity basis!
							counterpart = getCounterpartObjectBySimilarity(
									refElement,
									mergeUtil
											.getCounterpart(EcoreUtil.getURI(
													refElement.eContainer())
													.fragment()));
						}

						// no counterpart found
						if (counterpart == null) {
							System.err.println("counterpart of view "
									+ EcoreUtil.getURI(viewElement)
									+ " is null! refElement: "
									+ EcoreUtil.getURI(refElement).fragment());
						}

						if (counterpart != null)
							viewElement.setElement(counterpart);
					}
				}
			}
			rewireElementReference(diff.getSubDiffElements());
		}
	}

	/**
	 * Utility method for finding a counterpart object in case of ecore copier
	 * does not copy UUIDs, e.g., for contained additions. Searches in
	 * <code>rightParent</code>'s children for the corresponding element to
	 * <code>leftElement</code> based on the object's structure.
	 * 
	 * @param leftElement
	 *            The element to find a counterpart for.
	 * @param rightParent
	 *            The subtree to search in.
	 * @return The corresponding counterpart object or null if no counterpart is
	 *         found.
	 */
	private EObject getCounterpartObjectBySimilarity(EObject leftElement,
			EObject rightParent) {
		Assert.isTrue(leftElement != null,
				"getCounterpartObjectByStructuralSimilarity: leftElement is null");
		Assert.isTrue(rightParent != null,
				"getCounterpartObjectByStructuralSimilarity: rightParent is null");
		if (EcoreUtil.equals(leftElement, rightParent)) {
			return rightParent;
		}

		for (EObject o : rightParent.eContents()) {
			if (isSimilar(leftElement, o)) {
//			if (EcoreUtil.equals(leftElement, o)) {
				return o;
			}
			getCounterpartObjectBySimilarity(leftElement, o);
		}
		return null;
	}
	
	private boolean isSimilar(EObject o1, EObject o2) {
		boolean equal = false;
		if (o1.eClass().equals(o2.eClass())) {
			equal = true;
			EList<EAttribute> attributes = o1.eClass().getEAllAttributes();
			for (EAttribute attribute : attributes) {
				if (! o1.eGet(attribute).equals(o2.eGet(attribute))) {
					equal = false;
					break;
				}
			}
		
//			EList<EReference> references = o1.eClass().getEAllReferences();	
//			for (EReference r : references) {
//				if (r.isChangeable() && !r.isDerived()) {
//					
//					if (!r.isMany()) {
//						Object r1 = o1.eGet(r);
//						Object r2 = o2.eGet(r);
//						
//						System.out.println(r1);
//						System.out.println(r2);
//					}
//					
//				}
//			}
			
			return equal;
		}
		return equal;
	}
}
