/**
 * <copyright>
 *
 * Copyright (c) 2010 modelversioning.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelversioning.merge.conflictdiagram.engine.impl;

import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.merge.conflictdiagram.util.MergeUtil;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public class RevertMergeListener implements IMergeListener {
	
	private MergeUtil mergeUtil = null;
	
	public RevertMergeListener(MergeUtil mergeUtil) {
		this.mergeUtil = mergeUtil;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.compare.diff.merge.IMergeListener#mergeDiffEnd(org.eclipse.emf.compare.diff.merge.MergeEvent)
	 */
	@Override
	public void mergeDiffEnd(MergeEvent event) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.compare.diff.merge.IMergeListener#mergeDiffStart(org.eclipse.emf.compare.diff.merge.MergeEvent)
	 */
	@Override
	public void mergeDiffStart(MergeEvent event) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.compare.diff.merge.IMergeListener#mergeOperationEnd(org.eclipse.emf.compare.diff.merge.MergeEvent)
	 */
	@Override
	public void mergeOperationEnd(MergeEvent event) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.compare.diff.merge.IMergeListener#mergeOperationStart(org.eclipse.emf.compare.diff.merge.MergeEvent)
	 */
	@Override
	public void mergeOperationStart(MergeEvent event) {
		System.out.println("mergeOperationStart: " + event);
		System.out.println(event.getDifferences());
		for (DiffElement diff : event.getDifferences()) {
			System.out.println("eContainer: " + diff.eContainer());
			if (diff instanceof ModelElementChangeLeftTarget) {
				ModelElementChangeLeftTarget change = (ModelElementChangeLeftTarget)diff;
				change.setLeftElement(mergeUtil.getCounterpart(diff));
			}
			else if (diff instanceof ModelElementChangeRightTarget) {
				ModelElementChangeRightTarget change = (ModelElementChangeRightTarget)diff;
				change.setRightElement(mergeUtil.getCounterpart(diff));
			}
		}
	}

}
