//package org.modelversioning.merge.conflictdiagram.util;
//
//import java.io.IOException;
//import java.util.Collections;
//
//import org.eclipse.core.resources.IFile;
//import org.eclipse.core.runtime.IProgressMonitor;
//import org.eclipse.core.runtime.Path;
//import org.eclipse.core.runtime.SubMonitor;
//import org.eclipse.core.runtime.SubProgressMonitor;
//import org.eclipse.emf.common.util.URI;
//import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
//import org.eclipse.emf.compare.match.metamodel.MatchModel;
//import org.eclipse.emf.ecore.resource.Resource;
//import org.eclipse.emf.ecore.resource.ResourceSet;
//import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
//import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
//import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
//import org.eclipse.gmf.runtime.notation.Diagram;
//import org.eclipse.uml2.uml.resource.UMLResource;
//import org.modelversioning.conflictreport.ConflictReport;
//import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
//import org.modelversioning.conflicts.detection.impl.ConflictDetectionEngineImpl;
//import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;
//import org.modelversioning.core.impl.UUIDResourceFactoryImpl;
//import org.modelversioning.core.match.MatchException;
//import org.modelversioning.core.match.service.MatchService;
//import org.modelversioning.core.util.ModelDiagramUtil;
//import org.modelversioning.merge.conflictdiagram.ConflictDiagramPlugin;
//import org.modelversioning.operations.detection.service.OperationDetectionService;
//
//public class ConflictReportUtil {
//
//	public static ConflictReport createConflictReport(IFile originFile,
//			IFile leftFile, IFile rightFile, IProgressMonitor progressMonitor)
//			throws MatchException, IOException {
//
//		SubMonitor monitor = SubMonitor.convert(progressMonitor);
//
//		// reading files
//		monitor.subTask("Reading files");
//		ResourceSet resourceSet = new ResourceSetImpl();
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put(UMLResource.FILE_EXTENSION, UMLResource.Factory.INSTANCE);
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("umlclass", new GMFResourceFactory());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("umlseq", new GMFResourceFactory());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("ecore", new UUIDResourceFactoryImpl());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("ecorediag", new GMFResourceFactory());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("xmi", new UUIDResourceFactoryImpl());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("conflict", new UUIDResourceFactoryImpl());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("conflictreport", new UUIDResourceFactoryImpl());
//		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
//				.put("operation", new EcoreResourceFactoryImpl());
//		resourceSet
//				.getResourceFactoryRegistry()
//				.getExtensionToFactoryMap()
//				.put(Resource.Factory.Registry.DEFAULT_EXTENSION,
//						new UUIDResourceFactoryImpl());
//
//		Resource originResource = resourceSet.getResource(URI
//				.createPlatformResourceURI(originFile.getFullPath().toString(),
//						true), true);
//		Resource leftResource = resourceSet.getResource(URI
//				.createPlatformResourceURI(leftFile.getFullPath().toString(),
//						true), true);
//		Resource rightResource = resourceSet.getResource(URI
//				.createPlatformResourceURI(rightFile.getFullPath().toString(),
//						true), true);
//		monitor.worked(1);
//
//		// detecting diagrams
//		Resource originModel = null;
//		Resource leftModel = null;
//		Resource rightModel = null;
//		Resource originDiagram = null;
//		Resource leftDiagram = null;
//		Resource rightDiagram = null;
//
//		monitor.subTask("Analyzing content");
//		if (ModelDiagramUtil.containsDiagram(originResource)) {
//			originDiagram = originResource;
//			originModel = ((Diagram) originDiagram.getContents().get(0))
//					.getElement().eResource();
//
//			leftDiagram = leftResource;
//			leftModel = ((Diagram) leftDiagram.getContents().get(0))
//					.getElement().eResource();
//
//			rightDiagram = rightResource;
//			rightModel = ((Diagram) rightDiagram.getContents().get(0))
//					.getElement().eResource();
//		} else {
//			originModel = originResource;
//			leftModel = leftResource;
//			rightModel = rightResource;
//		}
//		monitor.worked(1);
//
//		// Matching
//		monitor.subTask("Matching models");
//		MatchService matchEngine = new MatchService();
//		// ECLEnhancedUUIDMatchEngine matchEngine = new
//		// ECLEnhancedUUIDMatchEngine() {
//		// @Override
//		// protected ECLMatcher getECLMatcher(MatchModel matchModel) {
//		// return new ECLFileMatcherImpl(
//		// UMLPackage.eNS_URI,
//		// new File(
//		// "/home/petra/big/amor/final/dev/plugins/org.modelversioning.ecl.matcher/ecl/natural-ids/uml.ecl")
//		// .toURI());
//		// }
//		// };
//
//		MatchModel match1 = matchEngine.generateMatchModel(originModel,
//				leftModel);
//		MatchModel match2 = matchEngine.generateMatchModel(originModel,
//				rightModel);
//		monitor.worked(1);
//
//		// Diffing
//		monitor.subTask("Diffing models");
//		org.modelversioning.core.diff.service.DiffService diffService = new org.modelversioning.core.diff.service.DiffService();
//		ComparisonResourceSnapshot crs1 = diffService
//				.generateComparisonResourceSnapshot(match1);
//		ComparisonResourceSnapshot crs2 = diffService
//				.generateComparisonResourceSnapshot(match2);
//		OperationDetectionService operationDetectionService = new OperationDetectionService();
//		operationDetectionService.findAndAddOperationOccurrences(crs1);
//		operationDetectionService.findAndAddOperationOccurrences(crs2);
//		monitor.worked(1);
//
//		// Creating DiffProvider
//		monitor.subTask("Reading diffs");
//		IThreeWayDiffProvider threeWayDiff = new ThreeWayDiffProvider(crs1,
//				crs2);
//		monitor.worked(1);
//
//		// Detecting Conflicts
//		monitor.subTask("Detecting conflicts");
//		ConflictDetectionEngineImpl engine = new ConflictDetectionEngineImpl();
//		engine.setOperationContractViolationAware(true);
////		engine.getOverlappingChangeDetectors()
////				.add(new AddAddConflictDetector());
//		ConflictReport conflictReport = engine.detectConflicts(threeWayDiff,
//				new SubProgressMonitor(monitor, 1));
//		monitor.worked(1);
//
//		// Matching Diagrams
//		monitor.subTask("Matching diagrams");
//		MatchService matchService = new MatchService();
//		MatchModel match1_diagram = null;
//		MatchModel match2_diagram = null;
//		if (originDiagram != null) {
//			match1_diagram = matchService.generateMatchModel(originDiagram,
//					leftDiagram);
//			match2_diagram = matchService.generateMatchModel(originDiagram,
//					rightDiagram);
//		}
//		monitor.worked(1);
//
//		// Diffing Diagrams
//		monitor.subTask("Diffing diagrams");
//		ComparisonResourceSnapshot crs1_diagram = null;
//		ComparisonResourceSnapshot crs2_diagram = null;
//		if (originDiagram != null) {
//			crs1_diagram = diffService
//					.generateComparisonResourceSnapshot(match1_diagram);
//			crs2_diagram = diffService
//					.generateComparisonResourceSnapshot(match2_diagram);
//
//			conflictReport.getLeftDiagrams().add(crs1_diagram);
//			conflictReport.getRightDiagrams().add(crs2_diagram);
//		}
//		monitor.worked(1);
//
//		// Saving Conflict Report
//		monitor.subTask("Saving conflict report");
//
//		// TODO: get real names for left and right user
//		conflictReport.setLeftUser("Harry");
//		conflictReport.setRightUser("Sally");
//
//		IFile file = originFile.getParent().getFile(
//				new Path(originFile.getName() + "."
//						+ ConflictDiagramPlugin.CONFLICT_REPORT_EXTENSION));
//		if (file != null) {
//			Resource conflictReportResource = resourceSet.createResource(URI
//					.createPlatformResourceURI(file.getFullPath().toString(),
//							true));
//			conflictReportResource.getContents().add(conflictReport);
//			conflictReportResource.save(Collections.emptyMap());
//		}
//		monitor.worked(1);
//
//		return conflictReport;
//	}
//
//}
