/**
 * <copyright>
 *
 * Copyright (c) 2010 modelversioning.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */

package org.modelversioning.merge.conflictdiagram.util;

import java.util.HashMap;

import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;

/**
 * Factory for creating an instance of {@link DiagramMergeUtil} for a given {@link IEditorDescriptor}.
 * 
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a> 
 */
public class DiagramMergeUtilFactory {
	
	private HashMap<IEditorDescriptor, DiagramMergeUtil> instances = new HashMap<IEditorDescriptor, DiagramMergeUtil>();
	
	public DiagramMergeUtil getDiagramUtil(IEditorDescriptor editorDescriptor) {
		if (instances.containsKey(editorDescriptor)) {
			return instances.get(editorDescriptor);
		}
		else if (editorDescriptor.getId().equals("org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditorID")) {
			instances.put(editorDescriptor, new ClassDiagramMergeUtil());
			return instances.get(editorDescriptor);
		}
		else {
			// return a default diagram merge util
			instances.put(editorDescriptor, new DiagramMergeUtil() {
				
				@Override
				public void createShapes(NamedElement leftTarget, NamedElement rightTarget,
						Collaboration conflictElement, EList<Dependency> leftDependencies,
						EList<Dependency> rightDependencies) {
					throw new RuntimeException("Unknown Diagram Type.");
				}
				
				@Override
				public void createShapes(Collaboration conflictElement) {
					throw new RuntimeException("Unknown Diagram Type.");
				}
				
				@Override
				public void updateShapes(Collaboration conflictElement) {
					throw new RuntimeException("Unknown Diagram Type.");
				}
			});
			return instances.get(editorDescriptor);
		}
	}
}
