/**
 * <copyright>
 *
 * Copyright (c) 2010 modelversioning.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */

package org.modelversioning.conflicts.profile;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

/**
 * Utility Class for using http://modelversioning.org/modelversioningprofile/1.0
 * 
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * 
 */


public class ModelversioningProfile {
	
	public static final String MODELVERSIONING_PROFILE_NAME = "ModelversioningProfile";
	
	/**
	 * The URI to the UML Profile used for annotation.
	 */
	private static URI modelversioningProfileURI = URI
			.createPlatformPluginURI(
					"org.modelversioning.conflicts.profile/profile/modelversioningProfile.uml",
					true);
	/**
	 * The UML Profile used.
	 */
	public static Profile modelversioningProfile;
	/**
	 * The ResourceSet to use.
	 */
	private static ResourceSet resourceSet;

	/**
	 * CHANGES
	 */

	/**
	 * Stereotype for change.
	 */
	public static Stereotype change;
	
	/**
	 * Stereotype for atomic change.
	 */
	public static Stereotype atomicChange;
	
	/**
	 * Stereotype for composite change.
	 */
	public static Stereotype compositeChange;
	
	/**
	 * Stereotype for add.
	 */
	public static Stereotype add;

	/**
	 * Stereotype for myAdd.
	 */
	public static Stereotype myAdd;
	/**
	 * Stereotype for theirAdd.
	 */
	public static Stereotype theirAdd;
	/**
	 * Stereotype for update.
	 */
	public static Stereotype update;
	/**
	 * Stereotype for myUpdate.
	 */
	public static Stereotype myUpdate;
	/**
	 * Stereotype for theirUpdate.
	 */
	public static Stereotype theirUpdate;
	/**
	 * Stereotype for delete.
	 */
	public static Stereotype delete;
	/**
	 * Stereotype for myDelete.
	 */
	public static Stereotype myDelete;
	/**
	 * Stereotype for theirDelete.
	 */
	public static Stereotype theirDelete;
	/**
	 * Stereotype for move.
	 */
	public static Stereotype move;
	/**
	 * Stereotype for myMove.
	 */
	public static Stereotype myMove;
	/**
	 * Stereotype for theirMove.
	 */
	public static Stereotype theirMove;
	/**
	 * Stereotype for myCompositeChange.
	 */
	public static Stereotype myCompositeChange;
	/**
	 * Stereotype for theirCompositeChange.
	 */
	public static Stereotype theirCompositeChange;

	/**
	 * EQUIVALENT CHANGE
	 */

	/**
	 * Stereotype for equivalentChange.
	 */
	public static Stereotype equivalentChange;

	/**
	 * CONFLICTS
	 */
	/**
	 * Stereotype for Conflict
	 */
	public static Stereotype conflict;

	/**
	 * Stereotype for overlappingChange
	 */
	public static Stereotype overlappingChange;

	/**
	 * Stereotype for Violation
	 */
	public static Stereotype violation;

	/**
	 * Stereotype for addAdd.
	 */
	public static Stereotype addAdd;
	/**
	 * Stereotype for updateUpdate.
	 */
	public static Stereotype updateUpdate;
	/**
	 * Stereotype for deleteUpdate.
	 */
	public static Stereotype deleteUpdate;
	/**
	 * Stereotype for operationContractViolation.
	 */
	public static Stereotype operationContractViolation;
	/**
	 * Stereotype for constraintViolation.
	 */
	public static Stereotype constraintViolation;
	/**
	 * Stereotype for addForbid.
	 */
	public static Stereotype addForbid;
	/**
	 * Stereotype for changeUse.
	 */
	public static Stereotype changeUse;
	/**
	 * Stereotype for deleteUse.
	 */
	public static Stereotype deleteUse;

	/**
	 * ENUM
	 */

	/**
	 * The application state Enum
	 */
	public static Enumeration state;

	static {
		resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put(UMLResource.FILE_EXTENSION, UMLResource.Factory.INSTANCE);

		Resource profileResource = resourceSet.getResource(
				modelversioningProfileURI, true);

		modelversioningProfile = (Profile) EcoreUtil.getObjectByType(
				profileResource.getContents(), UMLPackage.Literals.PROFILE);

		change = modelversioningProfile.getOwnedStereotype("Change");
		atomicChange = modelversioningProfile.getOwnedStereotype("AtomicChange");
		compositeChange = modelversioningProfile.getOwnedStereotype("CompositeChange");
		add = modelversioningProfile.getOwnedStereotype("Add");
		myAdd = modelversioningProfile.getOwnedStereotype("MyAdd");
		delete = modelversioningProfile.getOwnedStereotype("Delete");
		myDelete = modelversioningProfile.getOwnedStereotype("MyDelete");
		update = modelversioningProfile.getOwnedStereotype("Update");
		myUpdate = modelversioningProfile.getOwnedStereotype("MyUpdate");
		move = modelversioningProfile.getOwnedStereotype("Move");
		myMove = modelversioningProfile.getOwnedStereotype("MyMove");
		myCompositeChange = modelversioningProfile
				.getOwnedStereotype("MyCompositeChange");

		theirAdd = modelversioningProfile.getOwnedStereotype("TheirAdd");
		theirDelete = modelversioningProfile.getOwnedStereotype("TheirDelete");
		theirUpdate = modelversioningProfile.getOwnedStereotype("TheirUpdate");
		theirMove = modelversioningProfile.getOwnedStereotype("TheirMove");
		theirCompositeChange = modelversioningProfile
				.getOwnedStereotype("TheirCompositeChange");

		equivalentChange = modelversioningProfile
				.getOwnedStereotype("EquivalentChange");

		conflict = modelversioningProfile.getOwnedStereotype("Conflict");
		overlappingChange = modelversioningProfile
				.getOwnedStereotype("OverlappingChange");
		violation = modelversioningProfile.getOwnedStereotype("Violation");
		addAdd = modelversioningProfile.getOwnedStereotype("AddAdd");
		updateUpdate = modelversioningProfile
				.getOwnedStereotype("UpdateUpdate");
		deleteUpdate = modelversioningProfile
				.getOwnedStereotype("DeleteUpdate");

		operationContractViolation = modelversioningProfile
				.getOwnedStereotype("OperationContractViolation");
		constraintViolation = modelversioningProfile
				.getOwnedStereotype("MetamodelViolation");
		addForbid = modelversioningProfile.getOwnedStereotype("AddForbid");
		changeUse = modelversioningProfile.getOwnedStereotype("ChangeUse");
		deleteUse = modelversioningProfile.getOwnedStereotype("DeleteUse");

		state = (Enumeration) EcoreUtil.getObjectByType(
				modelversioningProfile.getOwnedElements(),
				UMLPackage.Literals.ENUMERATION);
	}

	/**
	 * Enum for change states.
	 */
	public enum State {
		PENDING, APPLIED, REVERTED;
	}
}
