/**
 * 
 */
package org.modelevolution.emo2ggx.utils;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

/**
 * @author sgbmyr
 * 
 */
public class Utils {

	// private EPackage root;
	// private URI metamodel = URI
	// .createFileURI("/home/sgbmyr/projects/workspace/"
	// + "emfmo2ggx.project/src/metamodel/classdiagram.ecore");

	private static int counter = 0;
	private Map<String, String> elementToIdMap = new HashMap<String, String>();

	public String generateId() {
		String id;
		id = "I" + (++counter);
		return id;
	}
		
	public String generateAndStoreIdForElement(String element) {
		String id;
		id = "I" + (++counter);
		storeIdForElement(element, id);
		return id;
	}

	public String getIdForElement(String element) {
		return elementToIdMap.get(element);
	}

	public void storeIdForElement(String element, String id) {
		elementToIdMap.put(element,id);
	}

	public EPackage getRoot() {
		return getRoot("/home/sgbmyr/projects/workspace/"
				+ "emfmo2ggx.project/src/metamodel/classdiagram.ecore");
	}

	public EPackage getRoot(String uri) {
		EPackage root;

		URI mm = URI.createFileURI(uri);
		Resource res = loadResource(mm);
		root = (EPackage) res.getContents().get(0);

		return root;
	}

	private Resource loadResource(URI uri) {
		// load resources
		ResourceSet resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put("ecore", new EcoreResourceFactoryImpl());

		return resourceSet.getResource(uri, true);
	}
	
	public String parseOclExpression(String expression) {
		String parsed = null;
		if(expression.startsWith(" = '")) {
			int firstIndex = expression.indexOf("'");
			int lastIndex = expression.indexOf("'", firstIndex+1);
			parsed = expression.substring(firstIndex+1, lastIndex);
		} else if(expression.startsWith(" = ")) {
			parsed = expression.replace(" = ", "");
		} else {
			parsed = "!!unparsed!!" + expression; 
		}
		return parsed;
	}
}
