/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.formula;

import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;
import java.util.HashMap;

public class VariableInfo
implements IVar {
    private QType quantifier;
    private QBlock qb;
    private HashMap<Integer, VOccurrence> posLits;
    private HashMap<Integer, VOccurrence> negLits;
    private int nextPosPosition;
    private int nextNegPosition;
    private int name;
    private boolean isTseitin;

    public VariableInfo() {
        this.posLits = new HashMap();
        this.negLits = new HashMap();
        this.isTseitin = false;
    }

    public VariableInfo(QBlock qb) {
        this.setQBlock(qb);
        this.quantifier = qb.getQType();
        this.posLits = new HashMap();
        this.negLits = new HashMap();
        this.nextPosPosition = 0;
        this.nextNegPosition = 0;
    }

    public void setName(int name) {
        this.name = name;
    }

    @Override
    public int getName() {
        return this.name;
    }

    @Override
    public QType getQType() {
        return this.quantifier;
    }

    private int getNextPosPosition() {
        return this.nextPosPosition++;
    }

    private int getNextNegPosition() {
        return this.nextNegPosition++;
    }

    public void addPosOccurrence(VOccurrence v) {
        int pos = this.getNextPosPosition();
        v.setPosition(pos);
        this.posLits.put(pos, v);
    }

    public void addNegOccurrence(VOccurrence v) {
        int pos = this.getNextNegPosition();
        v.setPosition(pos);
        this.negLits.put(pos, v);
    }

    public void removeNegOccurrence(int pos) {
        this.negLits.remove(pos);
    }

    public void removePosOccurrence(int pos) {
        this.posLits.remove(pos);
    }

    public void setQBlock(QBlock qb) {
        this.qb = qb;
    }

    public QBlock getQBlock() {
        return this.qb;
    }

    public boolean isTseitinVar() {
        return this.isTseitin;
    }

    public void setTseitinVar() {
        this.isTseitin = true;
    }
}

