/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.parser;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class Parser {
    private BufferedReader input;
    private int varNumber;
    private FormulaData fd;
    int q1 = 0;
    int q2 = 0;
    int c1 = 0;
    int c2 = 0;
    int d1 = 0;
    int d2 = 0;

    private Parser(InputStream in) {
        this.input = new BufferedReader(new InputStreamReader(in));
    }

    private Parser(File in) {
        try {
            this.input = new BufferedReader(new FileReader(in));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static FormulaData parse(InputStream in) throws IOException, ParseException {
        Parser p = new Parser(in);
        p.startParsing(true);
        return p.getFormulaData();
    }

    public static FormulaData parse(InputStream in, boolean neg) throws IOException, ParseException {
        Parser p = new Parser(in);
        p.startParsing(neg);
        return p.getFormulaData();
    }

    public static FormulaData parse(File in) throws IOException, ParseException {
        Parser p = new Parser(in);
        p.startParsing(true);
        return p.getFormulaData();
    }

    public static FormulaData parse(File in, boolean neg) throws IOException, ParseException {
        Parser p = new Parser(in);
        p.startParsing(neg);
        return p.getFormulaData();
    }

    private FormulaData getFormulaData() {
        return this.fd;
    }

    private void startParsing(boolean neg) throws IOException, ParseException {
        while (!this.input.readLine().trim().equals("QBF")) {
        }
        this.varNumber = Integer.valueOf(this.input.readLine());
        assert (this.varNumber >= 1) : "invalid number of variables: " + this.varNumber;
        this.varNumber += 2;
        Formula rootFormula = new Formula();
        this.fd = new FormulaData(this.varNumber, rootFormula);
        String line = this.input.readLine();
        switch (line.charAt(0)) {
            case 'd': {
                this.parseDisjunction(rootFormula, neg);
                break;
            }
            case 'c': {
                this.parseConjunction(rootFormula, neg);
                break;
            }
            case 'q': {
                this.parseQuantifier(rootFormula, neg);
                break;
            }
            default: {
                throw new ParseException(String.valueOf(line) + ": inexpected input");
            }
        }
    }

    private void parseQuantifier(Formula f, boolean pol) throws IOException, ParseException {
        ++this.q1;
        LinkedList<Integer> l = new LinkedList<Integer>();
        String q = this.input.readLine();
        char qtype = q.charAt(0);
        this.parseVars(q.substring(1), QType.convert(qtype, pol), f, l);
        while (true) {
            if ((q = this.input.readLine()).charAt(0) == qtype) {
                throw new ParseException("quantifier blocks must be alternating");
            }
            qtype = q.charAt(0);
            switch (q.charAt(0)) {
                case 'd': {
                    this.parseDisjunction(f, pol);
                    q = this.input.readLine();
                    if (!q.trim().equals("/q")) {
                        throw new ParseException("missing closing /q");
                    }
                    this.unsetScopes(l);
                    return;
                }
                case 'c': {
                    this.parseConjunction(f, pol);
                    this.unsetScopes(l);
                    q = this.input.readLine();
                    if (!q.equals("/q")) {
                        throw new ParseException("missing closing /q");
                    }
                    return;
                }
                case 'q': {
                    this.parseQuantifier(f, pol);
                    q = this.input.readLine();
                    if (!q.equals("/q")) {
                        throw new ParseException("missing closing /q");
                    }
                    return;
                }
            }
            this.parseVars(q.substring(1), QType.convert(qtype, pol), f, l);
        }
    }

    private void unsetScopes(List<Integer> l) {
        for (Integer i : l) {
            this.fd.removeVarFromScpe(i);
        }
    }

    private void parseVars(String line, QType type, Formula f, List<Integer> l) {
        QBlock qb = new QBlock(type, f);
        String[] vars = line.trim().split(" ");
        if (line.length() != 0) {
            int i = 0;
            while (i < vars.length) {
                int var = new Integer(vars[i]);
                l.add(var);
                assert (var >= 2) : "invalid value for var: " + var;
                assert (var <= this.varNumber) : "invalid value for var: " + var;
                this.fd.addVar(var, qb);
                ++i;
            }
        }
    }

    private void parseLits(String line, boolean pol, Formula f) {
        if (line.trim().length() == 0) {
            return;
        }
        String[] lits = line.trim().split(" ");
        int i = 0;
        while (i < lits.length) {
            int lit = Integer.valueOf(lits[i]);
            if (pol) {
                this.fd.addPosVarOcc(lit, f);
            } else {
                this.fd.addNegVarOcc(lit, f);
            }
            ++i;
        }
    }

    private void parseDisjunction(Formula f, boolean pol) throws IOException, ParseException {
        String next;
        if (pol) {
            f.setConnective(CType.OR);
        } else {
            f.setConnective(CType.AND);
        }
        String posLits = this.input.readLine();
        this.parseLits(posLits, pol, f);
        String negLits = this.input.readLine();
        this.parseLits(negLits, !pol, f);
        while (!(next = this.input.readLine()).equals("/d")) {
            Formula tmp = new Formula();
            switch (next.charAt(0)) {
                case 'q': {
                    this.parseQuantifier(tmp, pol);
                    break;
                }
                case 'c': {
                    this.parseConjunction(tmp, pol);
                    break;
                }
                default: {
                    throw new ParseException("unexpected token");
                }
            }
            f.addSubFormula(tmp);
        }
    }

    private void parseConjunction(Formula f, boolean pol) throws IOException, ParseException {
        String next;
        if (pol) {
            f.setConnective(CType.AND);
        } else {
            f.setConnective(CType.OR);
        }
        String posLits = this.input.readLine();
        this.parseLits(posLits, pol, f);
        String negLits = this.input.readLine();
        this.parseLits(negLits, !pol, f);
        while (!(next = this.input.readLine()).equals("/c")) {
            Formula tmp = new Formula();
            switch (next.charAt(0)) {
                case 'q': {
                    this.parseQuantifier(tmp, pol);
                    break;
                }
                case 'd': {
                    this.parseDisjunction(tmp, pol);
                    break;
                }
                default: {
                    throw new ParseException("unexpected token");
                }
            }
            f.addSubFormula(tmp);
        }
    }

    public static void main(String[] args) {
        long zstVorher = System.currentTimeMillis();
        try {
            FormulaData fd = Parser.parse(new File("tests/poss9.qpro"));
            fd.print();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long zstNachher = System.currentTimeMillis();
        System.out.println("Zeit ben\u00f6tigt: " + (zstNachher - zstVorher) + " ms");
        zstNachher = System.currentTimeMillis();
        System.out.println("\nZeit ben\u00f6tigt: " + (zstNachher - zstVorher) + " ms");
    }
}

