/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.parser;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class ParserBooleSAT {
    private HashMap<String, Integer> vars;
    private HashMap<Integer, String> variableMap;
    private Scanner input;
    private String nextToken;
    private int varCounter = 3;
    private FormulaData fd;
    private boolean pol = true;
    private QBlock quant;

    public ParserBooleSAT(int varNumber, File f) {
        Formula root = new Formula();
        this.quant = new QBlock(QType.EXISTS, root);
        try {
            this.input = new Scanner(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.fd = new FormulaData(varNumber, root);
        this.nextToken();
        this.parseFormula(root);
        this.fd.setVarNumber(this.varCounter);
        this.setVariableMap();
    }

    private void setVariableMap() {
        this.variableMap = new HashMap();
        for (String key : this.vars.keySet()) {
            this.variableMap.put(this.vars.get(key) + 1, key);
        }
    }

    public HashMap<Integer, String> getMap() {
        return this.variableMap;
    }

    public String getVariable(int var) {
        return this.variableMap.get(var);
    }

    private void printMapping(BufferedWriter out) {
        for (String v : this.vars.keySet()) {
            try {
                out.write("c " + v + "\t\t" + (this.vars.get(v) + 1) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void printMapping() {
        for (String v : this.vars.keySet()) {
            System.out.println("c " + v + "\t\t" + (this.vars.get(v) + 1));
        }
    }

    private FormulaData getFormulaData() {
        return this.fd;
    }

    private void parseFormula(Formula f) {
        this.vars = new HashMap();
        f.setConnective(CType.AND);
        this.varCounter = 3;
        this.vars.put("1", 1);
        this.fd.addVar(1, this.quant);
        this.fd.addPosVarOcc(this.vars.get("1"), f);
        this.vars.put("0", 2);
        this.fd.addVar(2, this.quant);
        this.fd.addNegVarOcc(this.vars.get("0"), f);
        Formula f1 = new Formula();
        f.addSubFormula(f1);
        if (this.nextToken.equals("(")) {
            this.parseBrack(f1);
        } else if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
            this.parseQuant(f1);
        }
    }

    private int getNewVarName() {
        return this.varCounter++;
    }

    private void parseBrack(Formula f) {
        this.nextToken();
        this.parseConnective(f);
        if (!this.nextToken.equals(")")) {
            // empty if block
        }
    }

    private void parseConnective(Formula f) {
        if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
            Formula f1 = new Formula();
            this.parseQuant(f1);
            f.addSubFormula(f1);
        } else if (this.nextToken.equals("(")) {
            Formula f1 = new Formula();
            this.parseBrack(f1);
            f.addSubFormula(f1);
        } else if (this.nextToken.equals("!")) {
            this.nextToken();
            if (this.nextToken.equals("(")) {
                this.pol = !this.pol;
                Formula f1 = new Formula();
                this.parseBrack(f1);
                f.addSubFormula(f1);
                this.pol = !this.pol;
            } else if (this.pol) {
                if (!this.vars.containsKey(this.nextToken)) {
                    int newVar = this.getNewVarName();
                    this.vars.put(this.nextToken, newVar);
                    this.fd.addVar(newVar, this.quant);
                }
                this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
            } else {
                if (!this.vars.containsKey(this.nextToken)) {
                    int newVar = this.getNewVarName();
                    this.vars.put(this.nextToken, newVar);
                    this.fd.addVar(newVar, this.quant);
                }
                this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
            }
        } else {
            if (!this.vars.containsKey(this.nextToken)) {
                int newVar = this.getNewVarName();
                this.vars.put(this.nextToken, newVar);
                this.fd.addVar(newVar, this.quant);
            }
            if (this.pol) {
                this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
            } else {
                this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
            }
        }
        this.nextToken();
        if (this.nextToken.equals("&")) {
            this.parseConj(f);
            return;
        }
        if (this.nextToken.equals("|")) {
            this.parseDisj(f);
            return;
        }
    }

    private void parseDisj(Formula f) {
        if (this.pol) {
            f.setConnective(CType.OR);
        } else {
            f.setConnective(CType.AND);
        }
        do {
            int newVar;
            Formula f1;
            this.nextToken();
            if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
                f1 = new Formula();
                this.parseQuant(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("(")) {
                f1 = new Formula();
                this.parseBrack(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("!")) {
                this.nextToken();
                if (this.nextToken.equals("(")) {
                    this.pol = !this.pol;
                    f1 = new Formula();
                    this.parseBrack(f1);
                    f.addSubFormula(f1);
                    this.pol = !this.pol;
                } else if (this.pol) {
                    if (!this.vars.containsKey(this.nextToken)) {
                        newVar = this.getNewVarName();
                        this.vars.put(this.nextToken, newVar);
                        this.fd.addVar(newVar, this.quant);
                    }
                    this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                } else {
                    if (!this.vars.containsKey(this.nextToken)) {
                        newVar = this.getNewVarName();
                        this.vars.put(this.nextToken, newVar);
                        this.fd.addVar(newVar, this.quant);
                    }
                    this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                }
            } else {
                if (!this.vars.containsKey(this.nextToken)) {
                    newVar = this.getNewVarName();
                    this.vars.put(this.nextToken, newVar);
                    this.fd.addVar(newVar, this.quant);
                }
                if (this.pol) {
                    this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                } else {
                    this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                }
            }
            this.nextToken();
        } while (this.nextToken.equals("|"));
    }

    private void parseConj(Formula f) {
        if (this.pol) {
            f.setConnective(CType.AND);
        } else {
            f.setConnective(CType.OR);
        }
        do {
            int newVar;
            Formula f1;
            this.nextToken();
            if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
                f1 = new Formula();
                this.parseQuant(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("(")) {
                f1 = new Formula();
                this.parseBrack(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("!")) {
                this.nextToken();
                if (this.nextToken.equals("(")) {
                    this.pol = !this.pol;
                    f1 = new Formula();
                    this.parseBrack(f1);
                    f.addSubFormula(f1);
                    this.pol = !this.pol;
                } else if (this.pol) {
                    if (!this.vars.containsKey(this.nextToken)) {
                        newVar = this.getNewVarName();
                        this.vars.put(this.nextToken, newVar);
                        this.fd.addVar(newVar, this.quant);
                    }
                    this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                } else {
                    if (!this.vars.containsKey(this.nextToken)) {
                        newVar = this.getNewVarName();
                        this.vars.put(this.nextToken, newVar);
                        this.fd.addVar(newVar, this.quant);
                    }
                    this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                }
                assert (this.vars.containsKey(this.nextToken)) : "unknown element";
            } else {
                if (!this.vars.containsKey(this.nextToken)) {
                    newVar = this.getNewVarName();
                    this.vars.put(this.nextToken, newVar);
                    this.fd.addVar(newVar, this.quant);
                }
                if (this.pol) {
                    this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                } else {
                    this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                }
            }
            this.nextToken();
        } while (this.nextToken.equals("&"));
    }

    private void parseQuant(Formula f) {
        String quant = this.nextToken;
        ArrayList<String> quantVars = new ArrayList<String>();
        QBlock qBlock = quant.equals("forall") ? (this.pol ? new QBlock(QType.FORALL, f) : new QBlock(QType.EXISTS, f)) : (this.pol ? new QBlock(QType.EXISTS, f) : new QBlock(QType.FORALL, f));
        this.nextToken();
        assert (this.nextToken.equals("[")) : "unexpected character";
        this.nextToken();
        do {
            assert (!this.vars.containsKey(this.nextToken)) : "variable already defined";
            int newVar = this.getNewVarName();
            this.vars.put(this.nextToken, newVar);
            quantVars.add(this.nextToken);
            this.fd.addVar(newVar, qBlock);
            this.nextToken();
        } while (!this.nextToken.equals("]"));
        this.nextToken();
        this.parseBrack(f);
    }

    private void nextToken() {
        this.nextToken = this.input.next();
    }

    public File toCNF(String outFile) {
        try {
            FileWriter fstream = new FileWriter(outFile);
            BufferedWriter out = new BufferedWriter(fstream);
            this.printMapping(out);
            FormulaData fd = this.getFormulaData();
            FormulaToCNF ftc = new FormulaToCNF(fd, true, out);
            ftc.label();
            out.write("p cnf " + fd.getVarNumber() + " " + ftc.countCNF2());
            ftc.printCNF2();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new File(outFile);
    }
}

