/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.simplifier;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;
import at.jku.fmv.qbf.nnf.simplifier.MatingGraph;
import at.jku.fmv.qbf.nnf.simplifier.MatingNode;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class UniversalReduction {
    private Queue<MatingNode> todo = new LinkedBlockingQueue<MatingNode>();
    private MatingGraph mg;

    public UniversalReduction(Formula f) {
        this.mg = this.buildGraph(f);
        for (MatingNode m : this.mg.getRootNodes()) {
            this.todo.add(m);
        }
    }

    public void checkURDown() {
        while (!this.todo.isEmpty()) {
            MatingNode n = this.todo.poll();
            this.checkNodeDown(n, n.getMaxDown());
        }
    }

    private void checkNodeDown(MatingNode n, int max) {
        assert (n.getParents().size() < n.getMax()) : "node has not been finished";
        for (MatingNode cn : n.getChildren()) {
            if (cn.getMax() >= max) continue;
            cn.setMax(max);
        }
    }

    public MatingGraph buildGraph(Formula f) {
        MatingGraph g2;
        MatingGraph g1 = null;
        for (Formula fs : f.getSubformulas()) {
            g2 = this.buildGraph(fs);
            g1 = this.combine(g2, g1, f.getConnective());
        }
        for (VOccurrence v : f.getPosLits()) {
            g2 = new MatingGraph(new MatingNode(v));
            g1 = this.combine(g2, g1, f.getConnective());
        }
        for (VOccurrence v : f.getNegLits()) {
            g2 = new MatingGraph(new MatingNode(v));
            g1 = this.combine(g2, g1, f.getConnective());
        }
        return g1;
    }

    private MatingGraph combine(MatingGraph g1, MatingGraph g2, CType connective) {
        if (connective == CType.AND) {
            g1.union(g2);
        } else {
            g1.merge(g2);
        }
        return g1;
    }

    public void reduce() {
    }
}

