/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.transform.prenex;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import at.jku.fmv.qbf.nnf.transform.prenex.IQMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.UpMerger;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AdvancedPrenexPrinter {
    private IQMerger merger;
    private Quantifiers q = null;
    private Formula f;

    public AdvancedPrenexPrinter(IQMerger merger, Formula f) {
        this.merger = merger;
        this.f = f;
    }

    public void printPrefix() {
        if (this.q == null) {
            this.q = this.quantifyFormula(this.f);
            this.merger.addTseitinAtBack(this.f.getQuantifiers());
        }
        AdvancedPrenexPrinter.printPrefix(this.q);
    }

    public static void printPrefix(Quantifiers q) {
        for (QBlock b : q.getQuantifierBlocks()) {
            if (b.getQType() == QType.EXISTS) {
                System.out.print("e");
            } else {
                System.out.print("a");
            }
            for (IVar v : b.getVars()) {
                System.out.print(" " + v.getName());
            }
            System.out.println(" 0");
        }
    }

    public Quantifiers quantifyFormula(Formula f) {
        if (f.getSubformulas().size() == 0) {
            this.merger.addTseitin(f);
            return f.getQuantifiers();
        }
        List<Formula> fs = f.getSubformulas();
        Quantifiers l = this.quantifyFormula(fs.get(0));
        int i = 1;
        while (i < fs.size()) {
            l = this.merger.merge(l, this.quantifyFormula(fs.get(i)), f.getQuantifiers());
            ++i;
        }
        return this.merger.addPrenex(f, l);
    }

    public static void main(String[] args) {
        try {
            FormulaData fd = Parser.parse(new File(args[0]));
            System.out.println("to cnf");
            FormulaToCNF ftc = new FormulaToCNF(fd, true);
            System.out.println("to cnf");
            ftc.label();
            System.out.println("p cnf " + fd.getVarNumber() + " " + ftc.countClauses());
            AdvancedPrenexPrinter ap = new AdvancedPrenexPrinter(new UpMerger(), fd.getFormula());
            ap.printPrefix();
            ftc.printCNFMatrix();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

