/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.transform.prenex;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class AppendPrenexPrinter {
    FormulaData fd;
    LinkedList<QBlock> ex;
    LinkedList<QBlock> all;
    private QBlock last = new QBlock(QType.EXISTS);
    private Quantifiers q;
    boolean[] printedVars;

    public AppendPrenexPrinter(FormulaData fd) {
        this.fd = fd;
        this.printedVars = new boolean[fd.getVarNumber() + 1];
        this.q = new Quantifiers(fd.getFormula());
        this.buildPrefix(this.q, fd.getFormula());
        this.q.addQuantBlock(this.last);
    }

    public void printPrefix() {
        for (QBlock b : this.q.getQuantifierBlocks()) {
            if (b.getQType() == QType.EXISTS) {
                System.out.print("e");
            } else {
                System.out.print("a");
            }
            for (IVar v : b.getVars()) {
                System.out.print(" " + v.getName());
            }
            System.out.println(" 0");
        }
    }

    public void buildPrefix(Quantifiers q, Formula f) {
        for (QBlock qb : f.getQuantifiers().getQuantifierBlocks()) {
            if (q.size() > 0) {
                QBlock l = q.getQuantifierBlocks().get(q.size() - 1);
                if (l.getQType() == qb.getQType()) {
                    for (IVar v : qb.getVars()) {
                        l.add(v);
                    }
                    continue;
                }
                q.addQuantBlock(qb);
                continue;
            }
            q.addQuantBlock(qb);
        }
        if (!this.printedVars[f.getTseitinVar().getName()]) {
            this.printedVars[f.getTseitinVar().getName()] = true;
            this.last.add(f.getTseitinVar());
        }
        for (Formula g : f.getSubformulas()) {
            this.buildPrefix(q, g);
        }
    }

    public void printPrenex() {
        this.ex = new LinkedList();
        this.all = new LinkedList();
        this.sublookforQuant(this.fd.getFormula());
        this.printedVars = new boolean[this.fd.getVarNumber() + 1];
        if (!this.ex.isEmpty()) {
            this.printExists();
        } else {
            this.printForall();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printExists() {
        if (this.ex.isEmpty()) {
            return;
        }
        this.print("e ");
        while (!this.ex.isEmpty()) {
            QBlock q = this.ex.poll();
            for (IVar v : q.getVars()) {
                if (this.printedVars[v.getName()]) continue;
                this.print(String.valueOf(v.getName()) + " ");
                this.printedVars[v.getName()] = true;
            }
            int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
            if (q.getQuantifiers().getQuantifierBlocks().size() > i + 1) {
                this.all.push(q.getQuantifiers().getQuantifierBlocks().get(i + 1));
                continue;
            }
            this.lookforQuant(q.getQuantifiers().getFormula());
        }
        this.print("0\n");
        this.printForall();
    }

    private void print(String s) {
        System.out.print(s);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printForall() {
        if (this.all.isEmpty()) {
            return;
        }
        this.print("a ");
        while (!this.all.isEmpty()) {
            QBlock q = this.all.poll();
            for (IVar v : q.getVars()) {
                if (this.printedVars[v.getName()]) continue;
                this.print(String.valueOf(v.getName()) + " ");
                this.printedVars[v.getName()] = true;
            }
            int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
            if (q.getQuantifiers().getQuantifierBlocks().size() > i + 1) {
                this.ex.push(q.getQuantifiers().getQuantifierBlocks().get(i + 1));
                continue;
            }
            this.lookforQuant(q.getQuantifiers().getFormula());
        }
        this.print("0\n");
        this.printExists();
    }

    private void lookforQuant(Formula f) {
        for (Formula fs : f.getSubformulas()) {
            this.sublookforQuant(fs);
        }
    }

    private void sublookforQuant(Formula f) {
        if (!this.printedVars[f.getTseitinVar().getName()]) {
            this.last.add(f.getTseitinVar());
        }
        this.printedVars[f.getTseitinVar().getName()] = true;
        if (f.getQuantifiers() == null || f.getQuantifiers().getQuantifierBlocks() == null || f.getQuantifiers().getQuantifierBlocks().size() == 0) {
            for (Formula fs : f.getSubformulas()) {
                this.sublookforQuant(fs);
            }
            return;
        }
        Quantifiers q1 = f.getQuantifiers();
        ArrayList qb = (ArrayList)q1.getQuantifierBlocks();
        if (qb.size() != 0) {
            QBlock q = (QBlock)qb.get(0);
            if (q.getQType() == QType.EXISTS) {
                this.ex.push(q);
            } else {
                this.all.push(q);
            }
        }
    }

    public static void main(String[] args) {
        try {
            FormulaData fd = Parser.parse(new File("tests/a.qpro"));
            FormulaToCNF ftc = new FormulaToCNF(fd, true);
            ftc.label();
            System.out.println("p cnf " + fd.getVarNumber() + " " + ftc.countClauses());
            AppendPrenexPrinter p = new AppendPrenexPrinter(fd);
            p.printPrefix();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

