/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.transform.prenex;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.transform.prenex.IQMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.TseitinPosition;
import java.util.List;

public abstract class Merger
implements IQMerger {
    private TseitinPosition tp = TseitinPosition.FRONT;
    private QBlock last = new QBlock(QType.EXISTS);

    @Override
    public void setTseitinPosition(TseitinPosition tp) {
        this.tp = tp;
    }

    protected Quantifiers mergeEqualSize(Quantifiers l, Quantifiers r, QType preferedType) {
        assert (l.getQuantifierBlocks().size() == r.getQuantifierBlocks().size()) : "assertion failed: different size";
        List<QBlock> qll = l.getQuantifierBlocks();
        List<QBlock> qlr = r.getQuantifierBlocks();
        if (qll.size() == 0) {
            return r;
        }
        if (qlr.size() == 0) {
            return l;
        }
        if (qll.get(0).getQType() == qlr.get(0).getQType()) {
            int i = 0;
            while (i < qll.size()) {
                QBlock qbr = qlr.get(i);
                QBlock qbl = qll.get(i);
                for (IVar v : qbr.getVars()) {
                    qbl.add(v);
                }
                ++i;
            }
            return l;
        }
        if (preferedType != qll.get(0).getQType()) {
            int i = 1;
            while (i < qll.size()) {
                QBlock qbr = qlr.get(i - 1);
                QBlock qbl = qll.get(i);
                for (IVar v : qbr.getVars()) {
                    qbl.add(v);
                }
                ++i;
            }
            return l;
        }
        int i = 1;
        while (i < qlr.size()) {
            QBlock qbr = qlr.get(i);
            QBlock qbl = qll.get(i - 1);
            for (IVar v : qbl.getVars()) {
                qbr.add(v);
            }
            ++i;
        }
        return r;
    }

    @Override
    public abstract Quantifiers merge(Quantifiers var1, Quantifiers var2, Quantifiers var3);

    @Override
    public Quantifiers addPrenex(Formula f, Quantifiers q) {
        q.setFormula(f);
        Quantifiers p = f.getQuantifiers().size() != 0 ? f.getQuantifiers() : q;
        switch (this.tp) {
            case FRONT: {
                this.addTVAtFront(f.getTseitinVar(), p);
                break;
            }
            case MIDDLE: {
                this.addTVAtMiddle(f.getTseitinVar(), p);
                break;
            }
            case BACK: {
                this.addTVAtBack(f.getTseitinVar());
            }
        }
        if (f.getQuantifiers().size() == 0) {
            f.setQuantifier(p);
            return p;
        }
        if (q.size() == 0) {
            return f.getQuantifiers();
        }
        List<QBlock> ql = q.getQuantifierBlocks();
        List<QBlock> qf = f.getQuantifiers().getQuantifierBlocks();
        if (qf.get(qf.size() - 1).getQType() == ql.get(0).getQType()) {
            for (IVar v : ql.get(0).getVars()) {
                qf.get(qf.size() - 1).add(v);
            }
            int i = 1;
            while (i < ql.size()) {
                qf.add(ql.get(i));
                ++i;
            }
        } else {
            for (QBlock qb : ql) {
                f.getQuantifiers().addQuantBlock(qb);
            }
        }
        return f.getQuantifiers();
    }

    @Override
    public void addTseitinAtBack(Quantifiers q) {
        if (this.tp != TseitinPosition.BACK) {
            return;
        }
        List<QBlock> ql = q.getQuantifierBlocks();
        if (ql.size() == 0) {
            q.addQuantBlock(this.last);
            return;
        }
        if (ql.get(ql.size() - 1).getQType() == QType.EXISTS) {
            ql.get(ql.size() - 1).setQuantifiers(this.last.getQuantifiers());
            for (IVar v : this.last.getVars()) {
                ql.get(ql.size() - 1).add(v);
            }
            return;
        }
        q.addQuantBlock(this.last);
    }

    private void addTVAtBack(TseitinVar tseitinVar) {
        if (!tseitinVar.isInPrefix()) {
            this.last.add(tseitinVar);
        }
        tseitinVar.setInPrefix();
    }

    private void addTVAtFront(TseitinVar tseitinVar, Quantifiers q) {
        List<QBlock> ql = q.getQuantifierBlocks();
        if (tseitinVar.isInPrefix()) {
            return;
        }
        tseitinVar.setInPrefix();
        if (ql.size() == 0) {
            QBlock qb = new QBlock(QType.EXISTS);
            qb.setQuantifiers(q);
            qb.add(tseitinVar);
            q.addQuantBlock(qb);
            return;
        }
        if (ql.get(0).getQType() == QType.EXISTS) {
            ql.get(0).add(tseitinVar);
            return;
        }
        QBlock qb = new QBlock(QType.EXISTS);
        qb.setQuantifiers(q);
        qb.add(tseitinVar);
        q.getQuantifierBlocks().add(0, qb);
    }

    private void addTVAtMiddle(TseitinVar tseitinVar, Quantifiers q) {
        List<QBlock> ql = q.getQuantifierBlocks();
        if (tseitinVar.isInPrefix()) {
            return;
        }
        tseitinVar.setInPrefix();
        if (ql.size() == 0) {
            QBlock qb = new QBlock(QType.EXISTS);
            qb.setQuantifiers(q);
            qb.add(tseitinVar);
            q.addQuantBlock(qb);
            return;
        }
        if (ql.get(ql.size() - 1).getQType() == QType.EXISTS) {
            ql.get(ql.size() - 1).add(tseitinVar);
            return;
        }
        QBlock qb = new QBlock(QType.EXISTS);
        qb.setQuantifiers(q);
        qb.add(tseitinVar);
        q.addQuantBlock(qb);
    }

    @Override
    public void addTseitin(Formula f) {
        switch (this.tp) {
            case FRONT: {
                this.addTVAtFront(f.getTseitinVar(), f.getQuantifiers());
                break;
            }
            case MIDDLE: {
                this.addTVAtMiddle(f.getTseitinVar(), f.getQuantifiers());
                break;
            }
            case BACK: {
                this.addTVAtBack(f.getTseitinVar());
            }
        }
    }
}

