/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.engine.IDiffEngine;
import org.eclipse.emf.compare.diff.engine.check.AttributesCheck;
import org.eclipse.emf.compare.diff.engine.check.ReferencesCheck;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateContainmentFeature;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDiffEngine
implements IDiffEngine {
    protected static final int ANCESTOR_OBJECT = 0;
    protected static final int LEFT_OBJECT = 1;
    protected static final int RIGHT_OBJECT = 2;
    protected EcoreUtil.CrossReferencer matchCrossReferencer;
    private Map<EObject, DiffGroup> diffGroups = new HashMap<EObject, DiffGroup>();

    @Override
    public DiffModel doDiff(MatchModel match) {
        return this.doDiff(match, false);
    }

    @Override
    public DiffModel doDiff(MatchModel match, boolean threeWay) {
        this.matchCrossReferencer = new EcoreUtil.CrossReferencer(match){
            private static final long serialVersionUID = 1L;
            {
                this.crossReference();
            }
        };
        DiffModel result = DiffFactory.eINSTANCE.createDiffModel();
        result.getLeftRoots().addAll(match.getLeftRoots());
        result.getRightRoots().addAll(match.getRightRoots());
        result.getAncestorRoots().addAll(match.getAncestorRoots());
        DiffGroup diffRoot = null;
        diffRoot = threeWay ? this.doDiffThreeWay(match) : this.doDiffTwoWay(match);
        result.getOwnedElements().add(diffRoot);
        return result;
    }

    @Override
    public DiffModel doDiffResourceSet(MatchModel match, boolean threeWay, EcoreUtil.CrossReferencer crossReferencer) {
        this.matchCrossReferencer = crossReferencer;
        DiffModel result = DiffFactory.eINSTANCE.createDiffModel();
        result.getLeftRoots().addAll(match.getLeftRoots());
        result.getRightRoots().addAll(match.getRightRoots());
        result.getAncestorRoots().addAll(match.getAncestorRoots());
        DiffGroup diffRoot = null;
        diffRoot = threeWay ? this.doDiffThreeWay(match) : this.doDiffTwoWay(match);
        result.getOwnedElements().add(diffRoot);
        return result;
    }

    @Override
    public void reset() {
        this.diffGroups.clear();
        this.matchCrossReferencer = null;
    }

    protected void addInContainerPackage(DiffGroup root, DiffElement operation, EObject targetParent) {
        if (targetParent == null) {
            root.getSubDiffElements().add(operation);
            return;
        }
        DiffGroup targetGroup = this.findExistingGroup(root, targetParent);
        if (targetGroup == null && (targetGroup = this.findExistingGroup(root, this.getMatchedEObject(targetParent))) == null) {
            targetGroup = this.buildHierarchyGroup(targetParent, root);
        }
        targetGroup.getSubDiffElements().add(operation);
    }

    protected AttributesCheck getAttributesChecker() {
        return new AttributesCheck(this.matchCrossReferencer);
    }

    protected ReferencesCheck getReferencesChecker() {
        return new ReferencesCheck(this.matchCrossReferencer);
    }

    @Deprecated
    protected void checkAttributesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        this.getAttributesChecker().checkAttributesUpdates(root, mapping);
    }

    @Deprecated
    protected void checkAttributesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        this.getAttributesChecker().checkAttributesUpdates(root, mapping);
    }

    protected void checkContainmentUpdate(DiffGroup current, Match2Elements matchElement) {
        EObject leftElement = matchElement.getLeftElement();
        EObject rightElement = matchElement.getRightElement();
        if (leftElement.eContainmentFeature() != null && rightElement.eContainmentFeature() != null && !leftElement.eContainmentFeature().getName().equals(rightElement.eContainmentFeature().getName()) && this.getMatchedEObject(leftElement.eContainer()).equals(rightElement.eContainer())) {
            this.createUpdateContainmentOperation(current, leftElement, rightElement);
        }
    }

    protected void checkContainmentUpdate(DiffGroup root, Match3Elements matchElement) {
        boolean rightChangedContainment;
        EObject leftElement = matchElement.getLeftElement();
        EObject rightElement = matchElement.getRightElement();
        EObject originElement = matchElement.getOriginElement();
        if (originElement == null || leftElement.eContainer() == null && rightElement.eContainer() == null && originElement.eContainer() == null) {
            return;
        }
        boolean leftChangedContainment = originElement.eContainmentFeature() != null && leftElement.eContainmentFeature() != null && !leftElement.eContainmentFeature().getName().equals(originElement.eContainmentFeature().getName()) && this.getMatchedEObject(leftElement.eContainer(), 0).equals(originElement.eContainer());
        boolean bl = rightChangedContainment = originElement.eContainmentFeature() != null && rightElement.eContainmentFeature() != null && !rightElement.eContainmentFeature().getName().equals(originElement.eContainmentFeature().getName()) && this.getMatchedEObject(rightElement.eContainer(), 0).equals(originElement.eContainer());
        if (this.getMatchedEObject(leftElement.eContainer()).equals(rightElement.eContainer()) && !leftElement.eContainmentFeature().getName().equals(rightElement.eContainmentFeature().getName())) {
            if (leftChangedContainment && rightChangedContainment) {
                UpdateContainmentFeature updateContainment = DiffFactory.eINSTANCE.createUpdateContainmentFeature();
                updateContainment.setLeftElement(leftElement);
                updateContainment.setRightElement(rightElement);
                updateContainment.setRightTarget(this.getMatchedEObject(leftElement.eContainer()));
                updateContainment.setLeftTarget(this.getMatchedEObject(rightElement.eContainer()));
                ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
                conflictingDiff.setLeftParent(leftElement);
                conflictingDiff.setRightParent(rightElement);
                conflictingDiff.setOriginElement(originElement);
                conflictingDiff.getSubDiffElements().add(updateContainment);
                root.getSubDiffElements().add(conflictingDiff);
            } else if (leftChangedContainment) {
                this.createUpdateContainmentOperation(root, leftElement, rightElement);
            } else if (rightChangedContainment) {
                this.createRemoteUpdateContainmentOperation(root, leftElement, rightElement);
            }
        }
    }

    protected void checkForDiffs(DiffGroup current, Match2Elements match) throws FactoryException {
        this.getAttributesChecker().checkAttributesUpdates(current, match);
        this.getReferencesChecker().checkReferencesUpdates(current, match);
        this.checkMoves(current, match);
        this.checkContainmentUpdate(current, match);
    }

    protected void checkForDiffs(DiffGroup current, Match3Elements match) throws FactoryException {
        this.getAttributesChecker().checkAttributesUpdates(current, match);
        this.getReferencesChecker().checkReferencesUpdates(current, match);
        this.checkMoves(current, match);
        this.checkContainmentUpdate(current, match);
    }

    protected void checkMoves(DiffGroup root, Match2Elements matchElement) {
        EObject left = matchElement.getLeftElement();
        EObject right = matchElement.getRightElement();
        if (left instanceof EGenericType || right instanceof EGenericType) {
            return;
        }
        if (left.eContainer() != null && right.eContainer() != null && this.getMatchedEObject(left.eContainer()) != right.eContainer()) {
            this.createMoveOperation(root, left, right);
        }
    }

    protected void checkMoves(DiffGroup root, Match3Elements matchElement) {
        boolean rightMoved;
        EObject leftElement = matchElement.getLeftElement();
        EObject rightElement = matchElement.getRightElement();
        EObject originElement = matchElement.getOriginElement();
        if (leftElement.eContainer() == null && rightElement.eContainer() == null && originElement.eContainer() == null) {
            return;
        }
        if (leftElement instanceof EGenericType || rightElement instanceof EGenericType || originElement instanceof EGenericType) {
            return;
        }
        boolean leftMoved = originElement != null && leftElement.eContainer() != null && !this.getMatchedEObject(leftElement.eContainer(), 0).equals(originElement.eContainer());
        boolean bl = rightMoved = originElement != null && rightElement.eContainer() != null && !this.getMatchedEObject(rightElement.eContainer(), 0).equals(originElement.eContainer());
        if (!this.getMatchedEObject(leftElement.eContainer()).equals(rightElement.eContainer())) {
            if (leftMoved && rightMoved) {
                MoveModelElement operation = DiffFactory.eINSTANCE.createMoveModelElement();
                operation.setRightElement(rightElement);
                operation.setLeftElement(leftElement);
                operation.setRightTarget(this.getMatchedEObject(leftElement.eContainer()));
                operation.setLeftTarget(this.getMatchedEObject(rightElement.eContainer()));
                ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
                conflictingDiff.setLeftParent(leftElement);
                conflictingDiff.setRightParent(rightElement);
                conflictingDiff.setOriginElement(originElement);
                conflictingDiff.getSubDiffElements().add(operation);
                root.getSubDiffElements().add(conflictingDiff);
            } else if (rightMoved) {
                this.createRemoteMoveOperation(root, leftElement, rightElement);
            } else if (leftMoved) {
                this.createMoveOperation(root, leftElement, rightElement);
            }
        }
    }

    @Deprecated
    protected void checkReferenceOrderChange(DiffGroup root, EReference reference, EObject leftElement, EObject rightElement, List<ReferenceChangeLeftTarget> addedReferences, List<ReferenceChangeRightTarget> removedReferences) throws FactoryException {
    }

    @Deprecated
    protected void checkReferencesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        this.getReferencesChecker().checkReferencesUpdates(root, mapping);
    }

    @Deprecated
    protected void checkReferencesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        this.getReferencesChecker().checkReferencesUpdates(root, mapping);
    }

    protected DiffGroup doDiffThreeWay(MatchModel match) {
        DiffGroup diffRoot = DiffFactory.eINSTANCE.createDiffGroup();
        if (match.getMatchedElements().size() > 0) {
            Match3Elements matchRoot = (Match3Elements)match.getMatchedElements().get(0);
            this.doDiffDelegate(diffRoot, matchRoot);
        }
        ArrayList<UnmatchElement> filteredUnmatched = new ArrayList<UnmatchElement>(match.getUnmatchedElements().size());
        for (UnmatchElement unmatchElement : match.getUnmatchedElements()) {
            if (unmatchElement.isConflicting()) {
                filteredUnmatched.add(unmatchElement);
                continue;
            }
            boolean isChild = false;
            for (UnmatchElement elem : match.getUnmatchedElements()) {
                if (elem == unmatchElement || !EcoreUtil.isAncestor(elem.getElement(), unmatchElement.getElement())) continue;
                isChild = true;
                break;
            }
            if (isChild) continue;
            filteredUnmatched.add(unmatchElement);
        }
        if (filteredUnmatched.size() > 0) {
            this.processUnmatchedElements(diffRoot, filteredUnmatched);
        }
        return diffRoot;
    }

    protected DiffGroup doDiffTwoWay(MatchModel match) {
        DiffGroup diffRoot = DiffFactory.eINSTANCE.createDiffGroup();
        if (match.getMatchedElements().size() > 0) {
            Match2Elements matchRoot = (Match2Elements)match.getMatchedElements().get(0);
            this.doDiffDelegate(diffRoot, matchRoot);
        }
        this.processUnmatchedElements(diffRoot, match.getUnmatchedElements());
        return diffRoot;
    }

    protected final EObject getMatchedEObject(EObject from) {
        EObject matchedEObject = null;
        Collection settings = (Collection)this.matchCrossReferencer.get(from);
        if (settings == null) {
            return null;
        }
        for (EStructuralFeature.Setting setting : settings) {
            if (!(setting.getEObject() instanceof Match2Elements)) continue;
            if (setting.getEStructuralFeature().getFeatureID() == 2) {
                matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                continue;
            }
            if (setting.getEStructuralFeature().getFeatureID() != 3) continue;
            matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
        }
        return matchedEObject;
    }

    protected final EObject getMatchedEObject(EObject from, int side) throws IllegalArgumentException {
        if (side != 1 && side != 2 && side != 0) {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("GenericDiffEngine.IllegalSide"));
        }
        EObject matchedEObject = null;
        Collection settings = (Collection)this.matchCrossReferencer.get(from);
        if (settings == null) {
            return null;
        }
        for (EStructuralFeature.Setting setting : settings) {
            if (!(setting.getEObject() instanceof Match2Elements)) continue;
            if (side == 1) {
                matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
                continue;
            }
            if (side == 2) {
                matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                continue;
            }
            if (!(setting.getEObject() instanceof Match3Elements)) continue;
            matchedEObject = ((Match3Elements)setting.getEObject()).getOriginElement();
        }
        return matchedEObject;
    }

    protected void processUnmatchedElements(DiffGroup diffRoot, List<UnmatchElement> unmatched) {
        ArrayList<UnmatchElement> filteredUnmatched = new ArrayList<UnmatchElement>(unmatched.size());
        for (UnmatchElement element : unmatched) {
            if (element.getElement() instanceof EGenericType) continue;
            filteredUnmatched.add(element);
        }
        for (UnmatchElement unmatchElement : filteredUnmatched) {
            ModelElementChange operation;
            ConflictingDiffElement container;
            EObject element = unmatchElement.getElement();
            EObject leftParent = this.getMatchedEObject(element.eContainer());
            if (unmatchElement.isConflicting()) {
                container = DiffFactory.eINSTANCE.createConflictingDiffElement();
                container.setLeftParent(leftParent);
                container.setRightParent(element.eContainer());
                container.setOriginElement(this.getMatchedEObject(element, 0));
            } else {
                container = null;
            }
            if (unmatchElement.getSide() == Side.RIGHT) {
                operation = DiffFactory.eINSTANCE.createModelElementChangeRightTarget();
                operation.setRightElement(element);
                operation.setRemote(unmatchElement.isRemote());
                operation.setLeftParent(leftParent);
                if (container != null) {
                    container.getSubDiffElements().add(operation);
                    this.addInContainerPackage(diffRoot, container, leftParent);
                    continue;
                }
                this.addInContainerPackage(diffRoot, operation, leftParent);
                continue;
            }
            operation = DiffFactory.eINSTANCE.createModelElementChangeLeftTarget();
            operation.setLeftElement(element);
            operation.setRemote(unmatchElement.isRemote());
            operation.setRightParent(leftParent);
            if (container != null) {
                container.getSubDiffElements().add(operation);
                this.addInContainerPackage(diffRoot, container, leftParent);
                continue;
            }
            this.addInContainerPackage(diffRoot, operation, leftParent);
        }
    }

    @Deprecated
    protected boolean shouldBeIgnored(EAttribute attribute) {
        boolean ignore = attribute.isTransient();
        ignore = ignore || attribute.isDerived();
        return ignore;
    }

    @Deprecated
    protected boolean shouldBeIgnored(EReference reference) {
        boolean ignore = reference.isContainment();
        ignore = ignore || reference.isDerived();
        ignore = ignore || reference.isTransient();
        ignore = ignore || reference.isContainer();
        ignore = ignore || reference.eContainer() == EcorePackage.eINSTANCE.getEGenericType();
        return ignore;
    }

    private DiffGroup buildHierarchyGroup(EObject targetParent, DiffGroup root) {
        DiffGroup curGroup = this.findExistingGroup(root, targetParent);
        if (curGroup == null) {
            curGroup = DiffFactory.eINSTANCE.createDiffGroup();
            curGroup.setRightParent(targetParent);
            this.diffGroups.put(targetParent, curGroup);
        }
        if (targetParent.eContainer() == null) {
            root.getSubDiffElements().add(curGroup);
            return curGroup;
        }
        if (targetParent.eResource() == targetParent.eContainer().eResource()) {
            this.buildHierarchyGroup(targetParent.eContainer(), root).getSubDiffElements().add(curGroup);
        } else {
            root.getSubDiffElements().add(curGroup);
        }
        return curGroup;
    }

    private void createMoveOperation(DiffGroup root, EObject left, EObject right) {
        MoveModelElement operation = DiffFactory.eINSTANCE.createMoveModelElement();
        operation.setRightElement(right);
        operation.setLeftElement(left);
        operation.setRightTarget(this.getMatchedEObject(left.eContainer()));
        operation.setLeftTarget(this.getMatchedEObject(right.eContainer()));
        root.getSubDiffElements().add(operation);
    }

    private void createRemoteMoveOperation(DiffGroup root, EObject left, EObject right) {
        MoveModelElement operation = DiffFactory.eINSTANCE.createMoveModelElement();
        operation.setRemote(true);
        operation.setRightElement(right);
        operation.setLeftElement(left);
        operation.setRightTarget(this.getMatchedEObject(left.eContainer()));
        operation.setLeftTarget(this.getMatchedEObject(right.eContainer()));
        root.getSubDiffElements().add(operation);
    }

    private void createRemoteUpdateContainmentOperation(DiffGroup root, EObject left, EObject right) {
        UpdateContainmentFeature updateContainment = DiffFactory.eINSTANCE.createUpdateContainmentFeature();
        updateContainment.setRemote(true);
        updateContainment.setLeftElement(left);
        updateContainment.setRightElement(right);
        updateContainment.setRightTarget(this.getMatchedEObject(left.eContainer()));
        updateContainment.setLeftTarget(this.getMatchedEObject(right.eContainer()));
        root.getSubDiffElements().add(updateContainment);
    }

    private void createUpdateContainmentOperation(DiffGroup root, EObject left, EObject right) {
        UpdateContainmentFeature updateContainment = DiffFactory.eINSTANCE.createUpdateContainmentFeature();
        updateContainment.setLeftElement(left);
        updateContainment.setRightElement(right);
        updateContainment.setRightTarget(this.getMatchedEObject(left.eContainer()));
        updateContainment.setLeftTarget(this.getMatchedEObject(right.eContainer()));
        root.getSubDiffElements().add(updateContainment);
    }

    private void doDiffDelegate(DiffGroup root, Match2Elements match) {
        DiffGroup current = DiffFactory.eINSTANCE.createDiffGroup();
        current.setRightParent(match.getRightElement());
        try {
            this.checkForDiffs(current, match);
        }
        catch (FactoryException e) {
            this.log(e);
        }
        ArrayList<DiffElement> shouldAddToList = new ArrayList<DiffElement>();
        if (current.getSubDiffElements().size() > 0) {
            for (DiffElement diffElement : current.getSubDiffElements()) {
                if (diffElement instanceof DiffGroup) continue;
                shouldAddToList.add(diffElement);
            }
            for (DiffElement diffElement : shouldAddToList) {
                this.addInContainerPackage(root, diffElement, current.getRightParent());
            }
        }
        for (Match2Elements match2Elements : match.getSubMatchElements()) {
            this.doDiffDelegate(root, match2Elements);
        }
    }

    protected void log(Exception e) {
        EMFComparePlugin.log(e, false);
    }

    private void doDiffDelegate(DiffGroup root, Match3Elements match) {
        DiffGroup current = DiffFactory.eINSTANCE.createDiffGroup();
        current.setRightParent(match.getRightElement());
        try {
            this.checkForDiffs(current, match);
        }
        catch (FactoryException e) {
            this.log(e);
        }
        ArrayList<DiffElement> shouldAddToList = new ArrayList<DiffElement>();
        if (current.getSubDiffElements().size() > 0) {
            for (DiffElement diff : current.getSubDiffElements()) {
                if (diff instanceof DiffGroup) continue;
                shouldAddToList.add(diff);
            }
            for (DiffElement diff : shouldAddToList) {
                this.addInContainerPackage(root, diff, current.getRightParent());
            }
        }
        for (MatchElement element : match.getSubMatchElements()) {
            if (element instanceof Match3Elements) {
                this.doDiffDelegate(root, (Match3Elements)element);
                continue;
            }
            this.doDiffDelegate(root, (Match2Elements)element);
        }
    }

    private DiffGroup findExistingGroup(DiffGroup root, EObject targetParent) {
        return this.diffGroups.get(targetParent);
    }
}

