/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.internal.DiffCollectionsHelper;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheck {
    protected static final int ANCESTOR_OBJECT = 0;
    protected static final int LEFT_OBJECT = 1;
    protected static final int RIGHT_OBJECT = 2;
    protected final EcoreUtil.CrossReferencer crossReferencer;
    protected DiffCollectionsHelper matcherHelper;

    public AbstractCheck(EcoreUtil.CrossReferencer referencer) {
        this.crossReferencer = referencer;
        this.matcherHelper = new DiffCollectionsHelper(referencer);
    }

    protected final List<Object> convertFeatureMapList(List<?> input) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object inputValue : input) {
            result.add(this.internalFindActualEObject(inputValue));
        }
        return result;
    }

    protected final EObject getMatchedEObject(EObject from) {
        EObject matchedEObject = null;
        if (this.crossReferencer != null && from != null && this.crossReferencer.get(from) != null) {
            for (EStructuralFeature.Setting setting : (Collection)this.crossReferencer.get(from)) {
                if (!(setting.getEObject() instanceof Match2Elements)) continue;
                if (setting.getEStructuralFeature().getFeatureID() == 2) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                    continue;
                }
                if (setting.getEStructuralFeature().getFeatureID() != 3) continue;
                matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
            }
        }
        return matchedEObject;
    }

    protected final boolean isInScope(EObject eObj) {
        if (this.crossReferencer != null && eObj != null && this.crossReferencer.get(eObj) != null) {
            for (EStructuralFeature.Setting setting : (Collection)this.crossReferencer.get(eObj)) {
                if (!(setting.getEObject() instanceof Match2Elements) && !(setting.getEObject() instanceof UnmatchElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected final EObject getMatchedEObject(EObject from, int side) throws IllegalArgumentException {
        if (side != 1 && side != 2 && side != 0) {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("GenericDiffEngine.IllegalSide"));
        }
        EObject matchedEObject = null;
        if (this.crossReferencer != null) {
            Collection settings = (Collection)this.crossReferencer.get(from);
            if (settings == null) {
                return null;
            }
            for (EStructuralFeature.Setting setting : settings) {
                if (!(setting.getEObject() instanceof Match2Elements)) continue;
                if (side == 1) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
                    continue;
                }
                if (side == 2) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                    continue;
                }
                if (!(setting.getEObject() instanceof Match3Elements)) continue;
                matchedEObject = ((Match3Elements)setting.getEObject()).getOriginElement();
            }
        }
        return matchedEObject;
    }

    protected final boolean isUnmatched(EObject element) {
        Iterator it;
        return this.crossReferencer != null && this.crossReferencer.get(element) != null && (it = ((Collection)this.crossReferencer.get(element)).iterator()).hasNext() && ((EStructuralFeature.Setting)it.next()).getEObject() instanceof UnmatchElement;
    }

    private Object internalFindActualEObject(Object data) {
        if (data instanceof FeatureMap.Entry) {
            return this.internalFindActualEObject(((FeatureMap.Entry)data).getValue());
        }
        return data;
    }
}

