/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCollectionsHelper {
    private EcoreUtil.CrossReferencer crossReferencer;

    public DiffCollectionsHelper(EcoreUtil.CrossReferencer referencer) {
        this.crossReferencer = referencer;
    }

    public int getNumberOfMissingOccurrence(List<Object> referenceList, List<Object> testedList, Object value) {
        int expectedOccurrences = this.getNumberOfOccurrences(referenceList, value);
        int actualOccurrences = this.getNumberOfOccurrences(testedList, value);
        return expectedOccurrences - actualOccurrences;
    }

    private int getNumberOfOccurrences(List<Object> values, Object value) {
        int i = 0;
        for (Object aValue : values) {
            if (this.areDistinctValues(aValue, value)) continue;
            ++i;
        }
        return i;
    }

    public boolean areDistinctValues(Object left, Object right) {
        boolean distinct;
        if (left instanceof EEnumLiteral && right instanceof EEnumLiteral) {
            StringBuilder value1 = new StringBuilder();
            value1.append(((EEnumLiteral)left).getLiteral()).append(((EEnumLiteral)left).getValue());
            StringBuilder value2 = new StringBuilder();
            value2.append(((EEnumLiteral)right).getLiteral()).append(((EEnumLiteral)right).getValue());
            distinct = !value1.toString().equals(value2.toString());
        } else {
            distinct = left instanceof EObject && right instanceof EObject ? left != this.getMatchedEObject((EObject)right) : (left != null && left.getClass().isArray() ? this.areDistinctArrays(left, right) : left != null && !left.equals(right) || left == null && left != right);
        }
        return distinct;
    }

    protected final EObject getMatchedEObject(EObject from) {
        EObject matchedEObject = null;
        if (this.crossReferencer != null && from != null && this.crossReferencer.get(from) != null) {
            for (EStructuralFeature.Setting setting : (Collection)this.crossReferencer.get(from)) {
                if (!(setting.getEObject() instanceof Match2Elements)) continue;
                if (setting.getEStructuralFeature().getFeatureID() == 2) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                    continue;
                }
                if (setting.getEStructuralFeature().getFeatureID() != 3) continue;
                matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
            }
        }
        return matchedEObject;
    }

    private boolean areDistinctArrays(Object left, Object right) {
        boolean distinct = false;
        if (right == null || !right.getClass().isArray()) {
            distinct = true;
        } else {
            int rightLength;
            int leftLength = Array.getLength(left);
            if (leftLength != (rightLength = Array.getLength(right))) {
                distinct = true;
            } else {
                int i = 0;
                while (i < leftLength) {
                    Object rightElement;
                    Object leftElement = Array.get(left, i);
                    if (this.areDistinctValues(leftElement, rightElement = Array.get(right, i))) {
                        distinct = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return distinct;
    }
}

