/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.merge.impl;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReferenceChangeRightTargetMerger
extends DefaultMerger {
    public void applyInOrigin() {
        EObject rightElement;
        Object rightRefValue;
        ReferenceChangeRightTarget theDiff = (ReferenceChangeRightTarget)this.diff;
        EObject element = theDiff.getLeftElement();
        EObject rightTarget = theDiff.getRightTarget();
        EObject leftTarget = theDiff.getLeftTarget();
        EReference reference = theDiff.getReference();
        int index = -1;
        if (reference.isMany() && (rightRefValue = (rightElement = theDiff.getRightElement()).eGet(reference)) instanceof List) {
            List refRightValueList = (List)rightRefValue;
            index = refRightValueList.indexOf(rightTarget);
        }
        EObject copiedValue = MergeService.getCopier(this.diff).copyReferenceValue(reference, element, rightTarget, leftTarget, index);
        TreeIterator<EObject> related = this.getDiffModel().eAllContents();
        while (related.hasNext()) {
            ReferenceChange link;
            DiffElement op = (DiffElement)related.next();
            if (op instanceof ReferenceChangeRightTarget) {
                link = (ReferenceChangeRightTarget)op;
                if (!link.getReference().equals(theDiff.getReference().getEOpposite()) || !link.getRightTarget().equals(element)) continue;
                this.removeFromContainer(link);
                continue;
            }
            if (!(op instanceof ReferenceOrderChange) || !(link = (ReferenceOrderChange)op).getReference().equals(theDiff.getReference())) continue;
            link.getLeftTarget().add(copiedValue);
        }
        super.applyInOrigin();
    }

    public void undoInTarget() {
        ReferenceChangeRightTarget theDiff = (ReferenceChangeRightTarget)this.diff;
        EObject element = theDiff.getRightElement();
        EObject rightTarget = theDiff.getRightTarget();
        try {
            EFactory.eRemove(element, theDiff.getReference().getName(), rightTarget);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log(e, true);
        }
        TreeIterator<EObject> related = this.getDiffModel().eAllContents();
        while (related.hasNext()) {
            Resource res;
            DiffElement link;
            DiffElement op = (DiffElement)related.next();
            if (op instanceof ReferenceChangeRightTarget) {
                link = (ReferenceChangeRightTarget)op;
                if (!link.getReference().equals(theDiff.getReference().getEOpposite()) || !link.getRightTarget().equals(element)) continue;
                this.removeFromContainer(link);
                continue;
            }
            if (!(op instanceof ResourceDependencyChange) || (res = ((EObject)(link = (ResourceDependencyChange)op).getRoots().get(0)).eResource()) != rightTarget.eResource()) continue;
            EcoreUtil.remove(link);
            res.unload();
        }
        super.undoInTarget();
    }
}

