/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;

public class DiffExtensionDescriptor {
    protected final String contentType;
    protected final String diffextensionClassName;
    protected final IConfigurationElement element;
    protected final String fileExtension;
    protected final String namespace;
    private AbstractDiffExtension diffExtension;

    public DiffExtensionDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.diffextensionClassName = this.getAttribute("extensionClass", null);
        this.contentType = this.getAttribute("contentType", "");
        this.namespace = this.getAttribute("namespace", "");
        this.fileExtension = "".equals(this.contentType) && "".equals(this.namespace) ? this.getAttribute("fileExtension", "*") : this.getAttribute("fileExtension", "");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getdDiffExtensionClassName() {
        return this.diffextensionClassName;
    }

    public AbstractDiffExtension getDiffExtensionInstance() {
        if (this.diffExtension == null) {
            try {
                this.diffExtension = (AbstractDiffExtension)this.element.createExecutableExtension("extensionClass");
            }
            catch (CoreException e) {
                EMFComparePlugin.log(e, false);
            }
        }
        return this.diffExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.MissingAttribute", name));
    }
}

