/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge;

import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class DefaultMerger
implements IMerger {
    protected DiffElement diff;
    @Deprecated
    protected Resource leftResource;
    @Deprecated
    protected Resource rightResource;

    public void applyInOrigin() {
        this.handleMutuallyDerivedReferences();
        this.ensureXMIIDCopied();
        this.removeFromContainer(this.diff);
    }

    public boolean canApplyInOrigin() {
        return true;
    }

    public boolean canUndoInTarget() {
        return true;
    }

    public void setDiffElement(DiffElement element) {
        this.diff = element;
    }

    public void undoInTarget() {
        this.handleMutuallyDerivedReferences();
        this.ensureXMIIDCopied();
        this.removeFromContainer(this.diff);
    }

    protected void cleanDiffGroup(DiffGroup diffGroup) {
        EObject parent;
        if (diffGroup != null && diffGroup.getSubDiffElements().size() == 0 && (parent = diffGroup.eContainer()) instanceof DiffGroup) {
            EcoreUtil.remove(diffGroup);
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected EObject copy(EObject eObject) {
        EMFCompareEObjectCopier copier = MergeService.getCopier(this.diff);
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        copier.copyXMIIDs();
        return result;
    }

    protected void ensureXMIIDCopied() {
        EMFCompareEObjectCopier copier = MergeService.getCopier(this.diff);
        copier.copyXMIIDs();
    }

    protected DiffModel getDiffModel() {
        EObject container = this.diff.eContainer();
        while (container != null) {
            if (container instanceof DiffModel) {
                return (DiffModel)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    protected String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }

    protected void removeDanglingReferences(EObject deletedObject) {
    }

    protected void removeFromContainer(DiffElement diffElement) {
        EObject parent = diffElement.eContainer();
        EcoreUtil.remove(diffElement);
        this.removeDanglingReferences(parent);
        if (parent instanceof ConflictingDiffElement) {
            this.removeFromContainer((DiffElement)parent);
        }
        if (parent instanceof DiffGroup) {
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected void setXMIID(EObject object, String id) {
        if (object != null && object.eResource() instanceof XMIResource) {
            ((XMIResource)object.eResource()).setID(object, id);
        }
    }

    private void handleMutuallyDerivedReferences() {
        DiffElement toRemove = null;
        if (this.diff instanceof ReferenceChange) {
            EReference reference = ((ReferenceChange)this.diff).getReference();
            if (reference == EcorePackage.eINSTANCE.getEClass_ESuperTypes()) {
                EObject referenceType = null;
                if (this.diff instanceof ReferenceChangeLeftTarget) {
                    referenceType = ((ReferenceChangeLeftTarget)this.diff).getRightTarget();
                } else if (this.diff instanceof ReferenceChangeRightTarget) {
                    referenceType = ((ReferenceChangeRightTarget)this.diff).getLeftTarget();
                } else if (this.diff instanceof UpdateReference) {
                    referenceType = ((UpdateReference)this.diff).getLeftTarget();
                }
                for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                    if (siblingDiff instanceof ModelElementChangeLeftTarget) {
                        if (!(((ModelElementChangeLeftTarget)siblingDiff).getLeftElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeLeftTarget)siblingDiff).getLeftElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                    } else {
                        if (!(siblingDiff instanceof ModelElementChangeRightTarget) || !(((ModelElementChangeRightTarget)siblingDiff).getRightElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeRightTarget)siblingDiff).getRightElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                    }
                    break;
                }
            }
        } else if (this.diff instanceof ModelElementChangeLeftTarget && ((ModelElementChangeLeftTarget)this.diff).getLeftElement() instanceof EGenericType) {
            ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getLeftElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeLeftTarget) || ((ReferenceChangeLeftTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeLeftTarget)siblingDiff).getRightTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        } else if (this.diff instanceof ModelElementChangeRightTarget && ((ModelElementChangeRightTarget)this.diff).getRightElement() instanceof EGenericType) {
            ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getRightElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeRightTarget) || ((ReferenceChangeRightTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeRightTarget)siblingDiff).getLeftTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        }
        if (toRemove != null) {
            this.removeFromContainer(toRemove);
        }
    }
}

