/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.metamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DifferenceKind implements Enumerator
{
    ADDITION(0, "Addition", "Addition"),
    DELETION(1, "Deletion", "Deletion"),
    CHANGE(2, "Change", "Change"),
    MOVE(3, "Move", "Move");

    public static final int ADDITION_VALUE = 0;
    public static final int DELETION_VALUE = 1;
    public static final int CHANGE_VALUE = 2;
    public static final int MOVE_VALUE = 3;
    private static final DifferenceKind[] VALUES_ARRAY;
    public static final List<DifferenceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DifferenceKind[]{ADDITION, DELETION, CHANGE, MOVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DifferenceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DifferenceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DifferenceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DifferenceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DifferenceKind get(int value) {
        switch (value) {
            case 0: {
                return ADDITION;
            }
            case 1: {
                return DELETION;
            }
            case 2: {
                return CHANGE;
            }
            case 3: {
                return MOVE;
            }
        }
        return null;
    }

    private DifferenceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

