/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.compare.match.internal.filter.ResourceFilterRegistryEclipseUtil;
import org.osgi.framework.BundleContext;

public class MatchPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.match";
    private static MatchPlugin plugin;
    private static final String RESOURCE_FILTERS_CLASS_ATTRIBUTE = "class";
    private static final String RESOURCE_FILTERS_EXTENSION_POINT = "org.eclipse.emf.compare.match.resourcefilters";
    private static final String RESOURCE_FILTERS_FILTER_TAG = "filter";
    private final IRegistryChangeListener resourceFiltersListener = new ResourceFiltersRegistryListener();

    public MatchPlugin() {
        plugin = this;
    }

    public static MatchPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(this.resourceFiltersListener, PLUGIN_ID);
        this.parseInitialContributions();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeRegistryChangeListener(this.resourceFiltersListener);
        ResourceFilterRegistryEclipseUtil.clearRegistry();
        super.stop(context);
    }

    private void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(RESOURCE_FILTERS_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (RESOURCE_FILTERS_FILTER_TAG.equals(configurationElement.getName())) {
                    try {
                        ResourceFilterRegistryEclipseUtil.addFilter((IResourceFilter)configurationElement.createExecutableExtension(RESOURCE_FILTERS_CLASS_ATTRIBUTE));
                    }
                    catch (CoreException e) {
                        EMFComparePlugin.log(e, false);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    final class ResourceFiltersRegistryListener
    implements IRegistryChangeListener {
        private static final String RESOURCE_FILTERS_EP_SHORT = "resourcefilters";

        ResourceFiltersRegistryListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas(MatchPlugin.PLUGIN_ID, RESOURCE_FILTERS_EP_SHORT);
            int n = iExtensionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement;
                int n3;
                int n4;
                IConfigurationElement[] iConfigurationElementArray;
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                IExtension extension = delta.getExtension();
                if (delta.getKind() == 1) {
                    iConfigurationElementArray = extension.getConfigurationElements();
                    n4 = iConfigurationElementArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        configurationElement = iConfigurationElementArray[n3];
                        if (MatchPlugin.RESOURCE_FILTERS_FILTER_TAG.equals(configurationElement.getName())) {
                            try {
                                ResourceFilterRegistryEclipseUtil.addFilter((IResourceFilter)configurationElement.createExecutableExtension(MatchPlugin.RESOURCE_FILTERS_CLASS_ATTRIBUTE));
                            }
                            catch (CoreException e) {
                                EMFComparePlugin.log(e, false);
                            }
                        }
                        ++n3;
                    }
                } else if (delta.getKind() == 2) {
                    iConfigurationElementArray = extension.getConfigurationElements();
                    n4 = iConfigurationElementArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        configurationElement = iConfigurationElementArray[n3];
                        if (MatchPlugin.RESOURCE_FILTERS_FILTER_TAG.equals(configurationElement.getName())) {
                            ResourceFilterRegistryEclipseUtil.removeFilter(configurationElement.getAttribute(MatchPlugin.RESOURCE_FILTERS_CLASS_ATTRIBUTE));
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    }
}

