/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatchScope
implements IMatchScope {
    private final Set<Resource> resourcesInScope = new LinkedHashSet<Resource>();
    private final List<EObject> eObjectsInScope = new ArrayList<EObject>();

    public GenericMatchScope(EObject eObject) {
        this.eObjectsInScope.add(eObject);
        TreeIterator<EObject> iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            this.eObjectsInScope.add(next);
            if (next.eResource() == null || this.resourcesInScope.contains(next.eResource())) continue;
            this.resolveAll(next.eResource().getResourceSet());
            this.addToScope(next.eResource());
        }
    }

    public GenericMatchScope(Resource scope) {
        this.resolveAll(scope.getResourceSet());
        this.addToScope(scope);
    }

    public GenericMatchScope(ResourceSet scope) {
        this.resolveAll(scope);
        for (Resource res : scope.getResources()) {
            this.addToScope(res);
        }
    }

    @Override
    public boolean isInScope(EObject eObject) {
        if (this.eObjectsInScope.contains(eObject)) {
            return true;
        }
        Resource resource = this.getContainingResource(eObject);
        if (resource == null) {
            return false;
        }
        return this.isInScope(resource);
    }

    protected void addToScope(Resource newResource) {
        this.resourcesInScope.add(newResource);
    }

    private Resource getContainingResource(EObject eObject) {
        if (eObject.eResource() != null) {
            return eObject.eResource();
        }
        for (Resource resourceInScope : this.getResourcesInScope()) {
            if (!ModelUtils.contains(resourceInScope, eObject)) continue;
            return resourceInScope;
        }
        return null;
    }

    @Override
    public boolean isInScope(Resource resource) {
        return this.getResourcesInScope().contains(resource);
    }

    public List<Resource> getResourcesInScope() {
        return new ArrayList<Resource>(this.resourcesInScope);
    }

    protected void resolveAll(ResourceSet resourceSet) {
        if (resourceSet != null) {
            EList<Resource> resources = resourceSet.getResources();
            int i = 0;
            while (i < resources.size()) {
                TreeIterator<EObject> resourceContent = ((Resource)resources.get(i)).getAllContents();
                while (resourceContent.hasNext()) {
                    EObject eObject = (EObject)resourceContent.next();
                    Iterator objectChildren = eObject.eCrossReferences().iterator();
                    while (objectChildren.hasNext()) {
                        objectChildren.next();
                    }
                }
                ++i;
            }
        }
    }
}

