/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.util.EMFCompareMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchSettings {
    private int searchWindow = 100;
    private boolean ignoresXMIID = false;
    private boolean ignoreID = false;
    private boolean distingMetamodels = false;
    private Object progressMonitor;

    public MatchSettings() {
        this.update(this.loadPreferenceOptionMap());
    }

    public void update(Map<String, Object> options) {
        if (this.isSet(options, "match.distinct.metamodels")) {
            this.distingMetamodels = (Boolean)this.getOption(options, "match.distinct.metamodels");
        }
        if (this.isSet(options, "match.ignore.id")) {
            this.ignoreID = (Boolean)this.getOption(options, "match.ignore.id");
        }
        if (this.isSet(options, "match.ignore.xmi.id")) {
            this.ignoresXMIID = (Boolean)this.getOption(options, "match.ignore.xmi.id");
        }
        if (this.isSet(options, "match.progress.monitor")) {
            this.progressMonitor = this.getOption(options, "match.progress.monitor");
        }
        if (this.isSet(options, "match.search.window")) {
            this.searchWindow = (Integer)this.getOption(options, "match.search.window");
        }
    }

    public void setSearchWindow(int windowSize) {
        this.searchWindow = windowSize;
    }

    public void ignoreXMIID(boolean ignore) {
        this.ignoresXMIID = ignore;
    }

    public void ignoreEcoreID(boolean ignore) {
        this.ignoreID = ignore;
    }

    public void matchDistinctMetamodels(boolean distinctMetamodels) {
        this.distingMetamodels = distinctMetamodels;
    }

    public void setProgressMonitor(Object monitor) {
        this.progressMonitor = monitor;
    }

    public final int getSearchWindow() {
        return this.searchWindow;
    }

    public final boolean isIgnoringXMIID() {
        return this.ignoresXMIID;
    }

    public final boolean isIgnoringID() {
        return this.ignoreID;
    }

    public final boolean shouldMatchDistinctMetamodels() {
        return this.distingMetamodels;
    }

    public final Object getProgressMonitor() {
        return this.progressMonitor;
    }

    private <T> T getOption(Map<String, Object> options, String key) throws ClassCastException {
        return (T)options.get(key);
    }

    private boolean isSet(Map<String, Object> options, String optionID) {
        return options.containsKey(optionID);
    }

    private Map<String, Object> loadPreferenceOptionMap() {
        EMFCompareMap<String, Object> optionMap = new EMFCompareMap<String, Object>(17);
        optionMap.put("match.search.window", this.getPreferenceSearchWindow());
        optionMap.put("match.ignore.id", this.getPreferenceIgnoreID());
        optionMap.put("match.ignore.xmi.id", this.getPreferenceIgnoreXMIID());
        optionMap.put("match.distinct.metamodels", this.getPreferenceDistinctMetaModel());
        optionMap.put("match.progress.monitor", null);
        return optionMap;
    }

    private boolean getPreferenceDistinctMetaModel() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null) {
            return EMFComparePlugin.getDefault().getBoolean("emfcompare.distinct.metamodel");
        }
        return false;
    }

    private boolean getPreferenceIgnoreID() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null) {
            return EMFComparePlugin.getDefault().getBoolean("emfcompare.ignore.ID");
        }
        return false;
    }

    private boolean getPreferenceIgnoreXMIID() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null) {
            return EMFComparePlugin.getDefault().getBoolean("emfcompare.ignore.XMI.ID");
        }
        return false;
    }

    private int getPreferenceSearchWindow() {
        int searchWindowPrefereence = 100;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null && EMFComparePlugin.getDefault().getInt("emfcompare.search.window") > 0) {
            searchWindowPrefereence = EMFComparePlugin.getDefault().getInt("emfcompare.search.window");
        }
        if (searchWindowPrefereence < 0) {
            searchWindowPrefereence = 0;
        }
        return searchWindowPrefereence;
    }
}

