/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.internal.statistic;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameSimilarity {
    private static final String EOBJECT_NAME_FEATURE = "name";
    private static final int MAX_FEATURE_VALUE_LENGTH = 50;
    private static final Map<String, EAttribute> NAME_FEATURE_CACHE = new EMFCompareMap<String, EAttribute>();

    private NameSimilarity() {
    }

    public static String contentValue(EObject current) throws FactoryException {
        return NameSimilarity.contentValue(current, null);
    }

    public static String contentValue(EObject current, MetamodelFilter filter) throws FactoryException {
        EClass eclass = current.eClass();
        StringBuilder result = new StringBuilder();
        List<Object> eclassAttributes = new ArrayList<EAttribute>();
        if (filter != null) {
            eclassAttributes = filter.getFilteredFeatures(current);
            eclassAttributes.remove(NameSimilarity.findNameFeature(current));
        } else {
            eclassAttributes.addAll(eclass.getEAllAttributes());
        }
        if (eclassAttributes.size() > 0) {
            for (EStructuralFeature eStructuralFeature : eclassAttributes) {
                String value;
                if (!(eStructuralFeature instanceof EAttribute) || (value = EFactory.eGetAsString(current, eStructuralFeature.getName())) == null || value.length() >= 50) continue;
                result.append(value).append(" ");
            }
        }
        return result.toString();
    }

    public static String findName(EObject current) throws FactoryException {
        String name = "";
        if (current != null) {
            EAttribute nameFeature = NameSimilarity.findNameFeature(current);
            if (nameFeature != null) {
                String bestFeatureName = nameFeature.getName();
                name = EFactory.eGetAsString(current, bestFeatureName);
                if (name == null || "".equals(name)) {
                    name = current.eClass().getName();
                }
            } else {
                name = current.eClass().getName();
            }
        }
        return name;
    }

    public static EAttribute findNameFeature(EObject current) {
        EClass eclass = current.eClass();
        EAttribute bestFeature = NAME_FEATURE_CACHE.get(String.valueOf(eclass.getName()) + eclass.hashCode());
        if (bestFeature == null) {
            EList<EAttribute> eClassAttributes = eclass.getEAllAttributes();
            if (eClassAttributes.size() > 0) {
                bestFeature = (EAttribute)eClassAttributes.get(0);
            }
            if (eClassAttributes.size() > 0) {
                double max = 0.0;
                for (EAttribute attribute : eClassAttributes) {
                    String attributeName = attribute.getName();
                    if (!(NameSimilarity.nameSimilarityMetric(attributeName, EOBJECT_NAME_FEATURE) > max)) continue;
                    max = NameSimilarity.nameSimilarityMetric(attributeName, EOBJECT_NAME_FEATURE);
                    bestFeature = attribute;
                }
                NAME_FEATURE_CACHE.put(String.valueOf(eclass.getName()) + eclass.hashCode(), bestFeature);
            }
        }
        return bestFeature;
    }

    public static double nameSimilarityMetric(String str1, String str2) {
        double result = 0.0;
        double almostEquals = 0.999999;
        if (str1 != null && str2 != null) {
            if (str1.equals(str2)) {
                result = 1.0;
            } else if (str1.length() <= 2 && str2.length() <= 2) {
                int equalChars = 0;
                char[] str1Value = str1.toCharArray();
                char[] str2Value = str2.toCharArray();
                int i = 0;
                while (i < Math.min(str1Value.length, str2Value.length)) {
                    if (str1Value[i] == str2Value[i]) {
                        ++equalChars;
                    }
                    ++i;
                }
                result = str1Value.length != str2Value.length ? (double)equalChars / (double)(str1Value.length + str2Value.length) : (double)equalChars * 2.0 / (double)(str1Value.length + str2Value.length);
            } else if (str1.length() != 1 && str2.length() != 1) {
                String string1 = str1.toLowerCase();
                String string2 = str2.toLowerCase();
                List<String> pairs1 = NameSimilarity.pairs(string1);
                List<String> pairs2 = NameSimilarity.pairs(string2);
                double union = pairs1.size() + pairs2.size();
                int inter = NameSimilarity.retainCount(pairs1, NameSimilarity.pairSet(string2));
                result = (double)inter * 2.0 / union;
                if (result > 1.0) {
                    result = 1.0;
                } else if (result > 0.999999) {
                    result = 0.999999;
                }
            }
        }
        return result;
    }

    private static int retainCount(List<String> a, Set<String> b) {
        int count = 0;
        for (String aPair : a) {
            if (!b.contains(aPair)) continue;
            ++count;
        }
        return count;
    }

    public static List<String> pairs(String source) {
        ArrayList<String> result = new ArrayList<String>();
        if (source != null) {
            int length = source.length();
            int i = 0;
            while (i < length - 1) {
                result.add(source.substring(i, i + 2));
                ++i;
            }
        }
        return result;
    }

    private static Set<String> pairSet(String source) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (source != null) {
            int length = source.length();
            int i = 0;
            while (i < length - 1) {
                result.add(source.substring(i, i + 2));
                ++i;
            }
        }
        return result;
    }
}

