/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.internal.statistic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.internal.statistic.NameSimilarity;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class StructureSimilarity {
    private StructureSimilarity() {
    }

    public static double relationsSimilarityMetric(EObject obj1, EObject obj2, MetamodelFilter filter) throws FactoryException {
        return NameSimilarity.nameSimilarityMetric(StructureSimilarity.relationsValue(obj1, filter), StructureSimilarity.relationsValue(obj2, filter));
    }

    public static double typeSimilarityMetric(EObject obj1, EObject obj2) throws FactoryException {
        int attributesCount = obj1.eClass().getEAllAttributes().size() + obj2.eClass().getEAllAttributes().size();
        int referencesCount = obj1.eClass().getEAllReferences().size() + obj2.eClass().getEAllReferences().size();
        double attributesSimilarity = NameSimilarity.nameSimilarityMetric(StructureSimilarity.attributeTypeValue(obj1), StructureSimilarity.attributeTypeValue(obj2));
        double referencesSimilarity = NameSimilarity.nameSimilarityMetric(StructureSimilarity.referenceTypeValue(obj1), StructureSimilarity.referenceTypeValue(obj2));
        double similarity = attributesSimilarity * (double)attributesCount + referencesSimilarity * (double)referencesCount;
        return similarity /= (double)(attributesCount + referencesCount);
    }

    private static String attributeTypeValue(EObject current) throws FactoryException {
        StringBuilder result = new StringBuilder();
        EList<EAttribute> attributes = current.eClass().getEAllAttributes();
        for (EAttribute attribute : attributes) {
            result.append(attribute.eClass().getName()).append(NameSimilarity.findName(attribute));
        }
        return result.toString();
    }

    private static String childrenValue(EObject current, MetamodelFilter filter) throws FactoryException {
        EClass eclass = current.eClass();
        StringBuilder result = new StringBuilder();
        List<Object> eObjectFeatures = new ArrayList<EReference>();
        if (filter != null) {
            eObjectFeatures = filter.getFilteredFeatures(current);
        } else {
            eObjectFeatures.addAll(eclass.getEAllReferences());
        }
        for (EStructuralFeature eStructuralFeature : eObjectFeatures) {
            if (!(eStructuralFeature instanceof EReference) || ((EReference)eStructuralFeature).isDerived()) continue;
            Object value = current.eGet(eStructuralFeature);
            if (value instanceof List) {
                for (Object next : (List)value) {
                    if (!(next instanceof EObject)) continue;
                    String objName = NameSimilarity.findName((EObject)next);
                    result.append(objName);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            String objName = NameSimilarity.findName((EObject)value);
            result.append(objName);
        }
        return result.toString();
    }

    private static String referenceTypeValue(EObject current) throws FactoryException {
        StringBuilder result = new StringBuilder();
        EList<EReference> references = current.eClass().getEAllReferences();
        for (EReference reference : references) {
            result.append(reference.eClass().getName()).append(NameSimilarity.findName(reference));
        }
        return result.toString();
    }

    private static String relationsValue(EObject current, MetamodelFilter filter) throws FactoryException {
        StringBuilder result = new StringBuilder();
        result.append(StructureSimilarity.childrenValue(current, filter));
        EObject container = current.eContainer();
        if (container != null) {
            result.append(NameSimilarity.findName(container));
        }
        return result.toString();
    }
}

