/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EFactory {
    private EFactory() {
    }

    public static <T> void eAdd(EObject object, String name, T arg) throws FactoryException {
        EFactory.eAdd(object, name, arg, -1);
    }

    public static <T> void eAdd(EObject object, String name, T arg, int elementIndex) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (feature.isMany()) {
            if (arg != null) {
                Object manyValue = object.eGet(feature);
                if (manyValue instanceof InternalEList) {
                    InternalEList basicEList = (InternalEList)manyValue;
                    int listSize = basicEList.size();
                    if (elementIndex > -1 && elementIndex < listSize) {
                        basicEList.addUnique(elementIndex, arg);
                    } else {
                        basicEList.addUnique(arg);
                    }
                } else if (manyValue instanceof List) {
                    List list = (List)manyValue;
                    int listSize = list.size();
                    if (elementIndex > -1 && elementIndex < listSize) {
                        list.add(elementIndex, arg);
                    } else {
                        list.add(arg);
                    }
                } else if (manyValue instanceof Collection) {
                    ((Collection)manyValue).add(arg);
                }
            }
        } else {
            EFactory.eSet(object, name, arg);
        }
    }

    public static <T> void eInsertAt(EObject object, String name, T arg, int insertionIndex) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (feature.isMany()) {
            List target = (List)object.eGet(feature);
            int actualIndex = insertionIndex;
            if (insertionIndex < 0) {
                actualIndex = 0;
            } else if (insertionIndex > target.size()) {
                actualIndex = target.size();
            }
            if (arg != null) {
                target.add(actualIndex, arg);
            }
        } else {
            EFactory.eSet(object, name, arg);
        }
    }

    public static Object eGet(EObject object, String name) throws FactoryException {
        Object result = null;
        try {
            EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
            result = object.eGet(feature);
        }
        catch (FactoryException eGet) {
            try {
                result = EFactory.eCall(object, name, new Object[0]);
            }
            catch (FactoryException eCall) {
                throw eGet;
            }
            catch (NullPointerException e) {
                throw eGet;
            }
        }
        return result;
    }

    public static List<?> eGetAsList(EObject object, String name) throws FactoryException {
        List<Object> list = new ArrayList();
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null) {
            if (eGet instanceof List) {
                list = (List)eGet;
            } else {
                list = new BasicEList(1);
                list.add(eGet);
            }
        }
        return list;
    }

    public static String eGetAsString(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null) {
            return eGet.toString();
        }
        return null;
    }

    public static void eRemove(EObject object, String name, Object arg) throws FactoryException {
        Object list = object.eGet(EFactory.eStructuralFeature(object, name));
        if (list instanceof List) {
            if (arg != null) {
                ((List)list).remove(arg);
            }
        } else {
            EFactory.eSet(object, name, null);
        }
    }

    public static void eSet(EObject object, String name, Object arg) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (!feature.isChangeable()) {
            throw new FactoryException(EMFCompareMessages.getString("EFactory.UnSettableFeature", name));
        }
        if (feature.getEType() instanceof EEnum && arg instanceof String) {
            EEnumLiteral literal = ((EEnum)feature.getEType()).getEEnumLiteral((String)arg);
            object.eSet(feature, literal);
        } else if (arg == null && feature.isMany()) {
            object.eSet(feature, Collections.EMPTY_LIST);
        } else if (arg == null) {
            object.eSet(feature, feature.getDefaultValue());
        } else {
            object.eSet(feature, arg);
        }
    }

    public static EStructuralFeature eStructuralFeature(EObject object, String name) throws FactoryException {
        EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(name);
        if (structuralFeature != null) {
            return structuralFeature;
        }
        throw new FactoryException(EMFCompareMessages.getString("EFactory.FeatureNotFound", name, object.eClass().getName()));
    }

    private static Object eCall(Object object, String name, Object ... arg) throws FactoryException {
        try {
            Class[] methodParams = new Class[arg.length];
            Object[] invocationParams = arg;
            int i = 0;
            while (i < arg.length) {
                methodParams[i] = arg[i].getClass();
                ++i;
            }
            Method method = object.getClass().getMethod(name, methodParams);
            return method.invoke(object, invocationParams);
        }
        catch (NoSuchMethodException e) {
            throw new FactoryException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new FactoryException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new FactoryException(e.getMessage());
        }
    }
}

