/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.Customizable;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.util.Adaptable;
import org.eclipse.ocl.util.OCLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationEnvironment<C, O, P, CLS, E>
implements EvaluationEnvironment<C, O, P, CLS, E>,
Adaptable,
Customizable {
    private final EvaluationEnvironment<C, O, P, CLS, E> parent;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final Map<Option<?>, Object> options = new HashMap();

    protected AbstractEvaluationEnvironment() {
        this(null);
    }

    protected AbstractEvaluationEnvironment(EvaluationEnvironment<C, O, P, CLS, E> parent) {
        this.parent = parent;
    }

    protected EvaluationEnvironment<C, O, P, CLS, E> getParent() {
        return this.parent;
    }

    @Override
    public Object getValueOf(String name) {
        return this.map.get(name);
    }

    @Override
    public void replace(String name, Object value) {
        this.map.put(name, value);
    }

    @Override
    public void add(String name, Object value) {
        if (this.map.containsKey(name)) {
            String message = OCLMessages.bind(OCLMessages.BindingExist_ERROR_, name, this.map.get(name));
            throw new IllegalArgumentException(message);
        }
        this.map.put(name, value);
    }

    @Override
    public Object remove(String name) {
        return this.map.remove(name);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean overrides(O operation, int opcode) {
        return this.getParent() != null ? this.getParent().overrides(operation, opcode) : false;
    }

    @Override
    public Object callOperation(O operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        if (this.getParent() != null) {
            return this.getParent().callOperation(operation, opcode, source, args);
        }
        Method method = this.getJavaMethodFor(operation, source);
        if (method != null) {
            try {
                Class<?>[] parmTypes = method.getParameterTypes();
                int i = 0;
                while (i < parmTypes.length) {
                    if (EList.class.isAssignableFrom(parmTypes[i])) {
                        if (args[i] == null) {
                            args[i] = ECollections.EMPTY_ELIST;
                        } else if (!(args[i] instanceof Collection)) {
                            BasicEList.FastCompare<Object> list = new BasicEList.FastCompare<Object>(1);
                            list.add(args[i]);
                            args[i] = list;
                        } else if (!(args[i] instanceof EList)) {
                            args[i] = new BasicEList.FastCompare((Collection)args[i]);
                        }
                    }
                    ++i;
                }
                return method.invoke(source, args);
            }
            catch (Exception e) {
                OCLPlugin.catching(this.getClass(), "callOperation", e);
                OCLPlugin.log(4, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, "calloperation", e.getLocalizedMessage()), e);
                return this.getInvalidResult();
            }
        }
        switch (opcode) {
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                if (!(source instanceof Comparable) || args.length != 1) break;
                Comparable comparable = (Comparable)source;
                Object other = args[0];
                switch (opcode) {
                    case 67: {
                        if (comparable.compareTo(other) < 0) {
                            return true;
                        }
                        return false;
                    }
                    case 68: {
                        if (comparable.compareTo(other) > 0) {
                            return true;
                        }
                        return false;
                    }
                    case 69: {
                        if (comparable.compareTo(other) <= 0) {
                            return true;
                        }
                        return false;
                    }
                    case 70: {
                        if (comparable.compareTo(other) >= 0) {
                            return true;
                        }
                        return false;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    protected abstract Method getJavaMethodFor(O var1, Object var2);

    protected abstract Object getInvalidResult();

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEvaluationEnvironment<C, O, P, CLS, E> result = adapterType.isInstance(this) ? this : null;
        return (T)result;
    }

    protected Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
        HashMap result = parent != null ? new HashMap(parent.getOptions()) : new HashMap();
        result.putAll(this.basicGetOptions());
        return result;
    }

    @Override
    public <T> void setOption(Option<T> option, T value) {
        this.basicGetOptions().put(option, value);
    }

    @Override
    public <T> void putOptions(Map<? extends Option<T>, ? extends T> options) {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        myOptions.clear();
        myOptions.putAll(options);
    }

    @Override
    public <T> T removeOption(Option<T> option) {
        T result = this.getValue(option);
        this.basicGetOptions().remove(option);
        return result;
    }

    @Override
    public <T> Map<Option<T>, T> removeOptions(Collection<Option<T>> options) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        for (Option<T> next : options) {
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public boolean isEnabled(Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> T getValue(Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
            result = parent != null ? parent.getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }
}

