/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.DelegateDomain;
import org.eclipse.ocl.ecore.delegate.DelegateEPackageAdapter;
import org.eclipse.ocl.ecore.delegate.DelegatedBehavior;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.delegate.ValidationBehavior;
import org.eclipse.ocl.ecore.impl.NullLiteralExpImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatedBehavior<E extends EModelElement, R, F>
implements DelegatedBehavior<E, R, F> {
    private static List<DelegatedBehavior<?, ?, ?>> delegatedBehaviors = null;
    public static final OCLExpression NO_OCL_DEFINITION = new NullLiteralExpImpl(){};

    public static List<DelegatedBehavior<?, ?, ?>> getDelegatedBehaviors() {
        if (delegatedBehaviors == null) {
            delegatedBehaviors = new ArrayList();
            delegatedBehaviors.add(InvocationBehavior.INSTANCE);
            delegatedBehaviors.add(SettingBehavior.INSTANCE);
            delegatedBehaviors.add(ValidationBehavior.INSTANCE);
        }
        return delegatedBehaviors;
    }

    public static boolean isNoOCLDefinition(OCLExpression e) {
        return e == NO_OCL_DEFINITION;
    }

    public List<DelegateDomain> getDelegateDomains(E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        ArrayList<DelegateDomain> delegateDomains = new ArrayList<DelegateDomain>();
        for (DelegateDomain delegateDomain : adapter.getDelegateDomains(this)) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            delegateDomains.add(delegateDomain);
        }
        return delegateDomains;
    }

    @Override
    public List<F> getFactories(E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        ArrayList<F> factories = new ArrayList<F>();
        for (DelegateDomain delegateDomain : adapter.getDelegateDomains(this)) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            F factory = this.getFactory(delegateDomain, eObject);
            if (factory == null) {
                factory = this.getDefaultFactory();
            }
            if (factory == null || factories.contains(factory)) continue;
            factories.add(factory);
        }
        return factories;
    }

    protected abstract F getFactory(DelegateDomain var1, E var2);

    @Override
    public F getFactory(E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        for (DelegateDomain delegateDomain : adapter.getDelegateDomains(this)) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            F factory = this.getFactory(delegateDomain, eObject);
            if (factory == null) {
                factory = this.getDefaultFactory();
            }
            return factory;
        }
        return null;
    }

    @Override
    public void setDelegates(EPackage ePackage, List<String> delegateURIs) {
        String name = this.getName();
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (delegateURIs == null || delegateURIs.isEmpty()) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove(name);
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                ePackage.getEAnnotations().add(eAnnotation);
            }
            StringBuffer value = new StringBuffer();
            Iterator<String> i = delegateURIs.iterator();
            while (i.hasNext()) {
                value.append(i.next());
                if (!i.hasNext()) continue;
                value.append(' ');
            }
            eAnnotation.getDetails().put(name, value.toString());
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + " => " + this.getFactoryClass().getName();
    }

    protected static class ExpressionCacheAdapter
    extends AdapterImpl {
        private final OCLExpression expression;

        public static void cacheOCLExpression(EModelElement modelElement, OCLExpression e) {
            Iterator i = modelElement.eAdapters().iterator();
            while (i.hasNext()) {
                if (!((Adapter)i.next()).isAdapterForType(ExpressionCacheAdapter.class)) continue;
                i.remove();
            }
            if (e != null) {
                ExpressionCacheAdapter newAdapter = new ExpressionCacheAdapter(e);
                modelElement.eAdapters().add(newAdapter);
            }
        }

        public static OCLExpression getCachedOCLExpression(EModelElement modelElement) {
            Adapter a = EcoreUtil.getExistingAdapter(modelElement, ExpressionCacheAdapter.class);
            if (a != null) {
                return ((ExpressionCacheAdapter)a).getExpression();
            }
            return null;
        }

        public ExpressionCacheAdapter(OCLExpression expression) {
            this.expression = expression;
        }

        public OCLExpression getExpression() {
            return this.expression;
        }

        public boolean isAdapterForType(Object type) {
            return type == ExpressionCacheAdapter.class;
        }
    }
}

