/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.ecore.delegate.DelegateDomain;
import org.eclipse.ocl.ecore.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.ecore.delegate.DelegatedBehavior;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomainFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateEPackageAdapter
extends AdapterImpl {
    protected Map<String, DelegateDomain> delegateDomainMap = null;
    protected Map<String, List<DelegateDomain>> delegatedBehaviorMap = null;

    public static DelegateEPackageAdapter findAdapter(EPackage ePackage) {
        return (DelegateEPackageAdapter)EcoreUtil.getAdapter(ePackage.eAdapters(), DelegateEPackageAdapter.class);
    }

    public static DelegateEPackageAdapter getAdapter(EPackage ePackage) {
        DelegateEPackageAdapter adapter = (DelegateEPackageAdapter)EcoreUtil.getAdapter(ePackage.eAdapters(), DelegateEPackageAdapter.class);
        if (adapter == null) {
            adapter = new DelegateEPackageAdapter();
            ePackage.eAdapters().add(adapter);
        }
        return adapter;
    }

    protected DelegateDomain createDelegateDomain(String delegateURI) {
        EPackage ePackage = this.getTarget();
        DelegateDomain.Factory.Registry registry = DelegateResourceSetAdapter.getRegistry(ePackage, DelegateDomain.Factory.Registry.class, DelegateDomain.Factory.Registry.INSTANCE);
        DelegateDomain.Factory factory = registry.getFactory(delegateURI);
        if (factory == null) {
            factory = OCLDelegateDomainFactory.INSTANCE;
        }
        return factory.createDelegateDomain(delegateURI, ePackage);
    }

    public DelegateDomain getDelegateDomain(String delegateURI) {
        if (this.delegateDomainMap == null) {
            this.getDelegateDomains();
        }
        return this.delegateDomainMap.get(delegateURI);
    }

    public Map<String, DelegateDomain> getDelegateDomains() {
        if (this.delegateDomainMap == null) {
            this.delegatedBehaviorMap = new HashMap<String, List<DelegateDomain>>();
            this.delegateDomainMap = new HashMap<String, DelegateDomain>();
            EPackage ePackage = this.getTarget();
            EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
            if (eAnnotation != null) {
                for (DelegatedBehavior<?, ?, ?> delegatedBehavior : AbstractDelegatedBehavior.getDelegatedBehaviors()) {
                    String behaviorName = delegatedBehavior.getName();
                    String delegateURIs = eAnnotation.getDetails().get(behaviorName);
                    if (delegateURIs == null) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(delegateURIs);
                    while (stringTokenizer.hasMoreTokens()) {
                        String delegateURI = stringTokenizer.nextToken();
                        this.initializeDelegatedBehavior(delegateURI, delegatedBehavior);
                    }
                }
            }
        }
        return this.delegateDomainMap;
    }

    public List<DelegateDomain> getDelegateDomains(DelegatedBehavior<?, ?, ?> delegatedBehavior) {
        List<DelegateDomain> list;
        if (this.delegatedBehaviorMap == null) {
            this.getDelegateDomains();
        }
        if ((list = this.delegatedBehaviorMap.get(delegatedBehavior.getName())) != null) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public EPackage getTarget() {
        return (EPackage)super.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDelegatedBehavior(String delegateURI, DelegatedBehavior<?, ?, ?> delegatedBehavior) {
        String behaviorName = delegatedBehavior.getName();
        Map<String, DelegateDomain> map = this.delegateDomainMap;
        synchronized (map) {
            DelegateDomain delegateDomain = this.loadDelegateDomain(delegateURI);
            List<DelegateDomain> delegateBehaviorList = this.delegatedBehaviorMap.get(behaviorName);
            if (delegateBehaviorList == null) {
                delegateBehaviorList = new ArrayList<DelegateDomain>();
                this.delegatedBehaviorMap.put(behaviorName, delegateBehaviorList);
            }
            if (!delegateBehaviorList.contains(delegateDomain)) {
                delegateBehaviorList.add(delegateDomain);
            }
        }
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == DelegateEPackageAdapter.class;
    }

    DelegateDomain loadDelegateDomain(String delegateURI) {
        DelegateDomain delegateDomain;
        if (this.delegateDomainMap == null) {
            this.getDelegateDomains();
        }
        if ((delegateDomain = this.delegateDomainMap.get(delegateURI)) == null) {
            delegateDomain = this.createDelegateDomain(delegateURI);
            this.delegateDomainMap.put(delegateURI, delegateDomain);
        }
        return delegateDomain;
    }

    @Override
    public void setTarget(Notifier newTarget) {
        EPackage resourceSet = (EPackage)newTarget;
        super.setTarget(resourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadDelegates() {
        if (this.delegateDomainMap != null) {
            ArrayList<DelegateDomain> delegateDomains;
            Map<String, DelegateDomain> map = this.delegateDomainMap;
            synchronized (map) {
                delegateDomains = new ArrayList<DelegateDomain>(this.delegateDomainMap.values());
            }
            for (DelegateDomain delegateDomain : delegateDomains) {
                delegateDomain.dispose();
            }
        }
    }
}

