/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInvocationDelegate;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.ecore.delegate.OCLDelegateException;
import org.eclipse.ocl.ecore.delegate.ValueConverter;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLInvocationDelegate
extends BasicInvocationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    private OCLExpression body;
    private ValueConverter converter;

    public OCLInvocationDelegate(OCLDelegateDomain delegateDomain, EOperation operation) {
        super(operation);
        this.delegateDomain = delegateDomain;
        this.converter = operation.isMany() ? ValueConverter.LIST : ValueConverter.VERBATIM;
    }

    @Override
    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        Object result;
        OCL ocl = this.delegateDomain.getOCL();
        if (this.body == null) {
            this.body = InvocationBehavior.INSTANCE.getOperationBody(ocl, this.eOperation);
        }
        if (this.body == null) {
            String message = NLS.bind(OCLMessages.MissingBodyForInvocationDelegate_ERROR_, this.getOperationName());
            throw new OCLDelegateException(message);
        }
        Query query = ocl.createQuery((org.eclipse.ocl.expressions.OCLExpression)this.body);
        EList<EParameter> parms = this.eOperation.getEParameters();
        if (!parms.isEmpty()) {
            EvaluationEnvironment env = query.getEvaluationEnvironment();
            int i = 0;
            while (i < parms.size()) {
                env.add(((EParameter)parms.get(i)).getName(), arguments.get(i));
                ++i;
            }
        }
        if (ocl.isInvalid(result = query.evaluate(target))) {
            String message = NLS.bind(OCLMessages.EvaluationResultIsInvalid_ERROR_, this.getOperationName());
            throw new OCLDelegateException(message);
        }
        return this.converter.convert(ocl, result);
    }

    public String getOperationName() {
        return String.valueOf(this.eOperation.getEContainingClass().getEPackage().getName()) + "::" + this.eOperation.getEContainingClass().getName() + "." + this.eOperation.getName();
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":setting> " + this.getOperationName();
    }
}

