/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryDelegate
implements QueryDelegate {
    protected final OCLDelegateDomain delegateDomain;
    protected final EClassifier context;
    protected final Map<String, EClassifier> variables;
    protected final String expression;
    private OCLExpression query = null;

    public OCLQueryDelegate(OCLDelegateDomain delegateDomain, EClassifier context, Map<String, EClassifier> variables, String expression) {
        this.delegateDomain = delegateDomain;
        this.context = context;
        this.variables = variables;
        this.expression = expression;
    }

    @Override
    public void prepare() throws InvocationTargetException {
        OCL ocl = this.delegateDomain.getOCL();
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext(this.context);
        if (this.variables != null) {
            Environment environment = helper.getEnvironment();
            OCLFactory oclFactory = environment.getOCLFactory();
            UMLReflection umlReflection = environment.getUMLReflection();
            for (Map.Entry<String, EClassifier> entry : this.variables.entrySet()) {
                Variable variable = oclFactory.createVariable();
                variable.setName(entry.getKey());
                variable.setType((EClassifier)umlReflection.getOCLType(entry.getValue()));
                environment.addElement(entry.getKey(), variable, true);
            }
        }
        try {
            this.query = helper.createQuery(this.expression);
        }
        catch (ParserException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public Object execute(Object target, Map<String, ?> arguments) throws InvocationTargetException {
        String key;
        EClassifier contextType;
        if (this.query == null) {
            this.prepare();
        }
        OCL ocl = this.delegateDomain.getOCL();
        Query oclQuery = ocl.createQuery((org.eclipse.ocl.expressions.OCLExpression)this.query);
        EvaluationEnvironment evalEnv = oclQuery.getEvaluationEnvironment();
        Environment env = ocl.getEnvironment();
        if (!TypeUtil.compatibleTypeMatch(env, contextType = (EClassifier)evalEnv.getType(target), this.context)) {
            String string = OCLMessages.bind(OCLMessages.WrongContextClassifier_ERROR_, contextType.getName(), this.context.getName());
            throw new InvocationTargetException(new ParserException(string));
        }
        if (this.variables != null) {
            for (Map.Entry<String, EClassifier> entry : this.variables.entrySet()) {
                key = entry.getKey();
                if (arguments != null && arguments.containsKey(key)) continue;
                String message = OCLMessages.bind(OCLMessages.BadArg_ERROR_, key);
                throw new InvocationTargetException(new ParserException(message));
            }
        }
        if (arguments != null) {
            for (Map.Entry<String, EClassifier> entry : arguments.entrySet()) {
                EClassifier variableType;
                key = entry.getKey();
                EClassifier eClassifier = variableType = this.variables != null ? this.variables.get(key) : null;
                if (variableType == null) {
                    String message = OCLMessages.bind(OCLMessages.ExtraArg_ERROR_, key);
                    throw new InvocationTargetException(new LookupException(message));
                }
                EClassifier newValue = entry.getValue();
                EClassifier valueType = (EClassifier)evalEnv.getType(newValue);
                if (!TypeUtil.compatibleTypeMatch(env, valueType, variableType)) {
                    String message = OCLMessages.bind(OCLMessages.TypeConformanceInit_ERROR_, key);
                    throw new InvocationTargetException(new ParserException(message));
                }
                evalEnv.replace(key, newValue);
            }
        }
        return oclQuery.evaluate(target);
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":query> " + this.expression;
    }
}

