/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.internal.OCLEcorePlugin;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.PredefinedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCLStandardLibraryImpl
implements OCLStandardLibrary<EClassifier> {
    private static final String NS_URI = "http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore";
    private static EClassifier OCL_ANY;
    private static EClassifier OCL_ELEMENT;
    private static EClassifier OCL_BOOLEAN;
    private static EClassifier OCL_INTEGER;
    private static EClassifier OCL_UNLIMITED_NATURAL;
    private static EClassifier OCL_REAL;
    private static EClassifier OCL_STRING;
    private static EClassifier OCL_VOID;
    private static EClassifier OCL_MESSAGE;
    private static EClassifier OCL_TYPE;
    private static EClassifier OCL_INVALID;
    private static EClassifier OCL_T;
    private static EClassifier OCL_T2;
    private static EClassifier OCL_SET;
    private static EClassifier OCL_ORDERED_SET;
    private static EClassifier OCL_BAG;
    private static EClassifier OCL_SEQUENCE;
    private static EClassifier OCL_COLLECTION;
    private static EClassifier STATE;
    private static EClassifier OCL_EXPRESSION;
    public static final OCLStandardLibraryImpl INSTANCE;
    public static EPackage stdlibPackage;
    public static final EObject INVALID;

    static {
        INSTANCE = new OCLStandardLibraryImpl();
        stdlibPackage = OCLStandardLibraryImpl.init();
        INVALID = stdlibPackage.getEFactoryInstance().create((EClass)stdlibPackage.getEClassifier("OclInvalid_Class"));
    }

    private OCLStandardLibraryImpl() {
    }

    @Override
    public EClassifier getBoolean() {
        return OCL_BOOLEAN;
    }

    @Override
    public EClassifier getInteger() {
        return OCL_INTEGER;
    }

    @Override
    public EClassifier getUnlimitedNatural() {
        return OCL_UNLIMITED_NATURAL;
    }

    @Override
    public EClassifier getOclInvalid() {
        return OCL_INVALID;
    }

    @Override
    public EClassifier getReal() {
        return OCL_REAL;
    }

    @Override
    public EClassifier getString() {
        return OCL_STRING;
    }

    @Override
    public EClassifier getOclAny() {
        return OCL_ANY;
    }

    @Override
    public EClassifier getOclElement() {
        return OCL_ELEMENT;
    }

    @Override
    public Object getInvalid() {
        return INVALID;
    }

    @Override
    public EClassifier getState() {
        return STATE;
    }

    @Override
    public EClassifier getOclMessage() {
        return OCL_MESSAGE;
    }

    @Override
    public EClassifier getOclType() {
        return OCL_TYPE;
    }

    @Override
    public EClassifier getOclVoid() {
        return OCL_VOID;
    }

    @Override
    public EClassifier getT() {
        return OCL_T;
    }

    @Override
    public EClassifier getT2() {
        return OCL_T2;
    }

    @Override
    public EClassifier getSet() {
        return OCL_SET;
    }

    @Override
    public EClassifier getOrderedSet() {
        return OCL_ORDERED_SET;
    }

    @Override
    public EClassifier getBag() {
        return OCL_BAG;
    }

    @Override
    public EClassifier getSequence() {
        return OCL_SEQUENCE;
    }

    @Override
    public EClassifier getCollection() {
        return OCL_COLLECTION;
    }

    @Override
    public EClassifier getOclExpression() {
        return OCL_EXPRESSION;
    }

    private static EPackage init() {
        EPackage ePackage;
        block6: {
            if (stdlibPackage != null) {
                return stdlibPackage;
            }
            ResourceSetImpl rset = new ResourceSetImpl();
            OCL.initialize(rset);
            Resource res = null;
            try {
                Resource load = rset.getResource(URI.createURI(NS_URI), true);
                res = OCLEcorePlugin.getEcoreResourceFactory().createResource(load.getURI());
                res.getContents().addAll(load.getContents());
                stdlibPackage = (EPackage)res.getContents().get(0);
                OCL_ANY = stdlibPackage.getEClassifier("OclAny");
                OCL_ELEMENT = stdlibPackage.getEClassifier("OclElement");
                OCL_BOOLEAN = stdlibPackage.getEClassifier("Boolean");
                OCL_INTEGER = stdlibPackage.getEClassifier("Integer");
                OCL_UNLIMITED_NATURAL = stdlibPackage.getEClassifier("UnlimitedNatural");
                OCL_REAL = stdlibPackage.getEClassifier("Real");
                OCL_STRING = stdlibPackage.getEClassifier("String");
                OCL_VOID = stdlibPackage.getEClassifier("OclVoid");
                OCL_MESSAGE = stdlibPackage.getEClassifier("OclMessage");
                OCL_INVALID = stdlibPackage.getEClassifier("OclInvalid");
                OCL_T = stdlibPackage.getEClassifier("T");
                OCL_T2 = stdlibPackage.getEClassifier("T2");
                OCL_TYPE = (EClassifier)EcoreUtil.getObjectByType(stdlibPackage.getEClassifiers(), EcorePackage.Literals.TYPE_TYPE);
                OCL_SET = (EClassifier)EcoreUtil.getObjectByType(stdlibPackage.getEClassifiers(), EcorePackage.Literals.SET_TYPE);
                OCL_ORDERED_SET = (EClassifier)EcoreUtil.getObjectByType(stdlibPackage.getEClassifiers(), EcorePackage.Literals.ORDERED_SET_TYPE);
                OCL_BAG = (EClassifier)EcoreUtil.getObjectByType(stdlibPackage.getEClassifiers(), EcorePackage.Literals.BAG_TYPE);
                OCL_SEQUENCE = (EClassifier)EcoreUtil.getObjectByType(stdlibPackage.getEClassifiers(), EcorePackage.Literals.SEQUENCE_TYPE);
                OCL_COLLECTION = stdlibPackage.getEClassifier("Collection(T)");
                STATE = stdlibPackage.getEClassifier("State");
                OCL_EXPRESSION = stdlibPackage.getEClassifier("OclExpression");
                EPackage.Registry.INSTANCE.put(stdlibPackage.getNsURI(), stdlibPackage);
                ePackage = stdlibPackage;
                if (res == null) break block6;
            }
            catch (Exception e) {
                EPackage ePackage2;
                block7: {
                    try {
                        ePackage2 = OCLStandardLibraryImpl.build();
                        if (res == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (res != null) {
                            rset.getResources().remove(res);
                        }
                        throw throwable;
                    }
                    rset.getResources().remove(res);
                }
                return ePackage2;
            }
            rset.getResources().remove(res);
        }
        return ePackage;
    }

    private static EPackage build() {
        if (stdlibPackage != null) {
            return stdlibPackage;
        }
        Environment old = Environment.Registry.INSTANCE.getEnvironmentFor(EcorePackage.Literals.ANY_TYPE);
        stdlibPackage = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEPackage();
        stdlibPackage.setName("oclstdlib");
        stdlibPackage.setNsPrefix("oclstdlib");
        stdlibPackage.setNsURI(NS_URI);
        Resource.Factory factory = OCLEcorePlugin.getEcoreResourceFactory();
        Resource res = factory.createResource(URI.createURI(stdlibPackage.getNsURI()));
        res.getContents().add(stdlibPackage);
        Environment.Registry.INSTANCE.deregisterEnvironment(old);
        EcoreEnvironment env = (EcoreEnvironment)EcoreEnvironmentFactory.INSTANCE.loadEnvironment(res);
        Environment.Registry.INSTANCE.registerEnvironment(env);
        OCL_ANY = EcoreFactory.eINSTANCE.createAnyType();
        OCL_ELEMENT = EcoreFactory.eINSTANCE.createElementType();
        OCL_BOOLEAN = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_BOOLEAN.setName("Boolean");
        OCL_INTEGER = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_INTEGER.setName("Integer");
        OCL_UNLIMITED_NATURAL = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_UNLIMITED_NATURAL.setName("UnlimitedNatural");
        OCL_REAL = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_REAL.setName("Real");
        OCL_STRING = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_STRING.setName("String");
        OCL_VOID = EcoreFactory.eINSTANCE.createVoidType();
        OCL_MESSAGE = EcoreFactory.eINSTANCE.createMessageType();
        OCL_INVALID = EcoreFactory.eINSTANCE.createInvalidType();
        OCL_T = EcoreFactory.eINSTANCE.createAnyType();
        OCL_T.setName("T");
        OCL_T2 = EcoreFactory.eINSTANCE.createAnyType();
        OCL_T2.setName("T2");
        OCL_TYPE = (EClassifier)((Object)OCLFactoryImpl.INSTANCE.createTypeType(OCL_T));
        OCL_SET = (EClassifier)((Object)OCLFactoryImpl.INSTANCE.createSetType(OCL_T));
        OCL_ORDERED_SET = (EClassifier)((Object)OCLFactoryImpl.INSTANCE.createOrderedSetType(OCL_T));
        OCL_BAG = (EClassifier)((Object)OCLFactoryImpl.INSTANCE.createBagType(OCL_T));
        OCL_SEQUENCE = (EClassifier)((Object)OCLFactoryImpl.INSTANCE.createSequenceType(OCL_T));
        OCL_COLLECTION = (EClassifier)((Object)OCLFactoryImpl.INSTANCE.createCollectionType(OCL_T));
        STATE = EcoreFactory.eINSTANCE.createElementType();
        STATE.setName("State");
        OCL_EXPRESSION = EcoreFactory.eINSTANCE.createElementType();
        OCL_EXPRESSION.setName("OclExpression");
        OCL_BOOLEAN.setInstanceClass(Boolean.class);
        OCL_STRING.setInstanceClass(String.class);
        OCL_INTEGER.setInstanceClass(Integer.class);
        OCL_UNLIMITED_NATURAL.setInstanceClass(Integer.class);
        OCL_REAL.setInstanceClass(Double.class);
        OCLStandardLibraryImpl.register(OCL_ANY).getEOperations().addAll(OCLStandardLibraryUtil.createAnyTypeOperations(env));
        OCLStandardLibraryImpl.register(OCL_VOID).getEOperations().addAll(OCLStandardLibraryUtil.createAnyTypeOperations(env));
        OCLStandardLibraryImpl.register(OCL_INVALID).getEOperations().addAll(OCLStandardLibraryUtil.createAnyTypeOperations(env));
        OCLStandardLibraryImpl.register(OCL_BOOLEAN).getEOperations().addAll(OCLStandardLibraryUtil.createBooleanOperations(env));
        OCLStandardLibraryImpl.register(OCL_INTEGER).getEOperations().addAll(OCLStandardLibraryUtil.createIntegerOperations(env));
        OCLStandardLibraryImpl.register(OCL_UNLIMITED_NATURAL).getEOperations().addAll(OCLStandardLibraryUtil.createUnlimitedNaturalOperations(env));
        OCLStandardLibraryImpl.register(OCL_REAL).getEOperations().addAll(OCLStandardLibraryUtil.createRealOperations(env));
        OCLStandardLibraryImpl.register(OCL_STRING).getEOperations().addAll(OCLStandardLibraryUtil.createStringOperations(env));
        OCLStandardLibraryImpl.register(OCL_TYPE).getEOperations().addAll(OCLStandardLibraryUtil.createTypeTypeOperations(env));
        OCLStandardLibraryImpl.register(OCL_MESSAGE).getEOperations().addAll(OCLStandardLibraryUtil.createMessageTypeOperations(env));
        OCLStandardLibraryImpl.register(OCL_ELEMENT);
        OCLStandardLibraryImpl.register(STATE);
        OCLStandardLibraryImpl.register(OCL_EXPRESSION);
        EList<EOperation> operations = OCLStandardLibraryImpl.register(OCL_COLLECTION).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createCollectionOperations(env));
        List<EOperation> iterators = OCLStandardLibraryUtil.createCollectionIterators(env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_SET).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createSetOperations(env));
        iterators = OCLStandardLibraryUtil.createSetIterators(env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_ORDERED_SET).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createOrderedSetOperations(env));
        iterators = OCLStandardLibraryUtil.createOrderedSetIterators(env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_BAG).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createBagOperations(env));
        iterators = OCLStandardLibraryUtil.createBagIterators(env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_SEQUENCE).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createSequenceOperations(env));
        iterators = OCLStandardLibraryUtil.createSequenceIterators(env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        OCLStandardLibraryImpl.register(OCL_T);
        OCLStandardLibraryImpl.register(OCL_T2);
        EPackage.Registry.INSTANCE.put(stdlibPackage.getNsURI(), stdlibPackage);
        Environment.Registry.INSTANCE.registerEnvironment(old);
        return stdlibPackage;
    }

    private static EClass register(EClassifier stdType) {
        EClass result = stdType instanceof EClass ? (EClass)stdType : null;
        stdlibPackage.getEClassifiers().add(stdType);
        if (stdType instanceof PredefinedType && !(stdType instanceof EClass)) {
            result = OCLStandardLibraryImpl.createShadowClass(stdType);
            stdlibPackage.getEClassifiers().add(result);
        }
        return result;
    }

    public static EClassifier getOwner(EOperation operation) {
        EClassifier shadowed;
        EClass ownerClass;
        EClassifier result = ownerClass = operation.getEContainingClass();
        if (ownerClass != null && (shadowed = OCLStandardLibraryImpl.getRealClassifier(ownerClass)) != null) {
            result = shadowed;
        }
        return result;
    }

    public static EClassifier getOwner(EStructuralFeature property) {
        EClassifier shadowed;
        EClass ownerClass;
        EClassifier result = ownerClass = property.getEContainingClass();
        if (ownerClass != null && (shadowed = OCLStandardLibraryImpl.getRealClassifier(ownerClass)) != null) {
            result = shadowed;
        }
        return result;
    }

    public static EClass createShadowClass(EClassifier classifier) {
        EClass result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEClass();
        result.setName(String.valueOf(classifier.getName()) + "_Class");
        EAnnotation ann = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
        ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
        ann.getReferences().add(classifier);
        result.getEAnnotations().add(ann);
        return result;
    }

    public static EClass findShadowClass(EClassifier classifier, EPackage pkg) {
        for (EClassifier next : pkg.getEClassifiers()) {
            EClass eclass;
            EAnnotation ann;
            if (!(next instanceof EClass) || (ann = (eclass = (EClass)next).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL")) == null || !ann.getReferences().contains(classifier)) continue;
            return eclass;
        }
        return null;
    }

    public static EClassifier getRealClassifier(EClass shadowClass) {
        EClassifier result = null;
        EAnnotation ann = shadowClass.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getReferences().isEmpty()) {
            result = (EClassifier)ann.getReferences().get(0);
        }
        return result;
    }

    public static EList<EOperation> getExistingOperations(EClassifier type) {
        EList<EOperation> result = null;
        if (type instanceof EClass) {
            result = ((EClass)type).getEOperations();
        } else {
            EClass shadow;
            EPackage pkg = type.getEPackage();
            if (pkg != null && (shadow = OCLStandardLibraryImpl.findShadowClass(type, pkg)) != null) {
                result = shadow.getEOperations();
            }
        }
        return result == null ? ECollections.emptyEList() : result;
    }

    public static void stereotypeAsIterator(Collection<EOperation> operations) {
        for (EOperation oper : operations) {
            EAnnotation ann = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
            ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
            ann.getDetails().put("keywords", "iterator");
            oper.getEAnnotations().add(ann);
        }
    }

    public static EList<EOperation> selectIterators(Collection<EOperation> operations) {
        BasicEList.FastCompare<EOperation> result = new BasicEList.FastCompare<EOperation>();
        for (EOperation oper : operations) {
            EAnnotation ann = oper.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null || !"iterator".equals(ann.getDetails().get("keywords"))) continue;
            result.add(oper);
        }
        return result;
    }
}

