/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLReflectionImpl
implements UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> {
    public static final UMLReflectionImpl INSTANCE = new UMLReflectionImpl();

    protected UMLReflectionImpl() {
    }

    @Override
    public String getDescription(Object namedElement) {
        if (namedElement instanceof ETypedElement) {
            EClassifier type = ((ETypedElement)namedElement).getEType();
            return type == null ? OCLStandardLibraryImpl.INSTANCE.getOclVoid().getName() : type.getName();
        }
        if (namedElement instanceof EEnumLiteral) {
            return ((EEnumLiteral)namedElement).getEEnum().getName();
        }
        if (namedElement == null) {
            return null;
        }
        return ((EObject)namedElement).eClass().getName();
    }

    @Override
    public String getName(Object namedElement) {
        return namedElement instanceof ENamedElement ? ((ENamedElement)namedElement).getName() : null;
    }

    @Override
    public String getQualifiedName(Object namedElement) {
        return namedElement instanceof ENamedElement ? this.getQualifiedName((ENamedElement)namedElement) : null;
    }

    private String getQualifiedName(ENamedElement namedElement) {
        StringBuffer result = new StringBuffer();
        this.getQualifiedName(result, namedElement);
        return result.toString();
    }

    private void getQualifiedName(StringBuffer buf, ENamedElement namedElement) {
        EObject container = namedElement.eContainer();
        if (container instanceof ENamedElement) {
            this.getQualifiedName(buf, (ENamedElement)container);
            buf.append("::");
        }
        buf.append(namedElement.getName());
    }

    @Override
    public EClassifier getOCLType(Object metaElement) {
        EClassifier result = null;
        if (metaElement == EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND) {
            return OCLStandardLibraryImpl.INSTANCE.getUnlimitedNatural();
        }
        if (metaElement instanceof ETypedElement) {
            ETypedElement typedElement = (ETypedElement)metaElement;
            result = typedElement.getEType();
            result = UMLReflectionImpl.isMany(typedElement) ? this.getOCLCollectionType(result, typedElement.isOrdered(), typedElement.isUnique()) : this.getOCLType(result);
        } else if (metaElement instanceof EClassifier) {
            result = this.getOCLType((EClassifier)metaElement);
        }
        return result;
    }

    @Override
    public Collection<? extends EClassifier> getAllSupertypes(EClassifier classifier) {
        if (classifier instanceof EClass) {
            return ((EClass)classifier).getEAllSuperTypes();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isMany(Object metaElement) {
        return metaElement instanceof ETypedElement && UMLReflectionImpl.isMany((ETypedElement)metaElement);
    }

    @Override
    public EClassifier asOCLType(EClassifier modelType) {
        return this.getOCLType(modelType);
    }

    @Override
    public EPackage getNestingPackage(EPackage pkg) {
        return pkg.getESuperPackage();
    }

    @Override
    public List<EPackage> getNestedPackages(EPackage pkg) {
        return pkg.getESubpackages();
    }

    @Override
    public EPackage getPackage(EClassifier classifier) {
        return classifier.getEPackage();
    }

    @Override
    public List<EClassifier> getClassifiers(EPackage pkg) {
        return pkg.getEClassifiers();
    }

    @Override
    public EClassifier getOwningClassifier(Object feature) {
        if (feature instanceof EOperation) {
            EOperation operation = (EOperation)feature;
            return OCLStandardLibraryImpl.getOwner(operation);
        }
        if (feature instanceof EStructuralFeature) {
            return OCLStandardLibraryImpl.getOwner((EStructuralFeature)feature);
        }
        return null;
    }

    @Override
    public List<EParameter> getParameters(EOperation operation) {
        return operation.getEParameters();
    }

    @Override
    public EOperation createOperation(String name, EClassifier resultType, List<String> paramNames, List<EClassifier> paramTypes) {
        EOperation result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(resultType);
        int i = 0;
        for (String pname : paramNames) {
            EParameter param = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEParameter();
            param.setName(pname);
            param.setEType(paramTypes.get(i++));
            result.getEParameters().add(param);
        }
        return result;
    }

    @Override
    public List<EOperation> getOperations(EClassifier classifier) {
        List<EOperation> result = classifier instanceof EClass ? ((EClass)classifier).getEAllOperations() : Collections.emptyList();
        return result;
    }

    @Override
    public EStructuralFeature createProperty(String name, EClassifier resultType) {
        EStructuralFeature result = resultType instanceof EClass ? org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEReference() : org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        result.setEType(resultType);
        return result;
    }

    @Override
    public List<EStructuralFeature> getAttributes(EClassifier classifier) {
        List<EStructuralFeature> result = classifier instanceof EClass ? ((EClass)classifier).getEAllStructuralFeatures() : Collections.emptyList();
        return result;
    }

    @Override
    public List<EClassifier> getSignals(EClassifier owner) {
        return Collections.emptyList();
    }

    @Override
    public boolean isQuery(EOperation operation) {
        return true;
    }

    @Override
    public boolean isStatic(Object feature) {
        return false;
    }

    @Override
    public boolean isAssociationClass(EClassifier eclass) {
        return false;
    }

    @Override
    public EClass getAssociationClass(EStructuralFeature reference) {
        return null;
    }

    @Override
    public List<EStructuralFeature> getMemberEnds(EClassifier associationClass) {
        return Collections.emptyList();
    }

    @Override
    public boolean isOperation(Object metaElement) {
        return metaElement instanceof EOperation;
    }

    @Override
    public boolean isPackage(Object metaElement) {
        return metaElement instanceof EPackage;
    }

    @Override
    public boolean isProperty(Object metaElement) {
        return metaElement instanceof EStructuralFeature;
    }

    @Override
    public boolean isClassifier(Object metaElement) {
        return metaElement instanceof EClassifier;
    }

    @Override
    public boolean isClass(Object metaElement) {
        return metaElement instanceof EClass;
    }

    @Override
    public boolean isConstraint(Object metaElement) {
        return metaElement instanceof Constraint;
    }

    @Override
    public boolean isDataType(Object metaElement) {
        return metaElement instanceof EDataType;
    }

    @Override
    public boolean isEnumeration(EClassifier type) {
        return type instanceof EEnum;
    }

    @Override
    public EClassifier getEnumeration(EEnumLiteral enumerationLiteral) {
        return enumerationLiteral.getEEnum();
    }

    @Override
    public List<EEnumLiteral> getEnumerationLiterals(EClassifier enumerationType) {
        return ((EEnum)enumerationType).getELiterals();
    }

    @Override
    public EEnumLiteral getEnumerationLiteral(EClassifier enumerationType, String literalName) {
        return ((EEnum)enumerationType).getEEnumLiteral(literalName);
    }

    @Override
    public boolean isStereotype(EClassifier type) {
        return false;
    }

    @Override
    public Object getStereotypeApplication(Object baseElement, EClassifier stereotype) {
        return null;
    }

    @Override
    public boolean isComparable(EClassifier type) {
        Class<?> javaClass = type.getInstanceClass();
        return javaClass != null && Comparable.class.isAssignableFrom(javaClass);
    }

    @Override
    public CallOperationAction createCallOperationAction(EOperation operation) {
        CallOperationAction result = EcoreFactory.eINSTANCE.createCallOperationAction();
        result.setOperation(operation);
        return result;
    }

    @Override
    public EOperation getOperation(CallOperationAction callOperationAction) {
        return callOperationAction.getOperation();
    }

    @Override
    public SendSignalAction createSendSignalAction(EClassifier signal) {
        SendSignalAction result = EcoreFactory.eINSTANCE.createSendSignalAction();
        result.setSignal((EClass)signal);
        return result;
    }

    @Override
    public EClass getSignal(SendSignalAction sendSignalAction) {
        return sendSignalAction.getSignal();
    }

    @Override
    public Constraint createConstraint() {
        return EcoreFactory.eINSTANCE.createConstraint();
    }

    @Override
    public String getStereotype(Constraint constraint) {
        return constraint.getStereotype();
    }

    @Override
    public void setStereotype(Constraint constraint, String stereotype) {
        constraint.setStereotype(stereotype);
    }

    @Override
    public String getConstraintName(Constraint constraint) {
        return constraint.getName();
    }

    @Override
    public void setConstraintName(Constraint constraint, String name) {
        constraint.setName(name);
    }

    @Override
    public ExpressionInOCL<EClassifier, EParameter> createExpressionInOCL() {
        return EcoreFactory.eINSTANCE.createExpressionInOCL();
    }

    @Override
    public ExpressionInOCL<EClassifier, EParameter> getSpecification(Constraint constraint) {
        return constraint.getSpecification();
    }

    @Override
    public void setSpecification(Constraint constraint, ExpressionInOCL<EClassifier, EParameter> specification) {
        constraint.setSpecification(specification);
    }

    @Override
    public Constraint getConstraint(ExpressionInOCL<EClassifier, EParameter> specification) {
        EObject container = specification.eContainer();
        if (container instanceof Constraint) {
            return (Constraint)container;
        }
        return null;
    }

    @Override
    public List<EModelElement> getConstrainedElements(Constraint constraint) {
        return constraint.getConstrainedElements();
    }

    @Override
    public void addConstrainedElement(Constraint constraint, EObject constrainedElement) {
        constraint.getConstrainedElements().add((EModelElement)constrainedElement);
    }

    @Override
    public List<EStructuralFeature> getQualifiers(EStructuralFeature property) {
        return ECollections.emptyEList();
    }

    @Override
    public EClassifier getCommonSuperType(EClassifier type1, EClassifier type2) {
        if (ObjectUtil.equal(type1, type2)) {
            return type2;
        }
        if (type1 instanceof EClass && type2 instanceof EClass) {
            EClass eClass1 = (EClass)type1;
            EClass eClass2 = (EClass)type2;
            if (eClass1.isSuperTypeOf(eClass2)) {
                return eClass1;
            }
            if (eClass2.isSuperTypeOf(eClass1)) {
                return eClass2;
            }
            ArrayList<EClass> allSuperAndSelf1 = new ArrayList<EClass>(eClass1.getEAllSuperTypes());
            allSuperAndSelf1.add(eClass1);
            ArrayList<EClass> allSuperAndSelf2 = new ArrayList<EClass>(eClass2.getEAllSuperTypes());
            allSuperAndSelf2.add(eClass2);
            allSuperAndSelf1.retainAll(allSuperAndSelf2);
            if (!allSuperAndSelf1.isEmpty()) {
                return (EClassifier)allSuperAndSelf1.get(allSuperAndSelf1.size() - 1);
            }
        }
        return null;
    }

    @Override
    public int getRelationship(EClassifier type1, EClassifier type2) {
        if (ObjectUtil.equal(type1, type2)) {
            return 1;
        }
        if (type1 instanceof EClass && type2 instanceof EClass) {
            EClass class1 = (EClass)type1;
            EClass class2 = (EClass)type2;
            if (class1.isSuperTypeOf(class2)) {
                return 4;
            }
            if (class2.isSuperTypeOf(class1)) {
                return 2;
            }
        }
        return 8;
    }

    private EClassifier getOCLTypeFor(EDataType dataType) {
        if (dataType instanceof EEnum) {
            return dataType;
        }
        if (dataType instanceof CollectionType) {
            return dataType;
        }
        if (dataType instanceof PrimitiveType) {
            return dataType;
        }
        Class<?> instanceClass = dataType.getInstanceClass();
        if (instanceClass != null) {
            if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                return OCLStandardLibraryImpl.INSTANCE.getBoolean();
            }
            if (instanceClass == Double.class || instanceClass == BigDecimal.class || instanceClass == Double.TYPE || instanceClass == Float.class || instanceClass == Float.TYPE) {
                return OCLStandardLibraryImpl.INSTANCE.getReal();
            }
            if (instanceClass == String.class) {
                return OCLStandardLibraryImpl.INSTANCE.getString();
            }
            if (instanceClass == Integer.class || instanceClass == Integer.TYPE || instanceClass == Long.class || instanceClass == Long.TYPE || instanceClass == Short.class || instanceClass == Short.TYPE || instanceClass == BigInteger.class) {
                return OCLStandardLibraryImpl.INSTANCE.getInteger();
            }
            if (List.class.isAssignableFrom(instanceClass)) {
                return OCLStandardLibraryImpl.INSTANCE.getSequence();
            }
            if (Set.class.isAssignableFrom(instanceClass)) {
                return OCLStandardLibraryImpl.INSTANCE.getSet();
            }
            if (Collection.class.isAssignableFrom(instanceClass)) {
                return OCLStandardLibraryImpl.INSTANCE.getCollection();
            }
            if (instanceClass == Object.class) {
                return OCLStandardLibraryImpl.INSTANCE.getOclAny();
            }
        }
        return dataType;
    }

    EClassifier getOCLType(EClassifier type) {
        EClassifier resultType = type;
        if (resultType instanceof EDataType) {
            resultType = this.getOCLTypeFor((EDataType)resultType);
        }
        return resultType;
    }

    public EClassifier getOCLCollectionType(EClassifier type, boolean isOrdered, boolean isUnique) {
        EClassifier resultType = type;
        if (resultType instanceof EDataType) {
            resultType = this.getOCLTypeFor((EDataType)resultType);
        }
        OCLFactory oclFactory = OCLFactoryImpl.INSTANCE;
        resultType = isOrdered ? (isUnique ? (EClassifier)((Object)oclFactory.createOrderedSetType(resultType)) : (EClassifier)((Object)oclFactory.createSequenceType(resultType))) : (isUnique ? (EClassifier)((Object)oclFactory.createSetType(resultType)) : (EClassifier)((Object)oclFactory.createBagType(resultType)));
        return resultType;
    }

    static boolean isMany(ETypedElement typedElement) {
        if (typedElement instanceof EStructuralFeature) {
            int upperBound = typedElement.getUpperBound();
            return upperBound > 1 || upperBound < 0;
        }
        return typedElement.isMany();
    }

    public static boolean isAncestor(EObject ancestor, EObject descendent) {
        while (descendent != null) {
            if (descendent == ancestor) {
                return true;
            }
            descendent = descendent.eContainer();
        }
        return false;
    }

    @Override
    public void setName(TypedElement<EClassifier> element, String name) {
        element.setName(name);
    }

    @Override
    public void setType(TypedElement<EClassifier> element, EClassifier type) {
        element.setType(type);
    }

    @Override
    public boolean setIsStatic(Object feature, boolean isStatic) {
        return false;
    }
}

