/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.parser;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EnvironmentWithHiddenOpposites;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.utilities.OCLFactoryWithHiddenOpposite;
import org.eclipse.ocl.expressions.NavigationCallExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.parser.AbstractOCLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLAnalyzer
extends org.eclipse.ocl.parser.OCLAnalyzer<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> {
    public OCLAnalyzer(AbstractOCLParser parser) {
        super(parser);
    }

    public OCLAnalyzer(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> rootEnvironment, String input) {
        super(rootEnvironment, input);
    }

    @Override
    protected NavigationCallExp<EClassifier, EStructuralFeature> simpleNavigationName(SimpleNameCS simpleNameCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, OCLExpression<EClassifier> source, EClassifier owner, String simpleName) {
        if (simpleName == null) {
            return null;
        }
        NavigationCallExp<EClassifier, EStructuralFeature> result = null;
        EStructuralFeature property = this.lookupProperty(simpleNameCS, env, owner, simpleName);
        if (property != null) {
            result = this.uml.getOwningClassifier(property) == null && property instanceof EReference ? this.createOppositePropertyCallExp(simpleNameCS, (EnvironmentWithHiddenOpposites)env, source, owner, simpleName, ((EReference)property).getEOpposite()) : this.createPropertyCallExp(simpleNameCS, env, source, owner, simpleName, property);
        }
        return result;
    }

    private PropertyCallExp<EClassifier, EStructuralFeature> createPropertyCallExp(SimpleNameCS simpleNameCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, OCLExpression<EClassifier> source, EClassifier owner, String simpleName, EStructuralFeature property) {
        this.TRACE("variableExpCS", "Property: " + simpleName);
        PropertyCallExp<EClassifier, EStructuralFeature> result = this.oclFactory.createPropertyCallExp();
        this.initASTMapping(env, result, simpleNameCS, null);
        result.setReferredProperty(property);
        result.setType(this.getPropertyType(simpleNameCS, env, owner, property));
        if (source != null) {
            result.setSource(source);
        } else {
            Variable<EClassifier, EParameter> implicitSource = env.lookupImplicitSourceForProperty(simpleName);
            VariableExp<EClassifier, EParameter> src = this.createVariableExp(env, simpleNameCS, implicitSource);
            result.setSource(src);
        }
        this.initPropertyPositions(result, simpleNameCS);
        return result;
    }

    private OppositePropertyCallExp createOppositePropertyCallExp(SimpleNameCS simpleNameCS, EnvironmentWithHiddenOpposites env, OCLExpression<EClassifier> source, EClassifier owner, String simpleName, EReference property) {
        this.TRACE("variableExpCS", "Opposite Property: " + simpleName);
        OppositePropertyCallExp result = ((OCLFactoryWithHiddenOpposite)((Object)this.oclFactory)).createOppositePropertyCallExp();
        this.initASTMapping(env, result, simpleNameCS, null);
        result.setReferredOppositeProperty(property);
        EClassifier propertyType = env.getOppositePropertyType(owner, property);
        this.initASTMapping(env, propertyType, simpleNameCS, property);
        result.setType(propertyType);
        if (source != null) {
            result.setSource(source);
        } else {
            Variable<EClassifier, EParameter> implicitSource = env.lookupImplicitSourceForOppositeProperty(simpleName);
            VariableExp<EClassifier, EParameter> src = this.createVariableExp(env, simpleNameCS, implicitSource);
            result.setSource(src);
        }
        this.initPropertyPositions(result, simpleNameCS);
        return result;
    }

    protected EReference lookupOppositeProperty(CSTNode cstNode, EnvironmentWithHiddenOpposites env, EClassifier owner, String name) {
        try {
            EReference property = env.lookupOppositeProperty(owner, name);
            if (cstNode != null) {
                cstNode.setAst(property);
            }
            return property;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return e.getAmbiguousMatches().isEmpty() ? null : (EReference)e.getAmbiguousMatches().get(0);
        }
    }
}

