/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfExpOperations
extends OCLExpressionOperations {
    protected IfExpOperations() {
    }

    public static <C> boolean checkBooleanCondition(IfExp<C> ifExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(ifExp, context);
        if (env != null) {
            Object type;
            UMLReflection uml = env.getUMLReflection();
            OCLExpression<C> cond = ifExp.getCondition();
            if (!(cond == null || (type = cond.getType()) != null && uml.isDataType(type) && "Boolean".equals(uml.getName(type)))) {
                result = false;
                message = OCLMessages.bind(OCLMessages.NonBooleanIfExp_ERROR_, cond.toString());
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 10, message, new Object[]{ifExp}));
        }
        return result;
    }

    public static <C> boolean checkIfType(IfExp<C> ifExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(ifExp, context);
        if (env != null) {
            OCLExpression<C> thenExp = ifExp.getThenExpression();
            OCLExpression<C> elseExp = ifExp.getElseExpression();
            Object type = ifExp.getType();
            if (type != null && thenExp != null && elseExp != null) {
                Object thenelsetype;
                Object thenType = thenExp.getType();
                Object elseType = elseExp.getType();
                if (!(thenType == null || elseType == null || (thenelsetype = TypeUtil.commonSuperType(null, env, thenType, elseType)) != null && TypeUtil.exactTypeMatch(env, type, thenelsetype))) {
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceIfExp_ERROR_, ifExp.toString());
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 11, message, new Object[]{ifExp}));
        }
        return result;
    }
}

