/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.operations.LoopExpOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorExpOperations
extends LoopExpOperations {
    protected IteratorExpOperations() {
    }

    public static <C, PM> boolean checkBooleanType(IteratorExp<C, PM> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(iteratorExp, context);
        Object type = iteratorExp.getType();
        if (env != null) {
            String name = iteratorExp.getName();
            int opcode = OCLStandardLibraryUtil.getOperationCode(name);
            switch (opcode) {
                case 201: 
                case 202: 
                case 203: {
                    if (type instanceof PrimitiveType && "Boolean".equals(env.getUMLReflection().getName(type))) break;
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceIteratorResult_ERROR_, iteratorExp.toString());
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 21, message, new Object[]{iteratorExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkCollectType(IteratorExp<C, PM> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(iteratorExp, context);
        Object type = iteratorExp.getType();
        OCLExpression source = iteratorExp.getSource();
        if (env != null && source != null && source.getType() != null) {
            String name = iteratorExp.getName();
            int opcode = OCLStandardLibraryUtil.getOperationCode(name);
            switch (opcode) {
                case 206: {
                    if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                        if (type instanceof SequenceType) break;
                        result = false;
                        message = OCLMessages.bind(OCLMessages.TypeConformanceCollectSequence_ERROR_, iteratorExp.toString());
                        break;
                    }
                    if (type instanceof BagType) break;
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceCollectBag_ERROR_, iteratorExp.toString());
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 22, message, new Object[]{iteratorExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkSelectRejectType(IteratorExp<C, PM> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(iteratorExp, context);
        Object type = iteratorExp.getType();
        OCLExpression source = iteratorExp.getSource();
        if (env != null && source != null && source.getType() != null) {
            String name = iteratorExp.getName();
            int opcode = OCLStandardLibraryUtil.getOperationCode(name);
            switch (opcode) {
                case 209: 
                case 210: {
                    if (TypeUtil.exactTypeMatch(env, type, source.getType())) break;
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceSelectReject_ERROR_, iteratorExp.toString());
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 23, message, new Object[]{iteratorExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkBooleanBodyType(IteratorExp<C, PM> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(iteratorExp, context);
        OCLExpression body = iteratorExp.getBody();
        if (env != null && body != null) {
            Object type = body.getType();
            String name = iteratorExp.getName();
            int opcode = OCLStandardLibraryUtil.getOperationCode(name);
            switch (opcode) {
                case 201: 
                case 202: 
                case 204: 
                case 205: 
                case 209: 
                case 210: {
                    if (type instanceof PrimitiveType && "Boolean".equals(env.getUMLReflection().getName(type))) break;
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceIteratorBodyBoolean_ERROR_, iteratorExp.toString());
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 24, message, new Object[]{iteratorExp}));
        }
        return result;
    }
}

