/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallExpOperations
extends OCLExpressionOperations {
    protected OperationCallExpOperations() {
    }

    public static <C, O> boolean checkArgumentsConform(OperationCallExp<C, O> operationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(operationCallExp, context);
        if (env != null) {
            UMLReflection uml;
            List parms;
            OCLExpression source = operationCallExp.getSource();
            O oper = operationCallExp.getReferredOperation();
            EList<OCLExpression<C>> args = operationCallExp.getArgument();
            if (oper != null && source != null && (parms = (uml = env.getUMLReflection()).getParameters(oper)).size() == args.size() && !TypeUtil.matchArgs(env, source.getType(), parms, args)) {
                result = false;
                message = OCLMessages.bind(OCLMessages.IllegalOperation_ERROR_, operationCallExp.toString());
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 31, message, new Object[]{operationCallExp}));
        }
        return result;
    }

    public static <C, O> boolean checkArgumentCount(OperationCallExp<C, O> operationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        O oper;
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(operationCallExp, context);
        if (env != null && (oper = operationCallExp.getReferredOperation()) != null) {
            EList<OCLExpression<C>> args = operationCallExp.getArgument();
            List parms = env.getUMLReflection().getParameters(oper);
            boolean bl = result = args.size() == parms.size();
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 32, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkArgumentCount", EObjectValidator.getObjectLabel(operationCallExp, context)}), new Object[]{operationCallExp}));
        }
        return result;
    }
}

