/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.text.StringCharacterIterator;
import lpg.runtime.ErrorToken;
import lpg.runtime.ILexStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.DerivedPrsStream;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;

public abstract class AbstractParser {
    private final BasicEnvironment environment;
    private int defaultRepairCount = 0;
    private AbstractLexer lexer;

    public AbstractParser(BasicEnvironment environment) {
        this.environment = environment;
        environment.setParser(this);
    }

    public AbstractParser(AbstractLexer lexer) {
        this.lexer = lexer;
        this.environment = lexer.getEnvironment();
        this.environment.setParser(this);
    }

    public String computeInputString(int left, int right) {
        StringBuffer result = new StringBuffer(right - left + 1);
        char[] chars = this.getIPrsStream().getInputChars();
        if (chars.length > 0) {
            int i = left;
            while (i <= right) {
                if (chars[i] == '\t') {
                    result.append(' ');
                } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                    if (i > 0 && !Character.isWhitespace(chars[i - 1])) {
                        result.append(' ');
                    }
                } else {
                    result.append(chars[i]);
                }
                ++i;
            }
        }
        return result.toString();
    }

    public BasicEnvironment getEnvironment() {
        return this.environment;
    }

    public int getDefaultRepairCount() {
        return this.defaultRepairCount;
    }

    public AbstractLexer getLexer() {
        return this.lexer;
    }

    @Deprecated
    public CSTNode parseTokensToCST() {
        return this.parser(null, this.defaultRepairCount);
    }

    @Deprecated
    public void resetLexStream(LexStream lexStream) {
        this.getIPrsStream().resetLexStream(lexStream);
    }

    public void setDefaultRepairCount(int defaultRepairCount) {
        this.defaultRepairCount = defaultRepairCount;
    }

    @Deprecated
    public void setLexStream(AbstractLexer lexer) {
        this.lexer = lexer;
        this.getIPrsStream().resetLexStream(lexer.getILexStream());
    }

    protected void setOffsets(CSTNode cstNode, IToken startEnd) {
        cstNode.setStartToken(startEnd);
        cstNode.setEndToken(startEnd);
        int startOffset = startEnd.getStartOffset();
        int endOffset = startEnd.getEndOffset();
        if (endOffset < startOffset) {
            cstNode.setStartOffset(endOffset);
            cstNode.setEndOffset(startOffset);
        } else {
            cstNode.setStartOffset(startOffset);
            cstNode.setEndOffset(endOffset);
        }
    }

    protected void setOffsets(CSTNode cstNode, CSTNode startEnd) {
        cstNode.setStartToken(startEnd.getStartToken());
        cstNode.setEndToken(startEnd.getEndToken());
        cstNode.setStartOffset(startEnd.getStartOffset());
        cstNode.setEndOffset(startEnd.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode start, CSTNode end) {
        cstNode.setStartToken(start.getStartToken());
        cstNode.setEndToken(end.getEndToken());
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode start, IToken end) {
        cstNode.setStartToken(start.getStartToken());
        cstNode.setEndToken(end);
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, IToken start, CSTNode end) {
        cstNode.setStartToken(start);
        cstNode.setEndToken(end.getEndToken());
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, IToken start, IToken end) {
        cstNode.setStartToken(start);
        cstNode.setEndToken(end);
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode) {
        IToken firstToken = this.getRhsIToken(1);
        cstNode.setStartToken(firstToken);
        cstNode.setEndToken(firstToken);
        cstNode.setStartOffset(firstToken.getStartOffset());
        cstNode.setEndOffset(firstToken.getEndOffset() - 1);
    }

    @Deprecated
    protected String unquote(String quoted) {
        String result = quoted;
        if (result != null && result.length() > 1) {
            int max = result.length() - 1;
            if (result.charAt(0) == '\"' && quoted.charAt(max) == '\"') {
                result = result.substring(1, max);
            }
            if (!(result = result.replaceAll("\\\\\"", "\"")).equals(quoted)) {
                ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
                BasicEnvironment benv = this.getEnvironment();
                if (benv != null && (sev = benv.getValue(ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE)) != null && sev != ProblemHandler.Severity.OK) {
                    benv.problem(sev, ProblemHandler.Phase.PARSER, OCLMessages.bind(OCLMessages.NonStd_DQuote_Escape_, quoted), "unquote", null);
                }
            }
        }
        return result;
    }

    @Deprecated
    protected String unDoubleQuote(IToken token) {
        if (token == null) {
            return null;
        }
        String quoted = token.toString();
        if (quoted == null) {
            return null;
        }
        int quotedLength = quoted.length();
        if (quotedLength < 2 || quoted.charAt(0) != '\"' || quoted.charAt(quotedLength - 1) != '\"') {
            return quoted;
        }
        ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
        BasicEnvironment benv = this.getEnvironment();
        if (benv != null && (sev = benv.getValue(ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE)) != null && sev != ProblemHandler.Severity.OK) {
            benv.problem(sev, ProblemHandler.Phase.PARSER, OCLMessages.bind(OCLMessages.NonStd_DQuote_Escape_, quoted), "unquote", token);
        }
        return this.decodeString(token, quoted.substring(1, quotedLength - 1));
    }

    protected String unSingleQuote(IToken token) {
        if (token == null) {
            return null;
        }
        String quoted = token.toString();
        if (quoted == null) {
            return null;
        }
        String unquoted = this.unSingleQuote(quoted);
        if (unquoted == null) {
            return quoted;
        }
        Boolean backslashProcessingEnabled = null;
        BasicEnvironment benv = this.getEnvironment();
        if (benv != null) {
            backslashProcessingEnabled = benv.getValue(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING);
        }
        if (backslashProcessingEnabled == null || !backslashProcessingEnabled.booleanValue()) {
            return unquoted;
        }
        return this.decodeString(token, unquoted);
    }

    protected String unSingleQuote(String quoted) {
        int quotedLength = quoted.length();
        if (quotedLength >= 2 && quoted.charAt(0) == '\'' && quoted.charAt(quotedLength - 1) == '\'') {
            return quoted.substring(1, quotedLength - 1);
        }
        if (quotedLength >= 3 && quoted.charAt(0) == '_' && quoted.charAt(1) == '\'' && quoted.charAt(quotedLength - 1) == '\'') {
            return quoted.substring(2, quotedLength - 1);
        }
        return null;
    }

    protected String decodeString(IToken token, String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuffer s = new StringBuffer();
        StringCharacterIterator i = new StringCharacterIterator(string);
        char c = i.first();
        while (c != '\uffff') {
            if (c != '\\') {
                s.append(c);
            } else {
                int iStart = i.getIndex();
                char ch = this.decodeEscapeSequence(i);
                if (ch != '\uffff') {
                    s.append(ch);
                } else {
                    BasicEnvironment benv = this.getEnvironment();
                    benv.problem(ProblemHandler.Severity.ERROR, ProblemHandler.Phase.PARSER, OCLMessages.bind(OCLMessages.InvalidEscapeSequence_ERROR, string.substring(iStart, i.getIndex())), "unquote", token);
                    return string;
                }
            }
            c = i.next();
        }
        return s.toString();
    }

    protected char decodeEscapeSequence(StringCharacterIterator i) {
        int savedIndex = i.getIndex();
        char c = i.next();
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case '\\': {
                return '\\';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                int c1 = c - 48;
                int c2 = this.decodeOctalCharacter(i);
                if (c2 < 0) {
                    return (char)c1;
                }
                int c3 = this.decodeOctalCharacter(i);
                if (c3 < 0) {
                    return (char)((c1 << 3) + c2);
                }
                return (char)((c1 << 6) + (c2 << 3) + c3);
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int c1 = c - 48;
                int c2 = this.decodeOctalCharacter(i);
                if (c2 < 0) {
                    i.previous();
                    return (char)c1;
                }
                return (char)((c1 << 3) + c2);
            }
            case 'x': {
                int c1 = this.decodeHexCharacter(i.next());
                int c2 = this.decodeHexCharacter(i.next());
                if (c1 < 0 || c2 < 0) break;
                return (char)((c1 << 4) + c2);
            }
            case 'u': {
                int c1 = this.decodeHexCharacter(i.next());
                int c2 = this.decodeHexCharacter(i.next());
                int c3 = this.decodeHexCharacter(i.next());
                int c4 = this.decodeHexCharacter(i.next());
                if (c1 < 0 || c2 < 0 || c3 < 0 || c4 < 0) break;
                return (char)((c1 << 12) + (c2 << 8) + (c3 << 4) + c4);
            }
        }
        i.setIndex(savedIndex);
        return '\uffff';
    }

    protected int decodeHexCharacter(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return 10 + c - 65;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + c - 97;
        }
        return -1;
    }

    protected int decodeOctalCharacter(StringCharacterIterator i) {
        char c = i.next();
        if (c == '\uffff') {
            return -1;
        }
        if ('0' <= c && c <= '7') {
            return c - 48;
        }
        i.previous();
        return -1;
    }

    public abstract String[] orderedTerminalSymbols();

    public abstract int numTokenKinds();

    public abstract DerivedPrsStream getIPrsStream();

    public abstract void reset(ILexStream var1);

    public abstract CSTNode parser();

    public abstract CSTNode parser(Monitor var1);

    public abstract CSTNode parser(int var1);

    public abstract CSTNode parser(Monitor var1, int var2);

    public abstract ParseTable getParseTable();

    protected abstract Object getRhsSym(int var1);

    protected abstract int getRhsTokenIndex(int var1);

    protected abstract IToken getRhsIToken(int var1);

    protected abstract int getRhsFirstTokenIndex(int var1);

    protected abstract IToken getRhsFirstIToken(int var1);

    protected abstract int getRhsLastTokenIndex(int var1);

    protected abstract IToken getRhsLastIToken(int var1);

    protected abstract int getLeftSpan();

    protected abstract IToken getLeftIToken();

    protected abstract int getRightSpan();

    protected abstract IToken getRightIToken();

    protected abstract int getRhsErrorTokenIndex(int var1);

    protected abstract ErrorToken getRhsErrorIToken(int var1);

    protected abstract void setResult(Object var1);
}

