/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.InitOrDerValueCS;
import org.eclipse.ocl.cst.InvCS;
import org.eclipse.ocl.cst.InvOrDefCS;
import org.eclipse.ocl.cst.OCLDocumentCS;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.PackageDeclarationCS;
import org.eclipse.ocl.cst.PrePostOrBodyDeclCS;
import org.eclipse.ocl.cst.PrePostOrBodyEnum;
import org.eclipse.ocl.cst.VariableCS;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.parser.AbstractOCLParser;
import org.eclipse.ocl.parser.OCLFactoryWithHistory;
import org.eclipse.ocl.parser.OCLLexer;
import org.eclipse.ocl.parser.OCLParser;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractOCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private OCLFactoryWithHistory history;

    public OCLAnalyzer(AbstractOCLParser parser) {
        super(parser);
    }

    public OCLAnalyzer(OCLParser parser) {
        super(parser);
    }

    public OCLAnalyzer(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment) {
        this(new OCLParser(new OCLLexer(environment)));
    }

    public OCLAnalyzer(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment, String text) {
        this(new OCLParser(new OCLLexer(environment, text.toCharArray())));
        this.getLexer().lexer(this.getAbstractParser().getIPrsStream());
    }

    @Override
    @Deprecated
    public OCLParser getParser() {
        return (OCLParser)super.getParser();
    }

    @Override
    protected OCLFactory createOCLFactory(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        this.history = env.getFactory().createOCLFactoryWithHistory(env);
        return this.history;
    }

    private <T> T sanitize(T parseResult) {
        this.history.clear();
        return parseResult;
    }

    public CSTNode parseConcreteSyntax() {
        return this.getAbstractParser().parser();
    }

    public OCLExpression<C> parseAST(OCLExpressionCS cst, ConstraintKind constraintType) {
        AbstractOCLParser parser = this.getAbstractParser();
        OCLExpression result = null;
        switch (constraintType) {
            case PRECONDITION: {
                PrePostOrBodyDeclCS pre = parser.createPrePostOrBodyDeclCS(PrePostOrBodyEnum.PRE_LITERAL, null, cst);
                result = this.uml.getSpecification(this.prePostOrBodyDeclCS(this.getOCLEnvironment(), pre)).getBodyExpression();
                break;
            }
            case BODYCONDITION: {
                PrePostOrBodyDeclCS body = parser.createPrePostOrBodyDeclCS(PrePostOrBodyEnum.BODY_LITERAL, null, cst);
                result = this.uml.getSpecification(this.prePostOrBodyDeclCS(this.getOCLEnvironment(), body)).getBodyExpression();
                break;
            }
            case POSTCONDITION: {
                PrePostOrBodyDeclCS post = parser.createPrePostOrBodyDeclCS(PrePostOrBodyEnum.POST_LITERAL, null, cst);
                result = this.uml.getSpecification(this.prePostOrBodyDeclCS(this.getOCLEnvironment(), post)).getBodyExpression();
                break;
            }
            default: {
                InvCS inv = parser.createInvCS(null, cst);
                result = this.uml.getSpecification(this.invCS(inv, this.getOCLEnvironment())).getBodyExpression();
            }
        }
        return this.sanitize(result);
    }

    public List<CT> parseOCLDocument(List<CT> constraints) {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && !(cstNode instanceof PackageDeclarationCS)) {
            this.ERROR(cstNode, "parseOCLDocument", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PackageDeclarationCS", cstNode.eClass().getName()));
            return this.sanitize(constraints);
        }
        OCLDocumentCS documentCS = this.getAbstractParser().createOCLDocumentCS((PackageDeclarationCS)cstNode);
        this.documentCS(documentCS, constraints);
        return this.sanitize(constraints);
    }

    public List<CT> parsePackageDeclarationCS(List<CT> constraints) {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && !(cstNode instanceof PackageDeclarationCS)) {
            this.ERROR(cstNode, "parsePackageDeclarationCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PackageDeclarationCS", cstNode.eClass().getName()));
            return this.sanitize(constraints);
        }
        BasicEList.FastCompare<PackageDeclarationCS> packageDecls = new BasicEList.FastCompare<PackageDeclarationCS>(4);
        PackageDeclarationCS pkgdecl = (PackageDeclarationCS)cstNode;
        while (pkgdecl != null) {
            packageDecls.add(0, pkgdecl);
            pkgdecl = pkgdecl.getPackageDeclarationCS();
        }
        for (PackageDeclarationCS packageDeclCS : packageDecls) {
            this.packageDeclarationCS(packageDeclCS, constraints);
        }
        return this.sanitize(constraints);
    }

    public CT parseInvOrDefCS() {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null) {
            if (cstNode instanceof InvOrDefCS) {
                return this.sanitize(this.invOrDefCS((InvOrDefCS)cstNode, this.getOCLEnvironment()));
            }
            this.ERROR(cstNode, "parseInvOrDefCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "InvOrDefCS", cstNode.eClass().getName()));
        }
        return this.sanitize(null);
    }

    public CT parsePrePostOrBodyDeclCS() {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && cstNode instanceof PrePostOrBodyDeclCS) {
            return this.sanitize(this.prePostOrBodyDeclCS(this.getOCLEnvironment(), (PrePostOrBodyDeclCS)cstNode));
        }
        this.ERROR(cstNode, "parsePrePostOrBodyDeclCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PrePostOrBodyDeclCS", this.formatEClassName(cstNode)));
        return this.sanitize(null);
    }

    public CT parseInitOrDerValueCS() {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && cstNode instanceof InitOrDerValueCS) {
            return this.sanitize(this.initOrDerValueCS(this.getOCLEnvironment(), (InitOrDerValueCS)cstNode));
        }
        this.ERROR(cstNode, "parseInitOrDerValueCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "InitOrDerValueCS", this.formatEClassName(cstNode)));
        return this.sanitize(null);
    }

    public Variable<C, PM> parseVariableDeclarationCS(boolean addToEnvironment) {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null) {
            if (cstNode instanceof VariableCS) {
                return this.sanitize(this.variableDeclarationCS((VariableCS)cstNode, this.getOCLEnvironment(), true));
            }
            this.ERROR(cstNode, "parseVariableDeclarationCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "VariableDeclarationCS", cstNode.eClass().getName()));
        }
        return this.sanitize(null);
    }

    @Override
    public void ERROR(List<?> problemObjects, String rule, String problemMessage) {
        this.history.setDisposable();
        super.ERROR(problemObjects, rule, problemMessage);
    }

    @Override
    public void ERROR(Object problemObject, String rule, String problemMessage) {
        this.history.setDisposable();
        super.ERROR(problemObject, rule, problemMessage);
    }

    @Override
    public void ERROR(String problemMessage) {
        this.history.setDisposable();
        super.ERROR(problemMessage);
    }

    @Override
    protected CT createConstraint() {
        return this.history.record(super.createConstraint());
    }

    @Override
    protected ExpressionInOCL<C, PM> createExpressionInOCL() {
        return this.history.record(super.createExpressionInOCL());
    }

    @Override
    protected boolean isErrorNode(TypedElement<C> expr) {
        return this.history.isErrorNode(expr);
    }

    @Override
    protected void markAsErrorNode(TypedElement<C> expr) {
        this.history.markAsErrorNode(expr);
    }
}

