/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import java.io.IOException;
import java.io.Reader;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexParser;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.DerivedLexStream;
import org.eclipse.ocl.lpg.DerivedPrsStream;
import org.eclipse.ocl.parser.OCLKWLexer;
import org.eclipse.ocl.parser.OCLLexerprs;
import org.eclipse.ocl.parser.OCLParsersym;
import org.eclipse.ocl.util.OCLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLLexer
extends AbstractLexer
implements RuleAction {
    private OCLLexerLpgLexStream lexStream;
    private static ParseTable prs = new OCLLexerprs();
    private LexParser lexParser = new LexParser();
    private final Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> oclEnvironment;
    OCLKWLexer kwLexer;
    boolean printTokens;
    private static final int ECLIPSE_TAB_VALUE = 4;

    @Override
    public ParseTable getParseTable() {
        return prs;
    }

    @Override
    public LexParser getParser() {
        return this.lexParser;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getToken(1);
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    @Override
    public void resetKeywordLexer() {
        if (this.kwLexer == null) {
            this.kwLexer = new OCLKWLexer(this.lexStream.getInputChars(), 7);
        } else {
            this.kwLexer.setInputChars(this.lexStream.getInputChars());
        }
    }

    @Override
    public void reset(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    @Override
    public void reset(char[] input_chars, String filename, int tab) {
        this.lexStream = new OCLLexerLpgLexStream(this.getOCLEnvironment(), input_chars, filename, tab);
        this.lexParser.reset(this.lexStream, prs, this);
        this.resetKeywordLexer();
    }

    public OCLLexer(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment) {
        super(OCLUtil.getAdapter(environment, BasicEnvironment.class));
        this.oclEnvironment = environment;
    }

    public OCLLexer(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment, char[] chars) {
        this(environment, chars, "OCL", 4);
    }

    public OCLLexer(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment, char[] input_chars, String filename, int tab) {
        super(OCLUtil.getAdapter(environment, BasicEnvironment.class));
        this.oclEnvironment = environment;
        this.reset(input_chars, filename, tab);
    }

    public Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> getOCLEnvironment() {
        return this.oclEnvironment;
    }

    @Override
    public DerivedLexStream getILexStream() {
        return this.lexStream;
    }

    @Override
    @Deprecated
    public ILexStream getLexStream() {
        return this.lexStream;
    }

    private void initializeLexer(DerivedPrsStream prsStream, int start_offset, int end_offset) {
        if (this.lexStream.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.lexStream.setPrsStream(prsStream);
        prsStream.makeToken(start_offset, end_offset, 0);
    }

    private void addEOF(DerivedPrsStream prsStream, int end_offset) {
        prsStream.makeToken(end_offset, end_offset, 76);
        prsStream.setStreamLength(prsStream.getSize());
    }

    @Override
    public void lexer(DerivedPrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    @Override
    public void lexer(Monitor monitor, DerivedPrsStream prsStream) {
        this.initializeLexer(prsStream, 0, -1);
        this.lexParser.parseCharacters(monitor);
        this.addEOF(prsStream, this.lexStream.getStreamIndex());
    }

    @Override
    public void lexer(DerivedPrsStream prsStream, int start_offset, int end_offset) {
        this.lexer(null, prsStream, start_offset, end_offset);
    }

    @Override
    public void lexer(Monitor monitor, DerivedPrsStream prsStream, int start_offset, int end_offset) {
        if (start_offset <= 1) {
            this.initializeLexer(prsStream, 0, -1);
        } else {
            this.initializeLexer(prsStream, start_offset - 1, start_offset - 1);
        }
        this.lexParser.parseCharacters(monitor, start_offset, end_offset);
        this.addEOF(prsStream, end_offset >= this.lexStream.getStreamIndex() ? this.lexStream.getStreamIndex() : end_offset + 1);
    }

    @Override
    public void reportLexicalError(int startLoc, int endLoc) {
        IPrsStream prs_stream = this.lexStream.getIPrsStream();
        if (prs_stream == null) {
            this.lexStream.reportLexicalError(startLoc, endLoc);
        } else {
            int i = prs_stream.getSize() - 1;
            while (i > 0) {
                if (prs_stream.getStartOffset(i) < startLoc) break;
                prs_stream.removeLastToken();
                --i;
            }
            prs_stream.makeToken(startLoc, endLoc, 0);
        }
    }

    @Override
    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    @Deprecated
    public void initialize(char[] content, String filename) {
        this.reset(content, filename);
    }

    final void makeToken(int left_token, int right_token, int kind) {
        this.lexStream.makeToken(left_token, right_token, kind);
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.makeToken(startOffset, endOffset, kind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.getIPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
        if (this.printTokens) {
            this.printValue(this.getLeftSpan(), this.getRightSpan());
        }
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void checkForKeyWord(int defaultKind) {
        int endOffset;
        int startOffset = this.getLeftSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset = this.getRightSpan());
        if (kwKind == 7) {
            kwKind = defaultKind;
        }
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void printValue(int startOffset, int endOffset) {
        String s = new String(this.lexStream.getInputChars(), startOffset, endOffset - startOffset + 1);
        System.out.print(s);
    }

    public OCLLexer(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment, Reader reader, String filename) throws IOException {
        super(OCLUtil.getAdapter(environment, BasicEnvironment.class));
        this.oclEnvironment = environment;
        this.reset(reader, filename);
    }

    @Override
    public void reset(Reader reader, String filename) throws IOException {
        char[] input_chars = OCLLexer.getInputChars(reader);
        this.reset(input_chars, filename, 4);
    }

    @Override
    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(7);
                break;
            }
            case 3: {
                this.makeToken(6);
                break;
            }
            case 4: {
                this.makeToken(36);
                break;
            }
            case 5: {
                this.makeToken(36);
                break;
            }
            case 6: {
                this.makeToken(36);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.makeToken(43);
                break;
            }
            case 11: {
                this.makeComment(77);
                break;
            }
            case 12: {
                this.makeComment(78);
                break;
            }
            case 13: {
                this.skipToken();
                break;
            }
            case 14: {
                this.makeToken(10);
                break;
            }
            case 15: {
                this.makeToken(4);
                break;
            }
            case 16: {
                this.makeToken(5);
                break;
            }
            case 17: {
                this.makeToken(11);
                break;
            }
            case 18: {
                this.makeToken(1);
                break;
            }
            case 19: {
                this.makeToken(2);
                break;
            }
            case 20: {
                this.makeToken(17);
                break;
            }
            case 21: {
                this.makeToken(18);
                break;
            }
            case 22: {
                this.makeToken(8);
                break;
            }
            case 23: {
                this.makeToken(19);
                break;
            }
            case 24: {
                this.makeToken(20);
                break;
            }
            case 25: {
                this.makeToken(37);
                break;
            }
            case 26: {
                this.makeToken(56);
                break;
            }
            case 27: {
                this.makeToken(66);
                break;
            }
            case 28: {
                this.makeToken(60);
                break;
            }
            case 29: {
                this.makeToken(61);
                break;
            }
            case 30: {
                this.makeToken(13);
                break;
            }
            case 31: {
                this.makeToken(39);
                break;
            }
            case 32: {
                this.makeToken(9);
                break;
            }
            case 33: {
                this.makeToken(3);
                break;
            }
            case 34: {
                this.makeToken(12);
                break;
            }
            case 35: {
                this.makeToken(67);
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                this.makeToken(14);
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                this.makeToken(70);
                break;
            }
            case 40: {
                this.makeToken(42);
                break;
            }
            case 265: {
                this.makeToken(38);
                break;
            }
            case 266: {
                this.makeToken(15);
                break;
            }
            case 267: {
                this.makeToken(16);
                break;
            }
            case 268: {
                this.makeToken(68);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OCLLexerLpgLexStream
    extends DerivedLexStream {
        public static final int[] tokenKind = new int[]{103, 103, 103, 103, 103, 103, 103, 103, 103, 97, 100, 103, 98, 101, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 69, 92, 90, 94, 78, 91, 95, 70, 88, 89, 74, 73, 85, 15, 13, 87, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 72, 79, 86, 16, 14, 84, 76, 43, 44, 45, 46, 12, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 82, 96, 83, 71, 42, 77, 17, 18, 19, 20, 11, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 80, 75, 81, 93, 103, 102, 68, 99};

        @Override
        public final int getKind(int i) {
            int c;
            int n = c = i >= this.getStreamLength() ? 65535 : (int)this.getCharValue(i);
            return c < 128 ? tokenKind[c] : (c == 65535 ? 99 : (c == 180 ? 99 : 68));
        }

        @Override
        public String[] orderedExportedSymbols() {
            return OCLParsersym.orderedTerminalSymbols;
        }

        public OCLLexerLpgLexStream(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment, String filename, int tab) throws IOException {
            super(OCLUtil.getAdapter(environment, BasicEnvironment.class), filename, tab);
        }

        public OCLLexerLpgLexStream(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment, char[] input_chars, String filename, int tab) {
            super(OCLUtil.getAdapter(environment, BasicEnvironment.class), input_chars, filename, tab);
        }

        public OCLLexerLpgLexStream(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environment, char[] input_chars, String filename) {
            super(OCLUtil.getAdapter(environment, BasicEnvironment.class), input_chars, filename, 1);
        }
    }
}

