/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import lpg.runtime.IPrsStream;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;

public class OCLProblemHandler
extends AbstractProblemHandler {
    private DiagnosticChain diagnostics;

    public OCLProblemHandler(AbstractParser parser) {
        super(parser);
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(problemSeverity.getDiagnosticSeverity(), OCLPlugin.getPluginId(), 1, problemMessage, new Object[]{processingPhase, processingContext});
        if (this.diagnostics == null) {
            this.diagnostics = diagnostic;
        } else {
            this.diagnostics.add(diagnostic);
        }
    }

    public Diagnostic getDiagnostic() {
        return (Diagnostic)((Object)this.diagnostics);
    }

    public void beginParse() {
        this.clearDiagnostic();
    }

    public void beginValidation() {
        this.clearDiagnostic();
    }

    public void clearDiagnostic() {
        this.diagnostics = null;
    }

    public void parserProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        int rightToken;
        IPrsStream prsStream = this.getIPrsStream();
        int leftToken = prsStream.getTokenIndexAtCharacter(startOffset);
        int leftTokenLoc = leftToken > (rightToken = prsStream.getTokenIndexAtCharacter(endOffset)) ? rightToken : leftToken;
        int rightTokenLoc = rightToken;
        int line = prsStream.getLine(leftTokenLoc) + this.getErrorReportLineOffset();
        if (line > 0) {
            String locInfo = OCLMessages.bind(OCLMessages.ErrorReport_RowColumn, new Object[]{new Integer(prsStream.getLine(leftTokenLoc) + this.getErrorReportLineOffset()), new Integer(prsStream.getColumn(leftTokenLoc)), new Integer(prsStream.getEndLine(rightTokenLoc) + this.getErrorReportLineOffset()), new Integer(prsStream.getEndColumn(rightTokenLoc))});
            problemMessage = String.valueOf(locInfo) + " " + problemMessage;
        }
        this.handleProblem(problemSeverity, ProblemHandler.Phase.PARSER, problemMessage, processingContext, startOffset, endOffset);
    }

    protected IPrsStream getIPrsStream() {
        return this.getParser().getIPrsStream();
    }
}

