/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.lpg.StringProblemHandler;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ProblemHandlerWrapper;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCLStandardLibraryUtil {
    public static final String PRODUCT_FIRST = "first";
    public static final String PRODUCT_SECOND = "second";
    private static final Map<String, Integer> operationCodes = new HashMap<String, Integer>();
    private static final Map<String, Integer> oclAnyOperationCodes = new HashMap<String, Integer>();
    private static final int ANY_OPERATION_COUNT = 9;
    private static final int COLLECTION_OPERATION_COUNT = 10;
    private static final int SET_OPERATION_COUNT = 25;
    private static final int COLLECTION_ITERATOR_COUNT = 7;
    private static final int SET_ITERATOR_COUNT = 11;

    static {
        operationCodes.put("+", 1);
        operationCodes.put("-", 2);
        operationCodes.put("*", 3);
        operationCodes.put("/", 4);
        operationCodes.put("and", 10);
        operationCodes.put("not", 11);
        operationCodes.put("or", 12);
        operationCodes.put("implies", 13);
        operationCodes.put("abs", 15);
        operationCodes.put("div", 16);
        operationCodes.put("mod", 17);
        operationCodes.put("max", 18);
        operationCodes.put("min", 19);
        operationCodes.put("size", 20);
        operationCodes.put("concat", 21);
        operationCodes.put("substring", 22);
        operationCodes.put("toInteger", 23);
        operationCodes.put("toReal", 24);
        operationCodes.put("xor", 25);
        operationCodes.put("floor", 26);
        operationCodes.put("round", 27);
        operationCodes.put("toLower", 28);
        operationCodes.put("toUpper", 29);
        operationCodes.put("allInstances", 40);
        operationCodes.put("=", 60);
        operationCodes.put("<>", 61);
        operationCodes.put("oclAsType", 62);
        operationCodes.put("oclIsKindOf", 63);
        operationCodes.put("oclIsTypeOf", 64);
        operationCodes.put("oclIsUndefined", 65);
        operationCodes.put("oclIsInvalid", 66);
        operationCodes.put("<", 67);
        operationCodes.put(">", 68);
        operationCodes.put("<=", 69);
        operationCodes.put(">=", 70);
        operationCodes.put("oclIsNew", 71);
        operationCodes.put("oclIsInState", 72);
        operationCodes.put("hasReturned", 100);
        operationCodes.put("result", 101);
        operationCodes.put("isSignalSent", 102);
        operationCodes.put("isOperationCall", 103);
        operationCodes.put("count", 140);
        operationCodes.put("excludes", 141);
        operationCodes.put("excludesAll", 142);
        operationCodes.put("includes", 143);
        operationCodes.put("includesAll", 144);
        operationCodes.put("isEmpty", 145);
        operationCodes.put("notEmpty", 146);
        operationCodes.put("product", 147);
        operationCodes.put("sum", 148);
        operationCodes.put("asBag", 149);
        operationCodes.put("asOrderedSet", 150);
        operationCodes.put("asSequence", 151);
        operationCodes.put("asSet", 152);
        operationCodes.put("excluding", 153);
        operationCodes.put("flatten", 154);
        operationCodes.put("including", 155);
        operationCodes.put("intersection", 156);
        operationCodes.put("union", 157);
        operationCodes.put("at", 158);
        operationCodes.put(PRODUCT_FIRST, 159);
        operationCodes.put("indexOf", 160);
        operationCodes.put("insertAt", 161);
        operationCodes.put("last", 162);
        operationCodes.put("prepend", 163);
        operationCodes.put("subSequence", 164);
        operationCodes.put("append", 165);
        operationCodes.put("subOrderedSet", 166);
        operationCodes.put("symmetricDifference", 167);
        operationCodes.put("exists", 201);
        operationCodes.put("forAll", 202);
        operationCodes.put("isUnique", 203);
        operationCodes.put("one", 204);
        operationCodes.put("any", 205);
        operationCodes.put("collect", 206);
        operationCodes.put("collectNested", 207);
        operationCodes.put("closure", 208);
        operationCodes.put("select", 209);
        operationCodes.put("reject", 210);
        operationCodes.put("sortedBy", 211);
        oclAnyOperationCodes.put("=", 60);
        oclAnyOperationCodes.put("<>", 61);
        oclAnyOperationCodes.put("oclAsType", 62);
        oclAnyOperationCodes.put("oclIsKindOf", 63);
        oclAnyOperationCodes.put("oclIsTypeOf", 64);
        oclAnyOperationCodes.put("oclIsUndefined", 65);
        oclAnyOperationCodes.put("oclIsInvalid", 66);
        oclAnyOperationCodes.put("<", 67);
        oclAnyOperationCodes.put(">", 68);
        oclAnyOperationCodes.put("<=", 69);
        oclAnyOperationCodes.put(">=", 70);
        oclAnyOperationCodes.put("oclIsNew", 71);
        oclAnyOperationCodes.put("oclIsInState", 72);
    }

    private OCLStandardLibraryUtil() {
    }

    public static int getOperationCode(String operName) {
        Integer code = operationCodes.get(operName);
        return code == null ? 0 : code;
    }

    public static int getOclAnyOperationCode(String operName) {
        Integer code = oclAnyOperationCodes.get(operName);
        return code == null ? 0 : code;
    }

    public static String getOperationName(int opcode) {
        switch (opcode) {
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "*";
            }
            case 4: {
                return "/";
            }
            case 10: {
                return "and";
            }
            case 11: {
                return "not";
            }
            case 12: {
                return "or";
            }
            case 13: {
                return "implies";
            }
            case 15: {
                return "abs";
            }
            case 16: {
                return "div";
            }
            case 17: {
                return "mod";
            }
            case 18: {
                return "max";
            }
            case 19: {
                return "min";
            }
            case 20: {
                return "size";
            }
            case 21: {
                return "concat";
            }
            case 22: {
                return "substring";
            }
            case 23: {
                return "toInteger";
            }
            case 24: {
                return "toReal";
            }
            case 25: {
                return "xor";
            }
            case 26: {
                return "floor";
            }
            case 27: {
                return "round";
            }
            case 28: {
                return "toLower";
            }
            case 29: {
                return "toUpper";
            }
            case 40: {
                return "allInstances";
            }
            case 60: {
                return "=";
            }
            case 61: {
                return "<>";
            }
            case 62: {
                return "oclAsType";
            }
            case 63: {
                return "oclIsKindOf";
            }
            case 64: {
                return "oclIsTypeOf";
            }
            case 65: {
                return "oclIsUndefined";
            }
            case 66: {
                return "oclIsInvalid";
            }
            case 67: {
                return "<";
            }
            case 68: {
                return ">";
            }
            case 69: {
                return "<=";
            }
            case 70: {
                return ">=";
            }
            case 71: {
                return "oclIsNew";
            }
            case 72: {
                return "oclIsInState";
            }
            case 100: {
                return "hasReturned";
            }
            case 101: {
                return "result";
            }
            case 102: {
                return "isSignalSent";
            }
            case 103: {
                return "isOperationCall";
            }
            case 140: {
                return "count";
            }
            case 141: {
                return "excludes";
            }
            case 142: {
                return "excludesAll";
            }
            case 143: {
                return "includes";
            }
            case 144: {
                return "includesAll";
            }
            case 145: {
                return "isEmpty";
            }
            case 146: {
                return "notEmpty";
            }
            case 147: {
                return "product";
            }
            case 148: {
                return "sum";
            }
            case 149: {
                return "asBag";
            }
            case 150: {
                return "asOrderedSet";
            }
            case 151: {
                return "asSequence";
            }
            case 152: {
                return "asSet";
            }
            case 153: {
                return "excluding";
            }
            case 154: {
                return "flatten";
            }
            case 155: {
                return "including";
            }
            case 156: {
                return "intersection";
            }
            case 157: {
                return "union";
            }
            case 158: {
                return "at";
            }
            case 159: {
                return PRODUCT_FIRST;
            }
            case 160: {
                return "indexOf";
            }
            case 161: {
                return "insertAt";
            }
            case 162: {
                return "last";
            }
            case 163: {
                return "prepend";
            }
            case 164: {
                return "subSequence";
            }
            case 165: {
                return "append";
            }
            case 166: {
                return "subOrderedSet";
            }
            case 167: {
                return "symmetricDifference";
            }
            case 201: {
                return "exists";
            }
            case 202: {
                return "forAll";
            }
            case 203: {
                return "isUnique";
            }
            case 204: {
                return "one";
            }
            case 205: {
                return "any";
            }
            case 206: {
                return "collect";
            }
            case 207: {
                return "collectNested";
            }
            case 208: {
                return "closure";
            }
            case 209: {
                return "select";
            }
            case 210: {
                return "reject";
            }
            case 211: {
                return "sortedBy";
            }
        }
        return "";
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getResultTypeOf(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, C sourceType, int opcode, List<? extends TypedElement<C>> args) throws SemanticException {
        StringProblemHandler handler = null;
        ProblemHandler oldHandler = null;
        BasicEnvironment benv = OCLUtil.getAdapter(env, BasicEnvironment.class);
        if (benv != null) {
            AbstractParser parser = benv.getParser();
            oldHandler = benv.getProblemHandler();
            handler = new StringProblemHandler(parser);
            benv.setProblemHandler(new ProblemHandlerWrapper.Tee(oldHandler, handler));
        }
        try {
            C result = OCLStandardLibraryUtil.getResultTypeOf(null, env, sourceType, opcode, args);
            if (result == null) {
                String message = handler != null ? handler.getProblemString() : "No handler";
                throw new SemanticException(message);
            }
            C c = result;
            return c;
        }
        finally {
            if (benv != null) {
                benv.setProblemHandler(oldHandler);
            }
        }
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, C sourceType, int opcode, List<? extends TypedElement<C>> args) {
        if (sourceType instanceof PrimitiveType) {
            return OCLStandardLibraryUtil.getPrimitiveTypeResultTypeOf(problemObject, env, sourceType, opcode, args);
        }
        if (sourceType instanceof CollectionType) {
            if (sourceType instanceof BagType) {
                BagType bagType = (BagType)sourceType;
                return OCLStandardLibraryUtil.getBagTypeResultTypeOf(problemObject, env, bagType, opcode, args);
            }
            if (sourceType instanceof SetType) {
                SetType setType = (SetType)sourceType;
                return OCLStandardLibraryUtil.getSetTypeResultTypeOf(problemObject, env, setType, opcode, args);
            }
            if (sourceType instanceof OrderedSetType) {
                OrderedSetType orderedSetType = (OrderedSetType)sourceType;
                return OCLStandardLibraryUtil.getOrderedSetTypeResultTypeOf(problemObject, env, orderedSetType, opcode, args);
            }
            if (sourceType instanceof SequenceType) {
                SequenceType seqType = (SequenceType)sourceType;
                return OCLStandardLibraryUtil.getSequenceTypeResultTypeOf(problemObject, env, seqType, opcode, args);
            }
            CollectionType collType = (CollectionType)sourceType;
            return OCLStandardLibraryUtil.getCollectionTypeResultTypeOf(problemObject, env, collType, opcode, args);
        }
        if (sourceType instanceof TypeType) {
            TypeType typeType = (TypeType)sourceType;
            return OCLStandardLibraryUtil.getTypeTypeResultTypeOf(problemObject, env, typeType, opcode, args);
        }
        if (sourceType instanceof MessageType) {
            MessageType messageType = (MessageType)sourceType;
            return OCLStandardLibraryUtil.getMessageTypeResultTypeOf(problemObject, env, messageType, opcode, args);
        }
        return OCLStandardLibraryUtil.getAnyTypeResultTypeOf(problemObject, env, sourceType, opcode, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getAnyTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, C sourceType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        switch (opcode) {
            case 60: 
            case 61: {
                TypedElement<C> arg = args.get(0);
                C argType = arg.getType();
                return stdlib.getBoolean();
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                TypedElement<C> arg = args.get(0);
                C argType = arg.getType();
                Object oper = null;
                try {
                    oper = TypeUtil.findOperationMatching(env, sourceType, OCLStandardLibraryUtil.getOperationName(opcode), args);
                    if (oper == null && ParsingOptions.getValue(env, ParsingOptions.USE_COMPARE_TO_OPERATION).booleanValue()) {
                        if (uml.isDataType(sourceType)) {
                            if (uml.isComparable(sourceType)) {
                                TypeUtil.checkMutuallyComparable(problemObject, env, sourceType, argType, opcode);
                                OCLStandardLibraryUtil.warning(env, OCLMessages.NonStd_CompareTo_, "getAnyTypeResultOf", problemObject);
                                return stdlib.getBoolean();
                            }
                            String message = OCLMessages.bind(OCLMessages.SourceEClass_ERROR_, OCLStandardLibraryUtil.getOperationName(opcode));
                            OCLStandardLibraryUtil.error(env, message, "anyTypeResultTypeOf", problemObject);
                            return null;
                        }
                        oper = TypeUtil.findOperationMatching(env, sourceType, "compareTo", args);
                        if (oper != null) {
                            OCLStandardLibraryUtil.warning(env, OCLMessages.NonStd_CompareTo_, "getAnyTypeResultOf", problemObject);
                        }
                    }
                }
                catch (Exception e) {
                    String message = OCLMessages.bind(OCLMessages.SourceOperationCompareTo_ERROR_, OCLStandardLibraryUtil.getOperationName(opcode));
                    OCLStandardLibraryUtil.error(env, message, "anyTypeResultTypeOf", problemObject);
                    return null;
                }
                if (oper != null && "compareTo".equals(uml.getName(oper)) && TypeUtil.resolveType(env, uml.getOCLType(oper)) != stdlib.getInteger()) {
                    String message = OCLMessages.ResultCompareToInt_ERROR_;
                    OCLStandardLibraryUtil.error(env, message, "anyTypeResultTypeOf", problemObject);
                    return null;
                }
                return stdlib.getBoolean();
            }
            case 63: 
            case 64: 
            case 71: 
            case 72: {
                return stdlib.getBoolean();
            }
            case 62: {
                C argType;
                TypedElement<C> arg = args.get(0);
                if (arg instanceof TypeExp) {
                    TypeExp typeExp = (TypeExp)arg;
                    argType = typeExp.getReferredType();
                } else {
                    argType = arg.getType();
                }
                if (sourceType instanceof CollectionType) {
                    String message = OCLMessages.bind(OCLMessages.Noncomforming_ERROR_, uml.getName(sourceType), OCLStandardLibraryUtil.getOperationName(opcode));
                    OCLStandardLibraryUtil.error(env, message, "anyTypeResultTypeOf", problemObject);
                    return null;
                }
                return argType;
            }
            case 65: 
            case 66: {
                return stdlib.getBoolean();
            }
        }
        return null;
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getPrimitiveTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, C sourceType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        switch (opcode) {
            case 1: 
            case 3: {
                C argType = args.get(0).getType();
                return TypeUtil.commonSuperType(problemObject, env, argType, sourceType);
            }
            case 4: {
                C argType = args.get(0).getType();
                TypeUtil.commonSuperType(problemObject, env, argType, sourceType);
                return stdlib.getReal();
            }
            case 2: {
                if (args == null || args.size() == 0) {
                    return sourceType;
                }
                C argType = args.get(0).getType();
                return TypeUtil.commonSuperType(problemObject, env, argType, sourceType);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 25: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return stdlib.getBoolean();
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                return sourceType;
            }
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                return stdlib.getInteger();
            }
            case 24: {
                return stdlib.getReal();
            }
            case 28: 
            case 29: {
                return stdlib.getString();
            }
        }
        return OCLStandardLibraryUtil.getAnyTypeResultTypeOf(problemObject, env, sourceType, opcode, args);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getBagTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, BagType<C, O> bagType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        OCLFactory oclFactory = env.getOCLFactory();
        BagType<C, O> sourceType = bagType;
        Object elemType = bagType.getElementType();
        switch (opcode) {
            case 60: 
            case 61: {
                return stdlib.getBoolean();
            }
            case 157: {
                C argType = args.get(0).getType();
                C argElementType = OCLStandardLibraryUtil.getElementType(argType);
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argElementType));
            }
            case 155: {
                C argType = args.get(0).getType();
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argType));
            }
            case 156: {
                C argType = args.get(0).getType();
                C argElementType = OCLStandardLibraryUtil.getElementType(argType);
                if (argType instanceof SetType) {
                    return OCLStandardLibraryUtil.getSetType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argElementType));
                }
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argElementType));
            }
            case 153: {
                return (C)sourceType;
            }
            case 140: {
                return stdlib.getInteger();
            }
            case 154: {
                if (!(elemType instanceof CollectionType)) {
                    return (C)sourceType;
                }
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, CollectionUtil.getFlattenedElementType(bagType));
            }
            case 149: {
                return (C)sourceType;
            }
            case 151: {
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, elemType);
            }
            case 152: {
                return OCLStandardLibraryUtil.getSetType(env, oclFactory, elemType);
            }
            case 150: {
                return OCLStandardLibraryUtil.getOrderedSetType(env, oclFactory, elemType);
            }
            case 209: 
            case 210: {
                return (C)sourceType;
            }
            case 211: {
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, elemType);
            }
            case 207: {
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, stdlib.getT2());
            }
        }
        return OCLStandardLibraryUtil.getCollectionTypeResultTypeOf(problemObject, env, bagType, opcode, args);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getSetTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, SetType<C, O> setType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        OCLFactory oclFactory = env.getOCLFactory();
        SetType<C, O> sourceType = setType;
        Object elemType = setType.getElementType();
        switch (opcode) {
            case 60: 
            case 61: {
                return stdlib.getBoolean();
            }
            case 157: {
                C argType = args.get(0).getType();
                C argElementType = OCLStandardLibraryUtil.getElementType(argType);
                C newElementType = TypeUtil.commonSuperType(problemObject, env, elemType, argElementType);
                C resultType = argType instanceof BagType ? OCLStandardLibraryUtil.getBagType(env, oclFactory, newElementType) : OCLStandardLibraryUtil.getSetType(env, oclFactory, newElementType);
                return resultType;
            }
            case 2: 
            case 167: {
                C argType = args.get(0).getType();
                C argElementType = OCLStandardLibraryUtil.getElementType(argType);
                C resultType = OCLStandardLibraryUtil.getSetType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argElementType));
                return resultType;
            }
            case 155: {
                C argType = args.get(0).getType();
                C resultType = OCLStandardLibraryUtil.getSetType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argType));
                return resultType;
            }
            case 156: {
                C argType = args.get(0).getType();
                C argElementType = OCLStandardLibraryUtil.getElementType(argType);
                C resultType = OCLStandardLibraryUtil.getSetType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argElementType));
                return (C)sourceType;
            }
            case 153: {
                return (C)sourceType;
            }
            case 140: {
                return stdlib.getInteger();
            }
            case 154: {
                if (!(elemType instanceof CollectionType)) {
                    return (C)sourceType;
                }
                C resultType = OCLStandardLibraryUtil.getSetType(env, oclFactory, CollectionUtil.getFlattenedElementType(setType));
                return resultType;
            }
            case 149: {
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, elemType);
            }
            case 151: {
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, elemType);
            }
            case 152: {
                return (C)sourceType;
            }
            case 150: {
                return OCLStandardLibraryUtil.getOrderedSetType(env, oclFactory, elemType);
            }
            case 209: 
            case 210: {
                return (C)sourceType;
            }
            case 211: {
                return OCLStandardLibraryUtil.getOrderedSetType(env, oclFactory, elemType);
            }
            case 207: {
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, stdlib.getT2());
            }
        }
        return OCLStandardLibraryUtil.getCollectionTypeResultTypeOf(problemObject, env, setType, opcode, args);
    }

    private static <C, O> C getElementType(C type) {
        if (type instanceof CollectionType) {
            CollectionType castType = (CollectionType)type;
            return castType.getElementType();
        }
        return null;
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getOrderedSetTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OrderedSetType<C, O> orderedSetType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        OCLFactory oclFactory = env.getOCLFactory();
        OrderedSetType<C, O> sourceType = orderedSetType;
        Object elemType = orderedSetType.getElementType();
        switch (opcode) {
            case 60: 
            case 61: {
                return stdlib.getBoolean();
            }
            case 160: {
                return stdlib.getInteger();
            }
            case 163: 
            case 165: {
                C argType = args.get(0).getType();
                return OCLStandardLibraryUtil.getOrderedSetType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argType));
            }
            case 161: {
                C argType = args.get(1).getType();
                return OCLStandardLibraryUtil.getOrderedSetType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argType));
            }
            case 166: {
                return (C)sourceType;
            }
            case 158: 
            case 159: 
            case 162: {
                return elemType;
            }
            case 152: {
                return OCLStandardLibraryUtil.getSetType(env, oclFactory, elemType);
            }
            case 149: {
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, elemType);
            }
            case 151: {
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, elemType);
            }
        }
        SetType setType = (SetType)OCLStandardLibraryUtil.getSetType(env, oclFactory, elemType);
        return OCLStandardLibraryUtil.getSetTypeResultTypeOf(problemObject, env, setType, opcode, args);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getSequenceTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, SequenceType<C, O> seqType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        OCLFactory oclFactory = env.getOCLFactory();
        SequenceType<C, O> sourceType = seqType;
        Object elemType = seqType.getElementType();
        switch (opcode) {
            case 140: 
            case 160: {
                return stdlib.getInteger();
            }
            case 60: 
            case 61: {
                return stdlib.getBoolean();
            }
            case 157: {
                C argType = args.get(0).getType();
                C argElementType = OCLStandardLibraryUtil.getElementType(argType);
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argElementType));
            }
            case 155: 
            case 163: 
            case 165: {
                C argType = args.get(0).getType();
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argType));
            }
            case 161: {
                C argType = args.get(1).getType();
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, TypeUtil.commonSuperType(problemObject, env, elemType, argType));
            }
            case 153: {
                return (C)sourceType;
            }
            case 154: {
                if (!(elemType instanceof CollectionType)) {
                    return (C)sourceType;
                }
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, CollectionUtil.getFlattenedElementType(seqType));
            }
            case 158: 
            case 159: 
            case 162: {
                return elemType;
            }
            case 149: {
                return OCLStandardLibraryUtil.getBagType(env, oclFactory, elemType);
            }
            case 151: 
            case 164: {
                return (C)sourceType;
            }
            case 152: {
                return OCLStandardLibraryUtil.getSetType(env, oclFactory, elemType);
            }
            case 150: {
                return OCLStandardLibraryUtil.getOrderedSetType(env, oclFactory, elemType);
            }
            case 209: 
            case 210: 
            case 211: {
                return (C)sourceType;
            }
            case 207: {
                return OCLStandardLibraryUtil.getSequenceType(env, oclFactory, stdlib.getT2());
            }
        }
        return OCLStandardLibraryUtil.getCollectionTypeResultTypeOf(problemObject, env, seqType, opcode, args);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getCollectionTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, CollectionType<C, O> collType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        switch (opcode) {
            case 20: 
            case 140: {
                return stdlib.getInteger();
            }
            case 60: 
            case 61: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                return stdlib.getBoolean();
            }
            case 148: {
                C type = collType.getElementType();
                if (type != stdlib.getReal() && type != stdlib.getInteger()) {
                    String message = OCLMessages.SumOperator_ERROR_;
                    OCLStandardLibraryUtil.error(env, message, "collectionTypeResultTypeOf", problemObject);
                    return null;
                }
                return type;
            }
            case 147: {
                C t = collType.getElementType();
                C argType = args.get(0).getType();
                C t2 = OCLStandardLibraryUtil.getElementType(argType);
                OCLFactory oclFactory = env.getOCLFactory();
                return OCLStandardLibraryUtil.getSetType(env, oclFactory, OCLStandardLibraryUtil.getTupleType(env, oclFactory, OCLStandardLibraryUtil.createTupleParts(env, t, t2)));
            }
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                return stdlib.getBoolean();
            }
            case 205: {
                return collType.getElementType();
            }
            case 206: {
                return OCLStandardLibraryUtil.getCollectionType(env, env.getOCLFactory(), stdlib.getT2());
            }
            case 208: {
                return OCLStandardLibraryUtil.getSetType(env, env.getOCLFactory(), stdlib.getT2());
            }
        }
        String message = OCLMessages.bind(OCLMessages.CollectionType_ERROR_, collType.getName(), OCLStandardLibraryUtil.getOperationName(opcode));
        OCLStandardLibraryUtil.error(env, message, "collectionTypeResultTypeOf", problemObject);
        return null;
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> EList<Variable<C, PM>> createTupleParts(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, C firstType, C secondType) {
        BasicEList<Variable<C, PM>> result = new BasicEList<Variable<C, PM>>();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        OCLFactory oclFactory = env.getOCLFactory();
        Variable var = oclFactory.createVariable();
        uml.setName(var, PRODUCT_FIRST);
        uml.setType(var, firstType);
        result.add(var);
        var = oclFactory.createVariable();
        uml.setName(var, PRODUCT_SECOND);
        uml.setType(var, secondType);
        result.add(var);
        return result;
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getTypeTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, TypeType<C, O> typeType, int opcode, List<? extends TypedElement<C>> args) {
        switch (opcode) {
            case 40: {
                return OCLStandardLibraryUtil.getSetType(env, env.getOCLFactory(), typeType.getReferredType());
            }
        }
        TypeType<C, O> sourceType = typeType;
        return (C)OCLStandardLibraryUtil.getAnyTypeResultTypeOf(problemObject, env, sourceType, opcode, args);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getMessageTypeResultTypeOf(Object problemObject, Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, MessageType<C, O, P> messageType, int opcode, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        switch (opcode) {
            case 100: 
            case 102: 
            case 103: {
                return stdlib.getBoolean();
            }
            case 101: {
                return messageType.getReferredOperation() == null ? stdlib.getOclInvalid() : TypeUtil.resolveType(env, uml.getOCLType(messageType.getReferredOperation()));
            }
        }
        MessageType<C, O, P> sourceType = messageType;
        return (C)OCLStandardLibraryUtil.getAnyTypeResultTypeOf(problemObject, env, sourceType, opcode, args);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createAnyOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(9);
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "=", stdlib.getOclAny(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<>", stdlib.getOclAny(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getT(), "oclAsType", stdlib.getOclType(), "typespec"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "oclIsKindOf", stdlib.getOclType(), "typespec"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "oclIsTypeOf", stdlib.getOclType(), "typespec"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "oclIsUndefined"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "oclIsInvalid"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "oclIsNew"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "oclIsInState", stdlib.getState(), "statespec"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createAnyTypeOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(13);
        result.addAll(OCLStandardLibraryUtil.createAnyOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<=", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">=", stdlib.getT(), "object"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createTypeTypeOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(10);
        result.addAll(OCLStandardLibraryUtil.createAnyOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        result.add(OCLStandardLibraryUtil.createUnaryOperation(env.getUMLReflection(), stdlib.getSet(), "allInstances"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createMessageTypeOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(13);
        result.addAll(OCLStandardLibraryUtil.createAnyOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "hasReturned"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getT(), "result"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "isSignalSent"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "isOperationCall"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createStringOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(20);
        result.addAll(OCLStandardLibraryUtil.createAnyOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<", stdlib.getString(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">", stdlib.getString(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<=", stdlib.getString(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">=", stdlib.getString(), "s"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getInteger(), "size"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getString(), "concat", stdlib.getString(), "s"));
        result.add(OCLStandardLibraryUtil.createTernaryOperation(uml, stdlib.getString(), "substring", stdlib.getInteger(), "lower", stdlib.getInteger(), "upper"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getInteger(), "toInteger"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getReal(), "toReal"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getString(), "toLower"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getString(), "toUpper"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createRealOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(23);
        result.addAll(OCLStandardLibraryUtil.createAnyOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<=", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">=", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getReal(), "+", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getReal(), "-", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getReal(), "-"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getReal(), "*", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getReal(), "/", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getReal(), "min", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getReal(), "max", stdlib.getReal(), "r"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getReal(), "abs"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getInteger(), "floor"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getInteger(), "round"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createIntegerOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(29);
        result.addAll(OCLStandardLibraryUtil.createRealOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<", stdlib.getInteger(), "i"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">", stdlib.getInteger(), "i"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<=", stdlib.getInteger(), "i"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">=", stdlib.getInteger(), "i"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "div", stdlib.getInteger(), "i"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "mod", stdlib.getInteger(), "i"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createUnlimitedNaturalOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(29);
        result.addAll(OCLStandardLibraryUtil.createRealOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<", stdlib.getUnlimitedNatural(), "n"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">", stdlib.getUnlimitedNatural(), "n"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<=", stdlib.getUnlimitedNatural(), "n"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), ">=", stdlib.getUnlimitedNatural(), "n"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "div", stdlib.getUnlimitedNatural(), "n"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "mod", stdlib.getUnlimitedNatural(), "n"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createBooleanOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(14);
        result.addAll(OCLStandardLibraryUtil.createAnyOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "not"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "and", stdlib.getBoolean(), "b"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "or", stdlib.getBoolean(), "b"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "implies", stdlib.getBoolean(), "b"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "xor", stdlib.getBoolean(), "b"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createCollectionOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(10);
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "=", stdlib.getCollection(), "c"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<>", stdlib.getCollection(), "c"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "count", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "excludes", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "excludesAll", stdlib.getCollection(), "c2"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "includes", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "includesAll", stdlib.getCollection(), "c2"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "isEmpty"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "notEmpty"));
        OCLFactory oclFactory = env.getOCLFactory();
        C resultType = OCLStandardLibraryUtil.getSetType(env, oclFactory, OCLStandardLibraryUtil.getTupleType(env, oclFactory, OCLStandardLibraryUtil.createTupleParts(env, stdlib.getT(), stdlib.getT2())));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, resultType, "product", OCLStandardLibraryUtil.getCollectionType(env, oclFactory, stdlib.getT2()), "c2"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getReal(), "sum"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getInteger(), "size"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createSetOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(25);
        result.addAll(OCLStandardLibraryUtil.createCollectionOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "=", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<>", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "union", stdlib.getBag(), "bag"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "union", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "-", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "intersection", stdlib.getBag(), "bag"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "intersection", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "including", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "excluding", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "symmetricDifference", stdlib.getSet(), "s"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, OCLStandardLibraryUtil.getSetType(env, env.getOCLFactory(), stdlib.getT2()), "flatten"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBag(), "asBag"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getSet(), "asSet"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getSequence(), "asSequence"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getOrderedSet(), "asOrderedSet"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createOrderedSetOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(35);
        result.addAll(OCLStandardLibraryUtil.createSetOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "=", stdlib.getOrderedSet(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<>", stdlib.getOrderedSet(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getOrderedSet(), "append", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getT(), "at", stdlib.getInteger(), "index"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "indexOf", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createTernaryOperation(uml, stdlib.getOrderedSet(), "insertAt", stdlib.getInteger(), "index", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getOrderedSet(), "prepend", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createTernaryOperation(uml, stdlib.getOrderedSet(), "subOrderedSet", stdlib.getInteger(), "lower", stdlib.getInteger(), "upper"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getT(), PRODUCT_FIRST));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getT(), "last"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createBagOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(23);
        result.addAll(OCLStandardLibraryUtil.createCollectionOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "=", stdlib.getBag(), "bag"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<>", stdlib.getBag(), "bag"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "union", stdlib.getBag(), "bag"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "union", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "intersection", stdlib.getBag(), "bag"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "intersection", stdlib.getSet(), "set"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "including", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "excluding", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, OCLStandardLibraryUtil.getBagType(env, env.getOCLFactory(), stdlib.getT2()), "flatten"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBag(), "asBag"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getSet(), "asSet"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getSequence(), "asSequence"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getOrderedSet(), "asOrderedSet"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createSequenceOperations(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(28);
        result.addAll(OCLStandardLibraryUtil.createCollectionOperations(env));
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "=", stdlib.getSequence(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "<>", stdlib.getSequence(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSequence(), "union", stdlib.getSequence(), "s"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "append", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "prepend", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createTernaryOperation(uml, stdlib.getBoolean(), "insertAt", stdlib.getInteger(), "index", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createTernaryOperation(uml, stdlib.getBoolean(), "subSequence", stdlib.getInteger(), "lower", stdlib.getInteger(), "upper"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getT(), "at", stdlib.getInteger(), "index"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getInteger(), "indexOf", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "including", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "excluding", stdlib.getT(), "object"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getT(), PRODUCT_FIRST));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getT(), "last"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, OCLStandardLibraryUtil.getSequenceType(env, env.getOCLFactory(), stdlib.getT2()), "flatten"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBag(), "asBag"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getSet(), "asSet"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getBoolean(), "asSequence"));
        result.add(OCLStandardLibraryUtil.createUnaryOperation(uml, stdlib.getOrderedSet(), "asOrderedSet"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createCollectionIterators(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(7);
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "exists", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "forAll", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "isUnique", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBoolean(), "one", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getT(), "any", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, OCLStandardLibraryUtil.getCollectionType(env, env.getOCLFactory(), stdlib.getT2()), "collect", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, OCLStandardLibraryUtil.getSetType(env, env.getOCLFactory(), stdlib.getT2()), "closure", stdlib.getOclExpression(), "expr"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createSetIterators(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(11);
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        result.addAll(OCLStandardLibraryUtil.createCollectionIterators(env));
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "select", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSet(), "reject", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getOrderedSet(), "sortedBy", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, OCLStandardLibraryUtil.getBagType(env, env.getOCLFactory(), stdlib.getT2()), "collectNested", stdlib.getOclExpression(), "expr"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createOrderedSetIterators(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(11);
        result.addAll(OCLStandardLibraryUtil.createSetIterators(env));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createBagIterators(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(11);
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        result.addAll(OCLStandardLibraryUtil.createCollectionIterators(env));
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "select", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getBag(), "reject", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSequence(), "sortedBy", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, OCLStandardLibraryUtil.getBagType(env, env.getOCLFactory(), stdlib.getT2()), "collectNested", stdlib.getOclExpression(), "expr"));
        return result;
    }

    public static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> List<O> createSequenceIterators(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env) {
        ArrayList<O> result = new ArrayList<O>(11);
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml = env.getUMLReflection();
        result.addAll(OCLStandardLibraryUtil.createCollectionIterators(env));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSequence(), "select", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSequence(), "reject", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, stdlib.getSequence(), "sortedBy", stdlib.getOclExpression(), "expr"));
        result.add(OCLStandardLibraryUtil.createBinaryOperation(uml, OCLStandardLibraryUtil.getSequenceType(env, env.getOCLFactory(), stdlib.getT2()), "collectNested", stdlib.getOclExpression(), "expr"));
        return result;
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> O createUnaryOperation(UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml, C resultType, String name) {
        List<String> paramNames = Collections.emptyList();
        List paramTypes = Collections.emptyList();
        return uml.createOperation(name, resultType, paramNames, paramTypes);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> O createBinaryOperation(UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml, C resultType, String name, C paramType, String paramName) {
        List<String> paramNames = Collections.singletonList(paramName);
        List<C> paramTypes = Collections.singletonList(paramType);
        return uml.createOperation(name, resultType, paramNames, paramTypes);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> O createTernaryOperation(UMLReflection<PK, C, O, P, EL, PM, ST, COA, SSA, CT> uml, C resultType, String name, C param1Type, String param1Name, C param2Type, String param2Name) {
        ArrayList<String> paramNames = new ArrayList<String>(2);
        ArrayList<C> paramTypes = new ArrayList<C>(2);
        paramNames.add(param1Name);
        paramTypes.add(param1Type);
        paramNames.add(param2Name);
        paramTypes.add(param2Type);
        return uml.createOperation(name, resultType, paramNames, paramTypes);
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getBagType(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OCLFactory factory, C elementType) {
        return (C)TypeUtil.resolveType(env, factory.createBagType(elementType));
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getSetType(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OCLFactory factory, C elementType) {
        return (C)TypeUtil.resolveType(env, factory.createSetType(elementType));
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getOrderedSetType(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OCLFactory factory, C elementType) {
        return (C)TypeUtil.resolveType(env, factory.createOrderedSetType(elementType));
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getSequenceType(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OCLFactory factory, C elementType) {
        return (C)TypeUtil.resolveType(env, factory.createSequenceType(elementType));
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getCollectionType(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OCLFactory factory, C elementType) {
        return (C)TypeUtil.resolveType(env, factory.createCollectionType(elementType));
    }

    private static <PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> C getTupleType(Environment<PK, C, O, P, EL, PM, ST, COA, SSA, CT, CLS, E> env, OCLFactory factory, List<? extends TypedElement<C>> parts) {
        return (C)TypeUtil.resolveType(env, factory.createTupleType(parts));
    }

    private static void error(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env, String problemMessage, String problemContext, Object problemObject) {
        OCLUtil.getAdapter(env, BasicEnvironment.class).utilityError(problemMessage, problemContext, problemObject);
    }

    private static void warning(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env, String problemMessage, String problemContext, Object problemObject) {
        BasicEnvironment benv = OCLUtil.getAdapter(env, BasicEnvironment.class);
        if (benv != null) {
            CSTNode cstNode = benv.getASTMapping(problemObject);
            int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
            int endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
            benv.getProblemHandler().utilityProblem(ProblemHandler.Severity.WARNING, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    public static <C> Collection<C> getAllSupertypes(Environment<?, C, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env, PredefinedType<?> type) {
        Collection<Object> result;
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        if (type instanceof CollectionType) {
            CollectionType collType = (CollectionType)type;
            switch (collType.getKind()) {
                case ORDERED_SET_LITERAL: {
                    result = Arrays.asList(stdlib.getSet(), stdlib.getCollection());
                    break;
                }
                case COLLECTION_LITERAL: {
                    result = Collections.emptySet();
                    break;
                }
                default: {
                    result = Collections.singleton(stdlib.getCollection());
                    break;
                }
            }
        } else {
            result = type == stdlib.getInteger() ? Arrays.asList(stdlib.getReal(), stdlib.getOclAny()) : (type instanceof AnyType ? Collections.emptySet() : Collections.singleton(stdlib.getOclAny()));
        }
        return result;
    }
}

