/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.common.HandleObject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.CommandStateProxy;
import org.eclipse.ui.internal.commands.Parameter;
import org.eclipse.ui.internal.commands.ParameterValueConverterProxy;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.internal.util.PrefUtil;

public final class CommandPersistence
extends RegistryPersistence {
    private static final int INDEX_CATEGORY_DEFINITIONS = 0;
    private static final int INDEX_COMMAND_DEFINITIONS = 1;
    private static final int INDEX_PARAMETER_TYPE_DEFINITIONS = 2;
    private final ICommandService commandService;

    private static final void readCategoriesFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, ICommandService commandService) {
        Category[] handleObjects = commandService.getDefinedCategories();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                ((HandleObject)handleObjects[i]).undefine();
                ++i;
            }
        }
        commandService.defineUncategorizedCategory(WorkbenchMessages.CommandService_AutogeneratedCategoryName, WorkbenchMessages.CommandService_AutogeneratedCategoryDescription);
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String name;
            IConfigurationElement configurationElement = configurationElements[i];
            String categoryId = CommandPersistence.readRequired(configurationElement, "id", warningsToLog, "Categories need an id");
            if (categoryId != null && (name = CommandPersistence.readRequired(configurationElement, "name", warningsToLog, "Categories need a name", categoryId)) != null) {
                String description = CommandPersistence.readOptional(configurationElement, "description");
                Category category = commandService.getCategory(categoryId);
                category.define(name, description);
            }
            ++i;
        }
        CommandPersistence.logWarnings(warningsToLog, "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.");
    }

    private static final void readCommandsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, ICommandService commandService) {
        Command[] handleObjects = commandService.getDefinedCommands();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                ((HandleObject)handleObjects[i]).undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String name;
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = CommandPersistence.readRequired(configurationElement, "id", warningsToLog, "Commands need an id");
            if (commandId != null && (name = CommandPersistence.readRequired(configurationElement, "name", warningsToLog, "Commands need a name")) != null) {
                String description = CommandPersistence.readOptional(configurationElement, "description");
                String categoryId = configurationElement.getAttribute("categoryId");
                if ((categoryId == null || categoryId.length() == 0) && (categoryId = configurationElement.getAttribute("category")) != null && categoryId.length() == 0) {
                    categoryId = null;
                }
                IParameter[] parameters = CommandPersistence.readParameters(configurationElement, warningsToLog, commandService);
                String returnTypeId = CommandPersistence.readOptional(configurationElement, "returnTypeId");
                String helpContextId = CommandPersistence.readOptional(configurationElement, "helpContextId");
                Command command = commandService.getCommand(commandId);
                Category category = commandService.getCategory(categoryId);
                if (!category.isDefined()) {
                    CommandPersistence.addWarning(warningsToLog, "Commands should really have a category", configurationElement, commandId, "categoryId", categoryId);
                }
                ParameterType returnType = returnTypeId == null ? null : commandService.getParameterType(returnTypeId);
                command.define(name, description, category, parameters, returnType, helpContextId);
                CommandPersistence.readState(configurationElement, warningsToLog, command);
            }
            ++i;
        }
        CommandPersistence.logWarnings(warningsToLog, "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.");
    }

    private static final Parameter[] readParameters(IConfigurationElement configurationElement, List warningsToLog, ICommandService commandService) {
        IConfigurationElement[] parameterElements = configurationElement.getChildren("commandParameter");
        if (parameterElements == null || parameterElements.length == 0) {
            return null;
        }
        int insertionIndex = 0;
        Parameter[] parameters = new Parameter[parameterElements.length];
        int i = 0;
        while (i < parameterElements.length) {
            String name;
            IConfigurationElement parameterElement = parameterElements[i];
            String id = CommandPersistence.readRequired(parameterElement, "id", warningsToLog, "Parameters need an id");
            if (id != null && (name = CommandPersistence.readRequired(parameterElement, "name", warningsToLog, "Parameters need a name")) != null) {
                String typeId = CommandPersistence.readOptional(parameterElement, "typeId");
                boolean optional = CommandPersistence.readBoolean(parameterElement, "optional", true);
                ParameterType type = typeId == null ? null : commandService.getParameterType(typeId);
                Parameter parameter = new Parameter(id, name, parameterElement, type, optional);
                parameters[insertionIndex++] = parameter;
            }
            ++i;
        }
        if (insertionIndex != parameters.length) {
            Parameter[] compactedParameters = new Parameter[insertionIndex];
            System.arraycopy(parameters, 0, compactedParameters, 0, insertionIndex);
            parameters = compactedParameters;
        }
        return parameters;
    }

    private static final void readParameterTypesFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, ICommandService commandService) {
        ParameterType[] handleObjects = commandService.getDefinedParameterTypes();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                ((HandleObject)handleObjects[i]).undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String parameterTypeId = CommandPersistence.readRequired(configurationElement, "id", warningsToLog, "Command parameter types need an id");
            if (parameterTypeId != null) {
                String type = CommandPersistence.readOptional(configurationElement, "type");
                String converter = CommandPersistence.readOptional(configurationElement, "converter");
                ParameterValueConverterProxy parameterValueConverter = converter == null ? null : new ParameterValueConverterProxy(configurationElement);
                ParameterType parameterType = commandService.getParameterType(parameterTypeId);
                parameterType.define(type, parameterValueConverter);
            }
            ++i;
        }
        CommandPersistence.logWarnings(warningsToLog, "Warnings while parsing the commandParameterTypes from the 'org.eclipse.ui.commands' extension point.");
    }

    private static final void readState(IConfigurationElement configurationElement, List warningsToLog, Command command) {
        IConfigurationElement[] stateElements = configurationElement.getChildren("state");
        if (stateElements == null || stateElements.length == 0) {
            return;
        }
        int i = 0;
        while (i < stateElements.length) {
            IConfigurationElement stateElement = stateElements[i];
            String id = CommandPersistence.readRequired(stateElement, "id", warningsToLog, "State needs an id");
            if (id != null && CommandPersistence.checkClass(stateElement, warningsToLog, "State must have an associated class", id)) {
                CommandStateProxy state = new CommandStateProxy(stateElement, "class", PrefUtil.getInternalPreferenceStore(), CommandService.createPreferenceKey(command, id));
                command.addState(id, state);
            }
            ++i;
        }
    }

    CommandPersistence(ICommandService commandService) {
        if (commandService == null) {
            throw new NullPointerException("The command service cannot be null");
        }
        this.commandService = commandService;
    }

    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        return false;
    }

    public boolean commandsNeedUpdating(IRegistryChangeEvent event) {
        IExtensionDelta[] actionDefinitionDeltas;
        IExtensionDelta[] commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands");
        return commandDeltas.length != 0 || (actionDefinitionDeltas = event.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length != 0;
    }

    protected final void read() {
        super.read();
        this.reRead();
    }

    public void reRead() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int commandDefinitionCount = 0;
        int categoryDefinitionCount = 0;
        int parameterTypeDefinitionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[3][];
        IConfigurationElement[] commandsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int i = 0;
        while (i < commandsExtensionPoint.length) {
            IConfigurationElement configurationElement = commandsExtensionPoint[i];
            String name = configurationElement.getName();
            if ("command".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, commandDefinitionCount++);
            } else if ("category".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, categoryDefinitionCount++);
            } else if ("commandParameterType".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, parameterTypeDefinitionCount++);
            }
            ++i;
        }
        IConfigurationElement[] actionDefinitionsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.actionDefinitions");
        int i2 = 0;
        while (i2 < actionDefinitionsExtensionPoint.length) {
            IConfigurationElement configurationElement = actionDefinitionsExtensionPoint[i2];
            String name = configurationElement.getName();
            if ("actionDefinition".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, commandDefinitionCount++);
            }
            ++i2;
        }
        CommandPersistence.readCategoriesFromRegistry(indexedConfigurationElements[0], categoryDefinitionCount, this.commandService);
        CommandPersistence.readCommandsFromRegistry(indexedConfigurationElements[1], commandDefinitionCount, this.commandService);
        CommandPersistence.readParameterTypesFromRegistry(indexedConfigurationElements[2], parameterTypeDefinitionCount, this.commandService);
    }
}

