/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.conflicts.detection.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.UpdateUpdate;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.impl.UpdateUpdateConflictDetector;
import org.modelversioning.core.diff.util.DiffUtil;

public class MultivaluedFeatureUpdateConflictDetector
extends UpdateUpdateConflictDetector {
    private static final String NAME = "Multivalued Feature Update Conflict Detector";
    private Set<DiffElement> ignoredDiffElements = new HashSet<DiffElement>();

    @Override
    public String getId() {
        return "org.modelversioning.conflicts.detection.multivaluedUpdate";
    }

    @Override
    public String getTargetModelNsURI() {
        return "*";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void detectOverlappingChanges(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        EList<EObject> updatedEObjects = threeWayDiff.getUpdatedEObjects(Side.LEFT, false);
        HashMap<EObject, EList<DiffElement>> leftChangeSequences = new HashMap<EObject, EList<DiffElement>>();
        HashMap<EObject, EList<DiffElement>> rightChangeSequences = new HashMap<EObject, EList<DiffElement>>();
        monitor.beginTask("Searching for Update Update conflicts", updatedEObjects.size());
        try {
            for (EObject updatedObject : updatedEObjects) {
                if (threeWayDiff.isUpdated(updatedObject, Side.RIGHT, false)) {
                    Set<DiffElement> leftUpdates = threeWayDiff.getUpdateElements(updatedObject, Side.LEFT);
                    for (DiffElement leftUpdate : leftUpdates) {
                        EStructuralFeature feature = DiffUtil.getUpdatedFeature(leftUpdate);
                        if (feature == null || !this.shouldRaiseConflictForFeature(feature) || !threeWayDiff.isUpdated(updatedObject, feature, Side.RIGHT)) continue;
                        this.collectChangeSequences(leftChangeSequences, leftUpdate, feature, Side.LEFT, threeWayDiff);
                        HashSet<DiffElement> rightUpdates = new HashSet<DiffElement>(threeWayDiff.getUpdateElements(updatedObject, feature, Side.RIGHT));
                        for (DiffElement rightUpdate : rightUpdates) {
                            this.collectChangeSequences(rightChangeSequences, rightUpdate, feature, Side.RIGHT, threeWayDiff);
                        }
                    }
                }
                monitor.worked(1);
            }
            this.checkForConflict(leftChangeSequences, rightChangeSequences, conflicts);
        }
        finally {
            monitor.done();
        }
    }

    private void checkForConflict(HashMap<EObject, EList<DiffElement>> leftChangeSequences, HashMap<EObject, EList<DiffElement>> rightChangeSequences, EList<Conflict> conflicts) {
        for (EObject lastOrigin : leftChangeSequences.keySet()) {
            if (!rightChangeSequences.containsKey(lastOrigin)) continue;
            DiffGroup leftUpdate = DiffPackage.eINSTANCE.getDiffFactory().createDiffGroup();
            leftUpdate.setRightParent(DiffUtil.getRightParent((DiffElement)leftChangeSequences.get(lastOrigin).get(0)));
            leftUpdate.getSubDiffElements().addAll((Collection<DiffElement>)leftChangeSequences.get(lastOrigin));
            DiffGroup rightUpdate = DiffPackage.eINSTANCE.getDiffFactory().createDiffGroup();
            rightUpdate.setRightParent(DiffUtil.getRightParent((DiffElement)rightChangeSequences.get(lastOrigin).get(0)));
            rightUpdate.getSubDiffElements().addAll((Collection<DiffElement>)rightChangeSequences.get(lastOrigin));
            if (this.shouldIgnore(rightUpdate) || this.shouldIgnore(leftUpdate, rightUpdate)) continue;
            UpdateUpdate updateUpdate = CONFLICT_FACTORY.createUpdateUpdate();
            updateUpdate.setLeftChange(leftUpdate);
            updateUpdate.setRightChange(rightUpdate);
            conflicts.add(updateUpdate);
        }
    }

    @Override
    protected boolean shouldIgnore(DiffElement diffElement) {
        return this.ignoredDiffElements.contains(diffElement);
    }

    @Override
    protected boolean shouldIgnore(DiffElement leftDiffElement, DiffElement rightDiffElement) {
        return false;
    }

    @Override
    protected boolean shouldRaiseConflictForFeature(EStructuralFeature feature) {
        return feature.isMany() && feature.isOrdered();
    }

    @Override
    public void initialize() {
    }

    private EObject getLastOrigin(DiffElement update, EStructuralFeature feature, Side side, IThreeWayDiffProvider threeWayDiff) {
        EObject originElement;
        BasicEList originReference;
        EObject leftElement;
        BasicEList leftReference;
        EObject lastOrigin = null;
        EObject leftReferenceAddObject = DiffUtil.getLeftElement(update);
        int index = this.getLastOriginIndex(leftReferenceAddObject, leftReference = (BasicEList)(leftElement = leftReferenceAddObject.eContainer()).eGet(feature), originReference = (BasicEList)(originElement = DiffUtil.getRightParent(update)).eGet(feature), side, threeWayDiff, -1);
        if (index > -1 && index < originReference.size()) {
            lastOrigin = (EObject)originReference.get(index);
        }
        return lastOrigin;
    }

    private int getLastOriginIndex(EObject leftReferenceAddObject, EList<EObject> leftReference, EList<EObject> originReference, Side side, IThreeWayDiffProvider threeWayDiff, int index) {
        int leftIndex = leftReference.indexOf(leftReferenceAddObject);
        EObject matchObject = threeWayDiff.getMatchingEObject(leftReferenceAddObject, side, true);
        if (matchObject != null) {
            index = originReference.indexOf(matchObject);
            return index;
        }
        if (leftIndex > 0) {
            return this.getLastOriginIndex((EObject)leftReference.get(leftIndex - 1), leftReference, originReference, side, threeWayDiff, index);
        }
        return index;
    }

    private void collectChangeSequences(HashMap<EObject, EList<DiffElement>> changeSequence, DiffElement update, EStructuralFeature feature, Side side, IThreeWayDiffProvider threeWayDiff) {
        EObject lastOrigin = this.getLastOrigin(update, feature, side, threeWayDiff);
        if (changeSequence.get(lastOrigin) != null) {
            changeSequence.get(lastOrigin).add(update);
        } else {
            BasicEList<DiffElement> changes = new BasicEList<DiffElement>();
            changes.add(update);
            changeSequence.put(lastOrigin, changes);
        }
    }
}

