/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OneOperandType implements Enumerator
{
    OPT(0, "OPT", "OPT"),
    CRITICAL(1, "CRITICAL", "CRITICAL"),
    ASSERT(2, "ASSERT", "ASSERT"),
    IGNORE(3, "IGNORE", "IGNORE"),
    CONSIDER(4, "CONSIDER", "CONSIDER"),
    NEG(5, "NEG", "NEG"),
    LOOP(6, "LOOP", "LOOP"),
    BREAK(7, "BREAK", "BREAK");

    public static final int OPT_VALUE = 0;
    public static final int CRITICAL_VALUE = 1;
    public static final int ASSERT_VALUE = 2;
    public static final int IGNORE_VALUE = 3;
    public static final int CONSIDER_VALUE = 4;
    public static final int NEG_VALUE = 5;
    public static final int LOOP_VALUE = 6;
    public static final int BREAK_VALUE = 7;
    private static final OneOperandType[] VALUES_ARRAY;
    public static final List<OneOperandType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OneOperandType[]{OPT, CRITICAL, ASSERT, IGNORE, CONSIDER, NEG, LOOP, BREAK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OneOperandType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OneOperandType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OneOperandType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OneOperandType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OneOperandType get(int value) {
        switch (value) {
            case 0: {
                return OPT;
            }
            case 1: {
                return CRITICAL;
            }
            case 2: {
                return ASSERT;
            }
            case 3: {
                return IGNORE;
            }
            case 4: {
                return CONSIDER;
            }
            case 5: {
                return NEG;
            }
            case 6: {
                return LOOP;
            }
            case 7: {
                return BREAK;
            }
        }
        return null;
    }

    private OneOperandType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

