/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.engine.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReportFactory;
import org.modelevolution.multiview.diff.encoding.engine.ICnfParser;
import org.modelevolution.multiview.diff.encoding.engine.ILogObservable;
import org.modelevolution.multiview.diff.encoding.engine.impl.SequenceEncodingEngine;
import org.modelevolution.multiview.diff.encoding.engine.impl.TseitinState;
import org.modelevolution.multiview.merge.MergePosition;
import org.modelevolution.multiview.merge.MergeType;
import org.modelevolution.multiview.util.MessageComparator;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;

public class Sequence2SATDIMACSImprovedEncodingEngine
extends SequenceEncodingEngine
implements ICnfParser,
ILogObservable {
    private static final Logger logger = Logger.getLogger("org.modelevolution.multiview.diff.encoding.engine.impl");
    protected TreeMap<MergePosition, SortedSet<Message>> messages;
    protected HashMap<Message, MergeType> messageToMergeType;
    protected HashMap<Message, HashSet<Integer>> messageToPositions;
    protected HashMap<Integer, HashSet<Message>> positionToMessages;
    protected HashMap<Message, HashSet<State>> messageToSourceStates;
    protected HashMap<Message, HashSet<State>> messageToTargetStates;
    protected int startPos;
    protected int endPos;
    public static String VAR_EXT_MESSAGE = "M";
    public static String VAR_EXT_STATE = "S";
    private HashMap<String, Integer> varNames = new HashMap();
    private HashMap<Integer, String> variableMap;
    private int noClauses = 0;

    private int getVarNumber(String var) {
        if (!this.varNames.containsKey(var)) {
            this.varNames.put(var, this.varNames.size() + 3);
        }
        return this.varNames.get(var);
    }

    private int getTseitinVar() {
        int tseitin = this.varNames.size() + 3;
        String var = String.valueOf(tseitin);
        this.varNames.put(String.valueOf(var), tseitin);
        return this.varNames.get(var);
    }

    private void setVariableMap() {
        this.variableMap = new HashMap();
        for (String key : this.varNames.keySet()) {
            this.variableMap.put(this.varNames.get(key), key);
        }
    }

    @Override
    public String getVariable(int var) {
        return this.variableMap.get(var);
    }

    @Override
    public void generateEncoding(ThreeWayDiffProvider threeWayDiff, File output) throws IOException {
        String line;
        super.generateEncoding(threeWayDiff, output);
        long startTime = System.currentTimeMillis();
        this.initMessages(threeWayDiff);
        logObservations.put(ILogObservable.LogObservation.DIFF_POST, System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        FileWriter fstream = new FileWriter(String.valueOf(output.getCanonicalPath()) + ".tmp");
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("c Possible positions\n");
        this.printPossiblePositions(out);
        out.write("c Relative positions\n");
        this.printRelativePositions(out);
        out.write("c Positions\n");
        this.printPositions(out);
        out.write("c State machines\n");
        this.printStateMachines(out);
        HashSet<String> stateVars = this.getStateVars();
        out.write("c State machines XOR \n");
        this.printStatesXOR(out, stateVars);
        out.write("c Each index - source/target one state \n");
        this.printConstraintsStates(out);
        out.write("c Path constraints \n");
        this.printConstraintsPaths(out, stateVars);
        out.write("1" + this.endClause());
        out.write("-2" + this.endClause());
        out.close();
        FileWriter fstream2 = new FileWriter(output.getCanonicalPath());
        BufferedWriter out2 = new BufferedWriter(fstream2);
        this.printMapping(out2);
        out2.write("p cnf " + (this.varNames.size() + 2) + " " + this.noClauses + "\n");
        FileReader f = new FileReader(String.valueOf(output.getCanonicalPath()) + ".tmp");
        BufferedReader in = new BufferedReader(f);
        while ((line = in.readLine()) != null) {
            out2.write(String.valueOf(line) + "\n");
        }
        out2.close();
        in.close();
        new File(String.valueOf(output.getCanonicalPath()) + ".tmp").delete();
        for (Lifeline l : this.lifelines) {
            l.unsetDummyStatemachine();
        }
        this.setVariableMap();
        logObservations.put(ILogObservable.LogObservation.ENC, System.currentTimeMillis() - startTime);
        logObservations.put(ILogObservable.LogObservation.CNF_VAR_COUNT, new Long(this.varNames.size()));
        logObservations.put(ILogObservable.LogObservation.CNF_CLAUSE_COUNT, new Long(this.noClauses));
    }

    private HashSet<String> getStateVars() {
        HashSet<String> stateVars = new HashSet<String>();
        for (String key : this.varNames.keySet()) {
            if (!key.endsWith("_S")) continue;
            stateVars.add(key);
        }
        return stateVars;
    }

    private void printConstraintsPaths(BufferedWriter out, Set stateVars) throws IOException {
        int position = this.startPos;
        while (position < this.endPos) {
            for (Lifeline ll : this.lifelines) {
                Region sm = ll.getClass_().getStatemachine();
                if (sm.getStates().size() <= 1) continue;
                for (State stateStart : sm.getStates()) {
                    int tseitin = this.getTseitinVar();
                    if (stateVars.contains(this.getVariable(ll, stateStart, "t", position))) {
                        out.write("-" + this.getVarNumber(this.getVariable(ll, stateStart, "t", position)) + " " + tseitin + this.endClause());
                        for (State stateIllegal : sm.getStates()) {
                            if (stateStart.equals(stateIllegal)) continue;
                            if (stateVars.contains(this.getVariable(ll, stateIllegal, "s", position + 1))) {
                                out.write("-" + tseitin + " -" + this.getVarNumber(this.getVariable(ll, stateIllegal, "s", position + 1)) + this.endClause());
                                continue;
                            }
                            out.write(" 1" + this.endClause());
                        }
                    }
                    int j = position + 1;
                    while (j < this.endPos) {
                        if (stateVars.contains(this.getVariable(ll, stateStart, "t", position))) {
                            out.write("-" + this.getVarNumber(this.getVariable(ll, stateStart, "t", position)));
                            int k = position + 1;
                            while (k <= j) {
                                if (stateVars.contains(this.getVariable(ll, stateStart, "s", k))) {
                                    out.write(" " + this.getVarNumber(this.getVariable(ll, stateStart, "s", k)));
                                } else {
                                    out.write(" 2");
                                }
                                ++k;
                            }
                            tseitin = this.getTseitinVar();
                            out.write(" " + tseitin + this.endClause());
                            for (State stateIllegal : sm.getStates()) {
                                if (stateStart.equals(stateIllegal) || !stateVars.contains(this.getVariable(ll, stateIllegal, "s", j + 1))) continue;
                                out.write("-" + tseitin + " -" + this.getVarNumber(this.getVariable(ll, stateIllegal, "s", j + 1)) + this.endClause());
                            }
                        }
                        ++j;
                    }
                }
            }
            ++position;
        }
    }

    private String endClause() {
        ++this.noClauses;
        return " 0\n";
    }

    private void printConstraintsStates(BufferedWriter out) throws IOException {
        for (int position : this.positionToMessages.keySet()) {
            Region sm;
            for (Lifeline ll : this.lifelines) {
                sm = ll.getClass_().getStatemachine();
                for (State state : sm.getStates()) {
                    out.write(String.valueOf(this.getVarNumber(this.getVariable(ll, state, "s", position))) + " ");
                }
            }
            out.write(this.endClause());
            for (Lifeline ll : this.lifelines) {
                sm = ll.getClass_().getStatemachine();
                for (State state : sm.getStates()) {
                    out.write(String.valueOf(this.getVarNumber(this.getVariable(ll, state, "t", position))) + " ");
                }
            }
            out.write(this.endClause());
        }
    }

    private void printStateMachines(BufferedWriter out) throws IOException {
        for (Message m : this.messageToPositions.keySet()) {
            for (int position : this.messageToPositions.get(m)) {
                HashSet<TseitinState> tseitinVars = new HashSet<TseitinState>();
                out.write("-" + this.getVarNumber(this.getVariable(this.messageToMergeType.get(m), m, position)) + " ");
                Lifeline lifeline = m.getReceiver().getLifeline();
                Region sm = lifeline.getClass_().getStatemachine();
                for (State state : sm.getStates()) {
                    for (Transition transition : state.getOutgoing()) {
                        if (!transition.getTrigger().getName().equals(m.getBody().getName())) continue;
                        int tseitin = this.getTseitinVar();
                        tseitinVars.add(new TseitinState(tseitin, this.getVarNumber(this.getVariable(lifeline, transition.getSource(), "s", position))));
                        tseitinVars.add(new TseitinState(tseitin, this.getVarNumber(this.getVariable(lifeline, transition.getTarget(), "t", position))));
                        out.write(String.valueOf(tseitin) + " ");
                    }
                }
                out.write(this.endClause());
                for (TseitinState tseitin : tseitinVars) {
                    out.write("-" + tseitin.getTseitin() + " " + tseitin.getState() + this.endClause());
                }
            }
        }
    }

    private void printStatesXOR(BufferedWriter out, Set stateVars) throws IOException {
        int position = this.startPos;
        while (position <= this.endPos) {
            Region sm2;
            Region sm1;
            for (Lifeline ll1 : this.lifelines) {
                sm1 = ll1.getClass_().getStatemachine();
                for (State state1 : sm1.getStates()) {
                    for (Lifeline ll2 : this.lifelines) {
                        sm2 = ll2.getClass_().getStatemachine();
                        for (State state2 : sm2.getStates()) {
                            if (ll1.equals(ll2) && state1.equals(state2) || !stateVars.contains(this.getVariable(ll1, state1, "t", position)) || !stateVars.contains(this.getVariable(ll2, state2, "t", position))) continue;
                            out.write("-" + this.getVarNumber(this.getVariable(ll1, state1, "t", position)) + " -" + this.getVarNumber(this.getVariable(ll2, state2, "t", position)) + this.endClause());
                        }
                    }
                }
            }
            for (Lifeline ll1 : this.lifelines) {
                sm1 = ll1.getClass_().getStatemachine();
                for (State state1 : sm1.getStates()) {
                    for (Lifeline ll2 : this.lifelines) {
                        sm2 = ll2.getClass_().getStatemachine();
                        for (State state2 : sm2.getStates()) {
                            if (ll1.equals(ll2) && state1.equals(state2) || !stateVars.contains(this.getVariable(ll1, state1, "s", position)) || !stateVars.contains(this.getVariable(ll2, state2, "s", position))) continue;
                            out.write("-" + this.getVarNumber(this.getVariable(ll1, state1, "s", position)) + " -" + this.getVarNumber(this.getVariable(ll2, state2, "s", position)) + this.endClause());
                        }
                    }
                }
            }
            ++position;
        }
    }

    private void printPossiblePositions(BufferedWriter out) throws IOException {
        for (Message m : this.messageToPositions.keySet()) {
            MergeType mergeType = this.messageToMergeType.get(m);
            for (int index : this.messageToPositions.get(m)) {
                out.write(String.valueOf(this.getVarNumber(this.getVariable(mergeType, m, index))) + " ");
            }
            out.write(this.endClause());
        }
    }

    private void printRelativePositions(BufferedWriter out) throws IOException {
        for (Message m : this.messageToPositions.keySet()) {
            MergeType mergeType = this.messageToMergeType.get(m);
            if (this.messageToPositions.get(m).size() <= 1) continue;
            for (int startIndex : this.messageToPositions.get(m)) {
                for (Message n : this.messageToPositions.keySet()) {
                    if (n.getPosition() <= m.getPosition() || this.messageToMergeType.get(m) != this.messageToMergeType.get(n) || !this.messageToPositions.get(n).contains(startIndex)) continue;
                    out.write("-" + this.getVarNumber(this.getVariable(mergeType, m, startIndex)) + " ");
                    for (int followIndex : this.messageToPositions.get(n)) {
                        if (followIndex <= startIndex) continue;
                        out.write(String.valueOf(this.getVarNumber(this.getVariable(mergeType, n, followIndex))) + " ");
                    }
                    out.write(this.endClause());
                }
            }
        }
    }

    private void printPositions(BufferedWriter out) throws IOException {
        for (int position : this.positionToMessages.keySet()) {
            BasicEList<Message> currMessages = new BasicEList<Message>();
            for (Message m : this.positionToMessages.get(position)) {
                out.write(String.valueOf(this.getVarNumber(this.getVariable(this.messageToMergeType.get(m), m, position))) + " ");
                currMessages.add(m);
            }
            out.write(this.endClause());
            int i = 0;
            while (i < currMessages.size()) {
                int j = i;
                while (j < currMessages.size()) {
                    if (((Message)currMessages.get(i)).getPosition() != ((Message)currMessages.get(j)).getPosition() || this.messageToMergeType.get(currMessages.get(i)) != this.messageToMergeType.get(currMessages.get(j))) {
                        out.write("-" + this.getVarNumber(this.getVariable(this.messageToMergeType.get(currMessages.get(i)), (Message)currMessages.get(i), position)) + " -" + this.getVarNumber(this.getVariable(this.messageToMergeType.get(currMessages.get(j)), (Message)currMessages.get(j), position)) + this.endClause());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private String getVariable(MergeType mergeType, Message m, int newIndex) {
        return String.valueOf(newIndex) + "-" + (Object)((Object)mergeType) + "-" + m.getPosition() + "-" + m.getBody().getName() + "_" + VAR_EXT_MESSAGE;
    }

    private String getVariable(Lifeline lifeline, State state, String p, int index) {
        return String.valueOf(index) + "-" + p + "-" + lifeline.getName() + "-" + state.getName() + "_" + VAR_EXT_STATE;
    }

    private void initMessages(ThreeWayDiffProvider threeWayDiff) {
        this.messages = new TreeMap();
        this.messageToMergeType = new HashMap();
        this.messageToPositions = new HashMap();
        this.positionToMessages = new HashMap();
        this.messageToSourceStates = new HashMap();
        this.messageToTargetStates = new HashMap();
        HashMap<Message, SortedSet<Message>> leftMergeGroups = new HashMap<Message, SortedSet<Message>>();
        HashMap<Message, SortedSet<Message>> rightMergeGroups = new HashMap<Message, SortedSet<Message>>();
        EList<EObject> leftAddedElements = threeWayDiff.getAddedEObjects(Side.LEFT, true);
        EList<EObject> rightAddedElements = threeWayDiff.getAddedEObjects(Side.RIGHT, true);
        this.initMergeGroups(leftAddedElements, leftMergeGroups, threeWayDiff, Side.LEFT);
        this.initMergeGroups(rightAddedElements, rightMergeGroups, threeWayDiff, Side.RIGHT);
        EList<Message> originMessages = ((MultiviewModel)threeWayDiff.getOriginModel().get(0)).getSequenceview().getOrderedMessages();
        int shift = 1;
        if ((shift += this.getMergeFragment(leftMergeGroups, rightMergeGroups, null, 0, 0)) > 1 && this.conflictReport != null) {
            if (originMessages.size() > 0) {
                this.addConflictFragment(null, (Message)originMessages.get(0));
            } else if (originMessages.size() == 0) {
                this.addConflictFragment(null, null);
            }
        }
        int i = 0;
        while (i < originMessages.size()) {
            Message originMessage = (Message)originMessages.get(i);
            TreeSet<Message> treeSet = new TreeSet<Message>();
            treeSet.add(originMessage);
            this.messages.put(new MergePosition(i + shift, MergeType.O), treeSet);
            int oldShift = shift;
            shift = this.getMergeFragment(leftMergeGroups, rightMergeGroups, originMessage, shift, i);
            if (shift != oldShift && this.conflictReport != null) {
                Message nextOriginMsg = i < originMessages.size() - 1 ? (Message)originMessages.get(i + 1) : null;
                this.addConflictFragment(originMessage, nextOriginMsg);
            }
            ++i;
        }
        for (MergePosition mp : this.messages.keySet()) {
            for (Message message : this.messages.get(mp)) {
                if (this.messageToPositions.containsKey(message)) {
                    this.messageToPositions.get(message).add(mp.getIndex());
                } else {
                    HashSet<Integer> positions = new HashSet<Integer>();
                    positions.add(mp.getIndex());
                    this.messageToPositions.put(message, positions);
                }
                this.messageToMergeType.put(message, mp.getType());
            }
        }
        for (MergePosition mp : this.messages.keySet()) {
            for (Message message : this.messages.get(mp)) {
                if (this.positionToMessages.containsKey(mp.getIndex())) {
                    this.positionToMessages.get(mp.getIndex()).add(message);
                    continue;
                }
                this.positionToMessages.put(mp.getIndex(), new HashSet());
                this.positionToMessages.get(mp.getIndex()).add(message);
            }
        }
        for (Message m : this.messageToPositions.keySet()) {
            HashSet<State> hashSet = new HashSet<State>();
            HashSet<State> targetStates = new HashSet<State>();
            Lifeline ll = m.getReceiver().getLifeline();
            if (ll.getClass_() == null || ll.getClass_().getStatemachine() == null) {
                ll.initDummyStatemachine();
            }
            Region smReceiver = ll.getClass_().getStatemachine();
            for (Transition t : m.getBody().getTriggers()) {
                if (smReceiver.getStates().contains(t.getSource())) {
                    hashSet.add(t.getSource());
                }
                if (!smReceiver.getStates().contains(t.getTarget())) continue;
                targetStates.add(t.getTarget());
            }
            this.messageToSourceStates.put(m, hashSet);
            this.messageToTargetStates.put(m, targetStates);
        }
        this.startPos = 1;
        this.endPos = this.positionToMessages.size();
    }

    private void addConflictFragment(Message lastOriginMsg, Message nextOriginMsg) {
        if (this.conflictReport != null) {
            ConflictFragment confFrag = ConflictReportFactory.eINSTANCE.createConflictFragment();
            confFrag.setLastOrigin(lastOriginMsg);
            confFrag.setNextOrigin(nextOriginMsg);
            this.conflictReport.getConflicts().add(confFrag);
        }
    }

    private int getMergeFragment(HashMap<Message, SortedSet<Message>> leftMergeGroups, HashMap<Message, SortedSet<Message>> rightMergeGroups, Message originMessage, int shift, int pos) {
        if (leftMergeGroups.get(originMessage) != null || rightMergeGroups.get(originMessage) != null) {
            int leftGroupsSize = 0;
            int rightGroupsSize = 0;
            if (leftMergeGroups.get(originMessage) != null) {
                leftGroupsSize = leftMergeGroups.get(originMessage).size();
            }
            if (rightMergeGroups.get(originMessage) != null) {
                rightGroupsSize = rightMergeGroups.get(originMessage).size();
            }
            int mergeGroupsSize = leftGroupsSize + rightGroupsSize;
            int i = 1;
            while (i <= mergeGroupsSize) {
                ++shift;
                if (leftMergeGroups.get(originMessage) != null) {
                    this.messages.put(new MergePosition(shift + pos, MergeType.L), leftMergeGroups.get(originMessage));
                }
                if (rightMergeGroups.get(originMessage) != null) {
                    this.messages.put(new MergePosition(shift + pos, MergeType.R), rightMergeGroups.get(originMessage));
                }
                ++i;
            }
        }
        return shift;
    }

    private void initMergeGroups(EList<EObject> addedElements, HashMap<Message, SortedSet<Message>> mergeGroups, ThreeWayDiffProvider threeWayDiff, Side side) {
        for (EObject addElement : addedElements) {
            Message addedMessage = null;
            if (addElement instanceof SendEvent) {
                addedMessage = ((SendEvent)addElement).getMessage();
            } else {
                if (!(addElement instanceof ReceiveEvent)) continue;
                addedMessage = ((ReceiveEvent)addElement).getMessage();
            }
            Message lastOrigin = this.getLastOrigin(addedMessage, side, threeWayDiff);
            if (mergeGroups.containsKey(lastOrigin)) {
                mergeGroups.get(lastOrigin).add(addedMessage);
                continue;
            }
            TreeSet<Message> addedMessages = new TreeSet<Message>(new MessageComparator());
            addedMessages.add(addedMessage);
            mergeGroups.put(lastOrigin, addedMessages);
        }
    }

    private Message getLastOrigin(Message message, Side side, ThreeWayDiffProvider threeWayDiff) {
        Message previous = message.getPrevious();
        if (previous == null) {
            return null;
        }
        EObject originPrevious = threeWayDiff.getMatchingEObject(previous, side, true);
        if (originPrevious == null) {
            return this.getLastOrigin(previous, side, threeWayDiff);
        }
        return (Message)originPrevious;
    }

    private SortedSet<Message> messagesAtIndexType(int index, MergeType mt) {
        MergePosition origin = new MergePosition(index, mt);
        return this.messages.get(origin);
    }

    private void printMapping(BufferedWriter out) {
        for (String v : this.varNames.keySet()) {
            try {
                out.write("c " + v + "\t\t" + this.varNames.get(v) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Long getLogObservation(ILogObservable.LogObservation observation) {
        return (Long)logObservations.get((Object)observation);
    }
}

