/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.engine.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.diff.encoding.engine.IEncodingEngine;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;

public abstract class SequenceEncodingEngine
implements IEncodingEngine {
    protected ConflictReport conflictReport;
    protected EList<Lifeline> lifelines;
    protected EList<Region> statemachines;
    protected EList<State> states;

    @Override
    public void generateEncoding(EList<Conflict> conflicts, ThreeWayDiffProvider threeWayDiff, File output) throws IOException {
        this.initLifelines(threeWayDiff);
        this.initStatemachines(threeWayDiff);
        this.initStates(threeWayDiff);
    }

    @Override
    public void generateEncoding(ThreeWayDiffProvider threeWayDiff, File output) throws IOException {
        this.generateEncoding(null, threeWayDiff, output);
    }

    @Override
    public void generateEncoding(ThreeWayDiffProvider threeWayDiff, ConflictReport conflictReport, File output) throws IOException {
        this.conflictReport = conflictReport;
        this.generateEncoding(threeWayDiff, output);
    }

    private void initStatemachines(ThreeWayDiffProvider threeWayDiff) {
        this.statemachines = new BasicEList<Region>();
        for (Lifeline lifeline : this.lifelines) {
            if (lifeline.getClass_() == null || lifeline.getClass_().getStatemachine() == null) {
                lifeline.initDummyStatemachine();
            }
            this.statemachines.add(lifeline.getClass_().getStatemachine());
        }
    }

    private void initStates(ThreeWayDiffProvider threeWayDiff) {
        this.states = new BasicEList<State>();
        for (Region statemachine : this.statemachines) {
            this.states.addAll(statemachine.getStates());
        }
    }

    private void initLifelines(ThreeWayDiffProvider threeWayDiff) {
        this.lifelines = new BasicEList<Lifeline>();
        SequenceView leftSequenceView = ((MultiviewModel)threeWayDiff.getLeftModel().get(0)).getSequenceview();
        this.lifelines.addAll(leftSequenceView.getLifelines());
        SequenceView rightSequenceView = ((MultiviewModel)threeWayDiff.getRightModel().get(0)).getSequenceview();
        for (Lifeline lifeline : rightSequenceView.getLifelines()) {
            if (threeWayDiff.getMatchingEObject(lifeline, Side.RIGHT, false) != null) continue;
            this.lifelines.add(lifeline);
        }
    }

    protected String flatten(EList<? extends EObject> elements, String featureName, String delimiter) {
        String s = "";
        EStructuralFeature feature = null;
        if (elements != null && elements.size() > 0) {
            for (EStructuralFeature f : ((EObject)elements.get(0)).eClass().getEAllStructuralFeatures()) {
                if (!f.getName().equals(featureName)) continue;
                feature = f;
                break;
            }
            int i = 0;
            while (i < elements.size()) {
                EObject e = (EObject)elements.get(i);
                s = String.valueOf(s) + e.eGet(feature);
                if (i < elements.size() - 1) {
                    s = String.valueOf(s) + delimiter;
                }
                ++i;
            }
        }
        return s;
    }

    protected String getStateMachineName(Lifeline lifeline) {
        String stateMachineName = "_";
        if (lifeline.getClass_() != null && lifeline.getClass_().getStatemachine() != null) {
            stateMachineName = lifeline.getClass_().getStatemachine().getName();
        }
        return stateMachineName;
    }
}

